/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;

public class DumpIntentionsAction
extends AnAction
implements DumbAware {
    public DumpIntentionsAction() {
        super(ActionsBundle.messagePointer("action.DumpIntentionsAction.text", new Object[0]));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            DumpIntentionsAction.$$$reportNull$$$0(0);
        }
        if ((file2 = FileChooser.chooseFile(FileChooserDescriptorFactory.createSingleFolderDescriptor(), e.getData(CommonDataKeys.PROJECT), null)) != null) {
            List<IntentionActionMetaData> list2 = IntentionManagerSettings.getInstance().getMetaData();
            File root = VfsUtilCore.virtualToIoFile(file2);
            Element el = new Element("root");
            HashMap<String, Element> categoryMap = new HashMap<String, Element>();
            for (IntentionActionMetaData metaData : list2) {
                try {
                    Element metadataElement = new Element("intention");
                    metadataElement.setAttribute("family", metaData.getFamily());
                    metadataElement.setAttribute("description", metaData.getDescription().getText());
                    String key = StringUtil.join(metaData.myCategory, ".");
                    Element element2 = DumpIntentionsAction.getCategoryElement(categoryMap, el, metaData, key, metaData.myCategory.length - 1);
                    element2.addContent(metadataElement);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                JdomKt.write((Parent)el, (Path)root.toPath().resolve("intentions.xml"));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private static Element getCategoryElement(Map<String, Element> categoryMap, Element rootElement, IntentionActionMetaData metaData, String key, int idx) {
        Element element2 = categoryMap.get(key);
        if (element2 == null) {
            element2 = new Element("category");
            element2.setAttribute("name", metaData.myCategory[idx]);
            categoryMap.put(key, element2);
            if (idx == 0) {
                rootElement.addContent(element2);
            } else {
                DumpIntentionsAction.getCategoryElement(categoryMap, rootElement, metaData, StringUtil.join(metaData.myCategory, 0, metaData.myCategory.length - 1, "."), idx - 1).addContent(element2);
            }
        }
        return element2;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpIntentionsAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.PROJECT) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/internal/DumpIntentionsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

