/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.StringSelection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DumpLookupElementWeights
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(DumpLookupElementWeights.class);

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpLookupElementWeights.$$$reportNull$$$0(0);
        }
        Editor editor = e.getData(CommonDataKeys.EDITOR);
        DumpLookupElementWeights.dumpLookupElementWeights((LookupImpl)LookupManager.getActiveLookup(editor));
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpLookupElementWeights.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        Editor editor = e.getData(CommonDataKeys.EDITOR);
        presentation.setEnabled(editor != null && LookupManager.getActiveLookup(editor) != null);
    }

    public static void dumpLookupElementWeights(LookupImpl lookup2) {
        LookupElement selected2 = lookup2.getCurrentItem();
        String sb = "selected: " + selected2;
        if (selected2 != null) {
            sb = sb + "\nprefix: " + lookup2.itemPattern(selected2);
        }
        sb = sb + "\nweights:\n" + StringUtil.join(DumpLookupElementWeights.getLookupElementWeights(lookup2, true), "\n");
        System.out.println(sb);
        LOG.info(sb);
        try {
            CopyPasteManager.getInstance().setContents(new StringSelection(sb));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<String> getLookupElementWeights(LookupImpl lookup2, boolean hideSingleValued) {
        Map<LookupElement, List<Pair<String, Object>>> weights = lookup2.getRelevanceObjects(lookup2.getItems(), hideSingleValued);
        return ContainerUtil.map(weights.entrySet(), entry -> ((LookupElement)entry.getKey()).getLookupString() + "\t" + StringUtil.join((Collection)entry.getValue(), pair -> (String)pair.first + "=" + pair.second, ", "));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/internal/DumpLookupElementWeights";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

