/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class DumpVfsInfoForExcludedFilesAction
extends DumbAwareAction {
    public DumpVfsInfoForExcludedFilesAction() {
        super(ActionsBundle.messagePointer("action.DumpVfsInfoForExcludedFilesAction.text", new Object[0]));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            DumpVfsInfoForExcludedFilesAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        HashSet excludeRoots = new HashSet();
        for (Module module2 : ModuleManager.getInstance(project2).getModules()) {
            Collections.addAll(excludeRoots, ModuleRootManager.getInstance(module2).getExcludeRootUrls());
        }
        for (DirectoryIndexExcludePolicy policy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions(project2)) {
            ContainerUtil.addAll(excludeRoots, policy.getExcludeUrlsForProject());
        }
        if (excludeRoots.isEmpty()) {
            System.out.println("No excluded roots found in project.");
        }
        for (String root : excludeRoots) {
            VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(root);
            if (file2 == null) {
                System.out.println(root + " not in VFS");
                continue;
            }
            DumpVfsInfoForExcludedFilesAction.dumpChildrenInDbRecursively(file2, 0);
        }
    }

    private static void dumpChildrenInDbRecursively(VirtualFile dir, int depth) {
        if (!(dir instanceof NewVirtualFile)) {
            System.out.println(dir.getPresentableUrl() + ": not in db (" + dir.getClass().getName() + ")");
            return;
        }
        ArrayList<NewVirtualFile> dirs = new ArrayList<NewVirtualFile>();
        int inDb = 0;
        int contentInDb = 0;
        int nullChildren = 0;
        PersistentFS persistentFS = PersistentFS.getInstance();
        if (persistentFS.wereChildrenAccessed(dir)) {
            for (String name : persistentFS.listPersisted(dir)) {
                ++inDb;
                NewVirtualFile child2 = ((NewVirtualFile)dir).refreshAndFindChild(name);
                if (child2 == null) {
                    ++nullChildren;
                    continue;
                }
                if (child2.isDirectory()) {
                    dirs.add(child2);
                    continue;
                }
                if (PersistentFS.getInstance().getCurrentContentId(child2) == 0) continue;
                ++contentInDb;
            }
        }
        System.out.print(dir.getPresentableUrl() + ": " + inDb + " children in db");
        if (contentInDb > 0) {
            System.out.print(", content of " + contentInDb + " files in db");
        }
        if (nullChildren > 0) {
            System.out.print(", " + nullChildren + " invalid files in db");
        }
        System.out.println();
        if (depth > 10) {
            System.out.println("too deep, skipping children");
        } else {
            for (VirtualFile virtualFile2 : dirs) {
                DumpVfsInfoForExcludedFilesAction.dumpChildrenInDbRecursively(virtualFile2, depth + 1);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/DumpVfsInfoForExcludedFilesAction", "actionPerformed"));
    }
}

