/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.ImageType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconsLoadTime
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(IconsLoadTime.class);
    private static final int STATS_LIMIT = 10000;
    private static final int FIXED_SCOPE = 100;
    private static final List<Integer> statsSVG = new ArrayList<Integer>();
    private static final List<Integer> statsPNG = new ArrayList<Integer>();

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            IconsLoadTime.$$$reportNull$$$0(0);
        }
        IconsLoadTime.log(false);
    }

    public static void log(boolean measureStartupLoad) {
        IconsLoadTime.log(measureStartupLoad, ImageType.IMG);
        IconsLoadTime.log(measureStartupLoad, ImageType.SVG);
    }

    private static void log(boolean measureStartupLoad, @NotNull ImageType type) {
        StatData data2;
        if (type == null) {
            IconsLoadTime.$$$reportNull$$$0(1);
        }
        if ((data2 = IconsLoadTime.getStatData(measureStartupLoad, type)) != null) {
            LOG.info(data2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static StatData getStatData(boolean measureStartupLoad, @NotNull ImageType type) {
        List<Integer> stats;
        if (type == null) {
            IconsLoadTime.$$$reportNull$$$0(2);
        }
        if ((stats = IconsLoadTime.getStats(type)).isEmpty()) {
            return null;
        }
        List<Integer> list2 = stats;
        synchronized (list2) {
            int size = stats.size();
            int sum = stats.stream().mapToInt(Integer::intValue).sum();
            int average = sum / size;
            int median = size % 2 == 0 ? stats.get(size / 2 - 1) + stats.get(size / 2) : stats.get(size / 2);
            return new StatData(type, measureStartupLoad, sum, average, median, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void measure(@NotNull ImageType type, int duration) {
        int size;
        List<Integer> stats;
        if (type == null) {
            IconsLoadTime.$$$reportNull$$$0(3);
        }
        if ((stats = IconsLoadTime.getStats(type)).size() > 10000) {
            ImageDescriptor.setLoadTimeConsumer(null);
        }
        List<Integer> list2 = stats;
        synchronized (list2) {
            stats.add(duration);
            size = stats.size();
        }
        if (size == 100) {
            IconsLoadTime.log(false, type);
        }
    }

    @NotNull
    private static List<Integer> getStats(@NotNull ImageType type) {
        if (type == null) {
            IconsLoadTime.$$$reportNull$$$0(4);
        }
        List<Integer> list2 = type == ImageType.SVG ? statsSVG : statsPNG;
        if (list2 == null) {
            IconsLoadTime.$$$reportNull$$$0(5);
        }
        return list2;
    }

    static {
        if (Boolean.getBoolean("idea.measure.icon.load.time")) {
            ImageDescriptor.setLoadTimeConsumer(IconsLoadTime::measure);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/IconsLoadTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/IconsLoadTime";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStatData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "measure";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStats";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StatData {
        public final ImageType type;
        public final boolean startup;
        public final int count;
        public final float totalTime;
        public final float averageTime;
        public final float medianTime;

        private StatData(@NotNull ImageType type, boolean startup, int totalTime, int averageTime, int medianTime, int count) {
            if (type == null) {
                StatData.$$$reportNull$$$0(0);
            }
            this.type = type;
            this.startup = startup;
            this.count = count;
            this.totalTime = (float)totalTime / 1000000.0f;
            this.averageTime = (float)averageTime / 1000000.0f;
            this.medianTime = (float)medianTime / 1000000.0f;
        }

        public String toString() {
            return (Object)((Object)this.type) + " load time: " + (this.startup ? "ide_startup=" : "total=") + String.format("%.02fms", Float.valueOf(this.totalTime)) + ", average=" + String.format("%.02fms", Float.valueOf(this.averageTime)) + ", median=" + String.format("%.02fms", Float.valueOf(this.medianTime)) + "; number of icons: " + this.count;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/internal/IconsLoadTime$StatData", "<init>"));
        }
    }
}

