/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBScrollPane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowNonRetinaImagesActions
extends DumbAwareAction {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ShowNonRetinaImagesActions.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        class ImageInfo {
            boolean retina;
            boolean normal;
            boolean dark;
            boolean retina_dark;

            ImageInfo() {
            }
        }
        HashMap<String, ImageInfo> info = new HashMap<String, ImageInfo>();
        Collection<VirtualFile> images = FilenameIndex.getAllFilesByExt(project2, "png", GlobalSearchScope.projectScope(project2));
        for (VirtualFile image : images) {
            String path2 = image.getPath();
            String key = ShowNonRetinaImagesActions.toKey(path2);
            ImageInfo imageInfo = (ImageInfo)info.get(key);
            if (imageInfo == null) {
                imageInfo = new ImageInfo();
                info.put(key, imageInfo);
            }
            if (path2.endsWith("@2x_dark.png")) {
                imageInfo.retina_dark = true;
                continue;
            }
            if (path2.endsWith("_dark.png")) {
                imageInfo.dark = true;
                continue;
            }
            if (path2.endsWith("@2x.png")) {
                imageInfo.retina = true;
                continue;
            }
            imageInfo.normal = true;
        }
        final ArrayList<String> retinaMissed = new ArrayList<String>();
        for (String key : info.keySet()) {
            if (((ImageInfo)info.get((Object)key)).retina || !((ImageInfo)info.get((Object)key)).normal) continue;
            retinaMissed.add(key);
        }
        Collections.sort(retinaMissed, String.CASE_INSENSITIVE_ORDER);
        new DialogWrapper(project2){
            {
                super(arg0);
                this.init();
            }

            @Override
            @Nullable
            protected JComponent createCenterPanel() {
                return new JBScrollPane(new JTextArea(StringUtil.join(retinaMissed, "\n")));
            }
        }.show();
    }

    private static String toKey(String path2) {
        if (path2.endsWith("@2x_dark.png")) {
            return path2.substring(0, path2.lastIndexOf("@2x_dark.png")) + ".png";
        }
        if (path2.endsWith("_dark.png")) {
            return path2.substring(0, path2.lastIndexOf("_dark.png")) + ".png";
        }
        if (path2.endsWith("@2x.png")) {
            return path2.substring(0, path2.lastIndexOf("@2x.png")) + ".png";
        }
        return path2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ShowNonRetinaImagesActions", "actionPerformed"));
    }
}

