/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.cachedValueProfiler;

import com.google.gson.stream.JsonWriter;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.psi.util.ProfilingInfo;
import com.intellij.util.containers.MultiMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedValueProfilerDumper {
    private final MultiMap<StackTraceElement, ProfilingInfo> myStorage;

    private CachedValueProfilerDumper(MultiMap<StackTraceElement, ProfilingInfo> storage) {
        this.myStorage = storage;
    }

    @NotNull
    public static File dumpResults(@Nullable File dir) throws IOException {
        CachedValueProfiler profiler = CachedValueProfiler.getInstance();
        CachedValueProfilerDumper dumper = new CachedValueProfilerDumper(profiler.getStorageSnapshot());
        return dumper.dump(dir);
    }

    @NotNull
    private File dump(@Nullable File dir) throws IOException {
        List<TotalInfo> infos = this.prepareInfo();
        String fileName = String.format("dump-%s.cvp", CachedValueProfilerDumper.time());
        File file2 = new File(dir, fileName);
        try (JsonWriter writer = new JsonWriter((Writer)new BufferedWriter(new FileWriter(file2)));){
            new MyWriter(writer).write(infos);
        }
        File file3 = file2;
        if (file3 == null) {
            CachedValueProfilerDumper.$$$reportNull$$$0(0);
        }
        return file3;
    }

    @NotNull
    private List<TotalInfo> prepareInfo() {
        ArrayList<TotalInfo> list2 = new ArrayList<TotalInfo>();
        this.myStorage.entrySet().forEach(entry -> list2.add(new TotalInfo((StackTraceElement)entry.getKey(), (Collection)entry.getValue())));
        Collections.sort(list2, Comparator.comparing(info -> (double)((TotalInfo)info).getTotalUseCount() / (double)((TotalInfo)info).getInfos().size()));
        ArrayList<TotalInfo> arrayList = list2;
        if (arrayList == null) {
            CachedValueProfilerDumper.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static String time() {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('|').appendValue(ChronoField.YEAR).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
        String string = LocalDateTime.now().format(formatter);
        if (string == null) {
            CachedValueProfilerDumper.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/cachedValueProfiler/CachedValueProfilerDumper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "time";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyWriter {
        private final JsonWriter myWriter;

        private MyWriter(@NotNull JsonWriter writer) {
            if (writer == null) {
                MyWriter.$$$reportNull$$$0(0);
            }
            this.myWriter = writer;
        }

        private void write(@NotNull List<TotalInfo> infos) throws IOException {
            if (infos == null) {
                MyWriter.$$$reportNull$$$0(1);
            }
            this.myWriter.setIndent("  ");
            this.myWriter.beginArray();
            for (TotalInfo info : infos) {
                this.writeInfo(info);
            }
            this.myWriter.endArray();
        }

        private void writeInfo(@NotNull TotalInfo info) throws IOException {
            if (info == null) {
                MyWriter.$$$reportNull$$$0(2);
            }
            this.myWriter.beginObject();
            String origin = info.getOrigin().toString();
            long totalLifeTime = info.getTotalLifeTime();
            long totalUseCount = info.getTotalUseCount();
            int createdCount = info.getInfos().size();
            this.myWriter.name("origin").value(origin);
            this.myWriter.name("total lifetime").value(totalLifeTime);
            this.myWriter.name("total use count").value(totalUseCount);
            this.myWriter.name("created").value((long)createdCount);
            this.myWriter.endObject();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "writer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/cachedValueProfiler/CachedValueProfilerDumper$MyWriter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeInfo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TotalInfo {
        private final StackTraceElement myOrigin;
        private final long myTotalLifeTime;
        private final long myTotalUseCount;
        private final List<ProfilingInfo> myInfos;

        private TotalInfo(@NotNull StackTraceElement origin, @NotNull Collection<ProfilingInfo> infos) {
            if (origin == null) {
                TotalInfo.$$$reportNull$$$0(0);
            }
            if (infos == null) {
                TotalInfo.$$$reportNull$$$0(1);
            }
            this.myOrigin = origin;
            this.myInfos = Collections.unmodifiableList(new ArrayList<ProfilingInfo>(infos));
            this.myTotalLifeTime = this.myInfos.stream().mapToLong(value2 -> value2.getLifetime()).sum();
            this.myTotalUseCount = this.myInfos.stream().mapToLong(value2 -> value2.getUseCount()).sum();
        }

        @NotNull
        private StackTraceElement getOrigin() {
            StackTraceElement stackTraceElement = this.myOrigin;
            if (stackTraceElement == null) {
                TotalInfo.$$$reportNull$$$0(2);
            }
            return stackTraceElement;
        }

        private long getTotalLifeTime() {
            return this.myTotalLifeTime;
        }

        private long getTotalUseCount() {
            return this.myTotalUseCount;
        }

        @NotNull
        private List<ProfilingInfo> getInfos() {
            List<ProfilingInfo> list2 = this.myInfos;
            if (list2 == null) {
                TotalInfo.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "origin";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/cachedValueProfiler/CachedValueProfilerDumper$TotalInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/cachedValueProfiler/CachedValueProfilerDumper$TotalInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrigin";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

