/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.focus;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.jetbrains.annotations.NotNull;

public class DumpFocusableComponentHierarchyAction
extends AnAction
implements DumbAware {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpFocusableComponentHierarchyAction.$$$reportNull$$$0(0);
        }
        JFrame visibleFrame = WindowManager.getInstance().findVisibleFrame();
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        Component focusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        final CopyOnWriteArrayList<String> dump = new CopyOnWriteArrayList<String>();
        dump.add("Active Window: " + (activeWindow == null ? "null" : activeWindow.getClass().getName()));
        dump.add("Focused Window: " + (focusedWindow == null ? "null" : focusedWindow.getClass().getName()));
        dump.add("Focused Component: " + (focusedComponent == null ? "null" : focusedComponent.getClass().getName()));
        ArrayList<Component> componentTrace = new ArrayList<Component>();
        for (Component c = focusedComponent; c != null; c = c.getParent()) {
            componentTrace.add(c);
        }
        for (int i = componentTrace.size() - 1; i >= 0; --i) {
            dump.add(((Component)componentTrace.get(i)).getClass().getName());
            if (i == 0) continue;
            dump.add("^");
        }
        dump.add("Children count in focused component: " + (focusedComponent == null ? "null" : Integer.valueOf(((JComponent)focusedComponent).getComponentCount())));
        final int FONT_HEIGHT = 30;
        JPanel jPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(JBColor.BLACK);
                g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
                g.setColor(JBColor.WHITE);
                for (int i = dump.size() - 1; i >= 0; --i) {
                    g.drawString((String)dump.get(i), 20, 50 + i * FONT_HEIGHT);
                }
            }
        };
        jPanel.setPreferredSize(new Dimension(visibleFrame.getWidth(), dump.size() * FONT_HEIGHT + 200));
        JBScrollPane scrollPane = new JBScrollPane(jPanel);
        scrollPane.setPreferredSize(visibleFrame.getSize());
        final Popup popup2 = PopupFactory.getSharedInstance().getPopup(visibleFrame, scrollPane, visibleFrame.getX(), visibleFrame.getY());
        popup2.show();
        JButton closeButton = new JButton(new AbstractAction("Close and copy into the clipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder dumpAsString = new StringBuilder();
                for (int i = dump.size() - 1; i >= 0; --i) {
                    dumpAsString.append((String)dump.get(i)).append("\n");
                }
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(dumpAsString.toString()), null);
                popup2.hide();
            }
        });
        jPanel.add((Component)closeButton, "South");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/focus/DumpFocusableComponentHierarchyAction", "actionPerformed"));
    }
}

