/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.rulerguide;

import com.intellij.internal.rulerguide.BasePreferences;
import com.intellij.internal.rulerguide.ComponentBounds;
import com.intellij.internal.rulerguide.ComponentBoundsFinder;
import com.intellij.internal.rulerguide.SneakyGraphics2D;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

final class RulerGuidePainter
extends AbstractPainter
implements Disposable {
    private static final Logger LOG = Logger.getInstance(RulerGuidePainter.class);
    private final ComponentBoundsFinder finder = new ComponentBoundsFinder();
    private final AtomicReference<JRootPane> rootPane = new AtomicReference();
    private Disposable disposable;

    RulerGuidePainter(Disposable parent) {
        Disposer.register(parent, this);
    }

    private void installPainter(@NotNull JRootPane rootPane) {
        Component glassPane;
        if (rootPane == null) {
            RulerGuidePainter.$$$reportNull$$$0(0);
        }
        if ((glassPane = rootPane.getGlassPane()) instanceof IdeGlassPane) {
            assert (this.disposable == null) : "Disposable is not null";
            this.disposable = Disposer.newDisposable("Ruler Guide");
            Disposer.register(this, this.disposable);
            ((IdeGlassPane)((Object)glassPane)).addPainter(glassPane, this, this.disposable);
        } else {
            ThiefGlassPane glass = new ThiefGlassPane(glassPane);
            rootPane.setGlassPane(glass);
            glass.setVisible(true);
            glass.revalidate();
        }
    }

    public void removePainter() {
        this.finder.dispose();
        Optional.ofNullable(this.rootPane.getAndSet(null)).ifPresent(this::removePainter);
    }

    private void removePainter(@NotNull JRootPane rootPane) {
        Component glassPane;
        if (rootPane == null) {
            RulerGuidePainter.$$$reportNull$$$0(1);
        }
        if ((glassPane = rootPane.getGlassPane()) instanceof IdeGlassPane) {
            Disposer.dispose(this.disposable);
            this.disposable = null;
            glassPane.repaint();
        } else if (glassPane instanceof ThiefGlassPane) {
            Component realGlassPane = ((ThiefGlassPane)glassPane).getRealGlassPane();
            rootPane.setGlassPane(realGlassPane);
            realGlassPane.revalidate();
        } else {
            Disposer.dispose(this.disposable);
            this.disposable = null;
            LOG.warn("GlassPane may be only IdeGlassPane or ThiefGlassPane ancestor but found " + glassPane);
        }
    }

    public void repaint(Component eventSource, Point eventPoint) {
        JRootPane oldRootPane;
        JRootPane newRootPane = SwingUtilities.getRootPane(eventSource);
        if (newRootPane != (oldRootPane = this.rootPane.getAndSet(newRootPane))) {
            Optional.ofNullable(oldRootPane).ifPresent(this::removePainter);
            Optional.ofNullable(newRootPane).ifPresent(this::installPainter);
        }
        if (newRootPane != null) {
            Point point = SwingUtilities.convertPoint(eventSource, eventPoint, newRootPane);
            this.finder.update(newRootPane, point);
            Component glassPane = newRootPane.getGlassPane();
            if (glassPane instanceof IdeGlassPane) {
                this.setNeedsRepaint(Boolean.valueOf(true), glassPane);
            } else if (glassPane instanceof ThiefGlassPane) {
                glassPane.repaint();
            } else {
                throw new IllegalStateException("GlassPane maybe only IdeGlassPane or ThiefGlassPane but found " + glassPane);
            }
        }
    }

    @Override
    public boolean needsRepaint() {
        return this.finder.getLastResult() != null;
    }

    @Override
    public void executePaint(Component component2, Graphics2D g) {
        Graphics2D g2d = (Graphics2D)g.create(0, 0, component2.getWidth(), component2.getHeight());
        GraphicsUtil.setupAntialiasing(g2d, false, false);
        ComponentBoundsFinder.Result result2 = this.finder.getLastResult();
        ComponentBounds pivot = null;
        for (ComponentBounds bounds2 : result2.getBounds()) {
            if (!bounds2.contains(result2.getPoint())) continue;
            pivot = bounds2;
            g2d.setColor(BasePreferences.BACKGROUND_COLOR);
            g2d.fillRect(pivot.x, pivot.y, pivot.width, pivot.height);
            RulerGuidePainter.paintBaselines(pivot, g2d);
            break;
        }
        for (ComponentBounds bounds2 : result2.getBounds()) {
            g2d.setColor(BasePreferences.BACKGROUND_COLOR);
            if (pivot == null || pivot == bounds2) continue;
            Point baselineOtherPoint = new Point(bounds2.x + bounds2.verticalBaseline, bounds2.y + bounds2.horizontalBaseline);
            Point baselinePivotPoint = new Point(pivot.x + pivot.verticalBaseline, pivot.y + pivot.horizontalBaseline);
            int verticalOffset = Math.abs(baselineOtherPoint.x - baselinePivotPoint.x);
            int horizontalOffset = Math.abs(baselineOtherPoint.y - baselinePivotPoint.y);
            if (verticalOffset == 0 || horizontalOffset == 0) {
                g2d.setColor(BasePreferences.FINE_COLOR);
            } else {
                if (verticalOffset > BasePreferences.getAllowedGap() && horizontalOffset > BasePreferences.getAllowedGap()) continue;
                g2d.setColor(BasePreferences.ERROR_COLOR);
            }
            g2d.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
        }
        g2d.dispose();
    }

    private static void paintBaselines(ComponentBounds bounds2, Graphics2D g2d) {
        Rectangle clipBounds = g2d.getClipBounds();
        Point location2 = bounds2.getLocation();
        g2d.setColor(BasePreferences.COMPONENT_COLOR);
        g2d.drawLine(clipBounds.x, location2.y + bounds2.height, clipBounds.x + clipBounds.width, location2.y + bounds2.height);
        int hbaseline = bounds2.horizontalBaseline;
        if (hbaseline >= 0) {
            g2d.setColor(BasePreferences.BASE_COLOR);
            g2d.drawLine(clipBounds.x, location2.y + hbaseline, clipBounds.x + clipBounds.width, location2.y + hbaseline);
        }
        g2d.setColor(BasePreferences.COMPONENT_COLOR);
        g2d.drawLine(location2.x, clipBounds.y, location2.x, clipBounds.y + clipBounds.height);
        int vbaseline = bounds2.verticalBaseline;
        if (vbaseline >= 0) {
            g2d.setColor(BasePreferences.BASE_COLOR);
            g2d.drawLine(location2.x + vbaseline, clipBounds.y, location2.x + vbaseline, clipBounds.y + clipBounds.height);
        }
    }

    @Override
    public void dispose() {
        this.removePainter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "rootPane";
        objectArray2[1] = "com/intellij/internal/rulerguide/RulerGuidePainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installPainter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removePainter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ThiefGlassPane
    extends JComponent {
        private final Component realGlassPane;

        private ThiefGlassPane(Component realGlassPane) {
            this.realGlassPane = realGlassPane;
            this.setOpaque(false);
        }

        public Component getRealGlassPane() {
            return this.realGlassPane;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (g instanceof SneakyGraphics2D || this.isJBPopupMenu()) {
                return;
            }
            RulerGuidePainter.this.executePaint(SwingUtilities.getRoot(this), (Graphics2D)g);
        }

        private boolean isJBPopupMenu() {
            Container contentPane = SwingUtilities.getRootPane(this).getContentPane();
            return contentPane.getComponentCount() == 1 && contentPane.getComponent(0) instanceof JBPopupMenu;
        }
    }
}

