/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IntentionsCollector {
    public static void record(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull Language language2) {
        if (project2 == null) {
            IntentionsCollector.$$$reportNull$$$0(0);
        }
        if (action2 == null) {
            IntentionsCollector.$$$reportNull$$$0(1);
        }
        if (language2 == null) {
            IntentionsCollector.$$$reportNull$$$0(2);
        }
        IntentionsCollector.recordIntentionEvent(project2, action2, language2, "called");
    }

    protected static void recordIntentionEvent(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull Language language2, @NonNls String eventId) {
        if (project2 == null) {
            IntentionsCollector.$$$reportNull$$$0(3);
        }
        if (action2 == null) {
            IntentionsCollector.$$$reportNull$$$0(4);
        }
        if (language2 == null) {
            IntentionsCollector.$$$reportNull$$$0(5);
        }
        Class<?> clazz = IntentionsCollector.getOriginalHandlerClass(action2);
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(clazz);
        FeatureUsageData data2 = new FeatureUsageData().addData("id", clazz.getName()).addPluginInfo(info).addLanguage(language2);
        FUCounterUsageLogger.getInstance().logEvent(project2, "intentions", eventId, data2);
    }

    @NotNull
    private static Class<?> getOriginalHandlerClass(@NotNull IntentionAction action2) {
        LocalQuickFix fix2;
        if (action2 == null) {
            IntentionsCollector.$$$reportNull$$$0(6);
        }
        FileModifier handler2 = action2;
        if (action2 instanceof IntentionActionDelegate) {
            IntentionAction delegate = ((IntentionActionDelegate)((Object)action2)).getDelegate();
            if (delegate != action2) {
                return IntentionsCollector.getOriginalHandlerClass(delegate);
            }
        } else if (action2 instanceof QuickFixWrapper && (fix2 = ((QuickFixWrapper)action2).getFix()) != action2) {
            handler2 = fix2;
        }
        Class<?> clazz = handler2.getClass();
        if (clazz == null) {
            IntentionsCollector.$$$reportNull$$$0(7);
        }
        return clazz;
    }

    public static void reportShownIntentions(@NotNull Project project2, ListPopup popup2, @NotNull Language language2) {
        if (project2 == null) {
            IntentionsCollector.$$$reportNull$$$0(8);
        }
        if (language2 == null) {
            IntentionsCollector.$$$reportNull$$$0(9);
        }
        List values2 = popup2.getListStep().getValues();
        for (IntentionActionWithTextCaching value2 : values2) {
            IntentionsCollector.recordIntentionEvent(project2, value2.getAction(), language2, "shown");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/IntentionsCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/IntentionsCollector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalHandlerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "recordIntentionEvent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalHandlerClass";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reportShownIntentions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

