/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryApplicationUsagesCollector
extends ApplicationUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "platform.registry";
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        return RegistryApplicationUsagesCollector.getChangedValuesUsages();
    }

    @NotNull
    static Set<MetricEvent> getChangedValuesUsages() {
        Set registry = Registry.getAll().stream().filter(key -> key.isChangedFromDefault()).map(key -> MetricEventFactoryKt.newMetric((String)"registry", (FeatureUsageData)new FeatureUsageData().addData("id", key.getKey()))).collect(Collectors.toSet());
        Set experiments = Experiments.EP_NAME.extensions().filter(f -> Experiments.getInstance().isFeatureEnabled(f.id)).map(f -> MetricEventFactoryKt.newMetric((String)"experiment", (FeatureUsageData)new FeatureUsageData().addData("id", f.id))).collect(Collectors.toSet());
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>(registry);
        result2.addAll(experiments);
        HashSet<MetricEvent> hashSet = result2;
        if (hashSet == null) {
            RegistryApplicationUsagesCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/fus/RegistryApplicationUsagesCollector", "getChangedValuesUsages"));
    }

    public static class RegistryUtilValidator
    extends CustomWhiteListRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "registry_key".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            ExperimentalFeature feature;
            if (data2 == null) {
                RegistryUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                RegistryUtilValidator.$$$reportNull$$$0(1);
            }
            if ((feature = RegistryUtilValidator.findFeatureById(data2)) != null) {
                PluginInfo info = PluginInfoDetectorKt.getPluginInfo(feature.getClass());
                context.setPluginInfo(info);
                ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    RegistryUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            PluginInfo info = RegistryUtilValidator.getPluginInfoByRegistry(Registry.get(data2));
            context.setPluginInfo(info);
            ValidationResultType validationResultType = info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                RegistryUtilValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        @NotNull
        private static PluginInfo getPluginInfoByRegistry(@NotNull RegistryValue value2) {
            String pluginId;
            if (value2 == null) {
                RegistryUtilValidator.$$$reportNull$$$0(4);
            }
            PluginInfo pluginInfo = (pluginId = value2.getPluginId()) != null ? PluginInfoDetectorKt.getPluginInfoById((PluginId)PluginId.getId(pluginId)) : PluginInfoDetectorKt.getPlatformPlugin();
            if (pluginInfo == null) {
                RegistryUtilValidator.$$$reportNull$$$0(5);
            }
            return pluginInfo;
        }

        @Nullable
        private static ExperimentalFeature findFeatureById(@NotNull String featureId) {
            if (featureId == null) {
                RegistryUtilValidator.$$$reportNull$$$0(6);
            }
            for (ExperimentalFeature feature : Experiments.EP_NAME.getExtensions()) {
                if (!StringUtil.equals(feature.id, featureId)) continue;
                return feature;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/RegistryApplicationUsagesCollector$RegistryUtilValidator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "featureId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/RegistryApplicationUsagesCollector$RegistryUtilValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPluginInfoByRegistry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getPluginInfoByRegistry";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findFeatureById";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

