/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionsBuiltInWhitelist {
    private static final ActionsBuiltInWhitelist ourInstance = new ActionsBuiltInWhitelist();
    private final Set<String> ourXmlActionIds = new HashSet<String>();
    private final Set<String> ourCustomActionWhitelist = ContainerUtil.newHashSet("ShowUsagesPopup.showSettings", "Reload Classes", "DialogCancelAction", "DialogOkAction", "DoubleShortcut");

    static ActionsBuiltInWhitelist getInstance() {
        return ourInstance;
    }

    private ActionsBuiltInWhitelist() {
    }

    public boolean isCustomAllowedAction(@NotNull String actionId) {
        if (actionId == null) {
            ActionsBuiltInWhitelist.$$$reportNull$$$0(0);
        }
        return this.ourCustomActionWhitelist.contains(actionId);
    }

    public boolean isWhitelistedActionId(@NotNull String actionId) {
        if (actionId == null) {
            ActionsBuiltInWhitelist.$$$reportNull$$$0(1);
        }
        return this.isCustomAllowedAction(actionId) || this.ourXmlActionIds.contains(actionId);
    }

    public void addActionLoadedFromXml(@NotNull String actionId, @Nullable IdeaPluginDescriptor plugin) {
        PluginInfo pluginInfo;
        if (actionId == null) {
            ActionsBuiltInWhitelist.$$$reportNull$$$0(2);
        }
        PluginInfo pluginInfo2 = pluginInfo = plugin == null ? null : PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)plugin);
        if (pluginInfo != null && pluginInfo.isSafeToReport()) {
            this.ourXmlActionIds.add(actionId);
        }
    }

    public void addActionsLoadedFromKeymapXml(@NotNull Keymap keymap2, @NotNull Set<String> actionIds) {
        PluginDescriptor plugin;
        if (keymap2 == null) {
            ActionsBuiltInWhitelist.$$$reportNull$$$0(3);
        }
        if (actionIds == null) {
            ActionsBuiltInWhitelist.$$$reportNull$$$0(4);
        }
        if (keymap2 instanceof DefaultKeymapImpl && PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)(plugin = ((DefaultKeymapImpl)keymap2).getPlugin())).isDevelopedByJetBrains()) {
            this.ourXmlActionIds.addAll(actionIds);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionIds";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsBuiltInWhitelist";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomAllowedAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhitelistedActionId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addActionLoadedFromXml";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addActionsLoadedFromKeymapXml";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

