/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsBuiltInWhitelist;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionsCollectorImpl
extends ActionsCollector {
    public static final String GROUP = "actions";
    public static final String ACTION_INVOKED_EVENT_ID = "action.invoked";
    public static final String DEFAULT_ID = "third.party";
    private static final ActionsBuiltInWhitelist ourWhitelist = ActionsBuiltInWhitelist.getInstance();
    private final Map<AnAction, String> myOtherActions = ContainerUtil.createWeakMap();

    @Override
    public void record(@Nullable String actionId, @Nullable InputEvent event, @NotNull Class context) {
        if (context == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(0);
        }
        String recorded = StringUtil.isNotEmpty(actionId) && ourWhitelist.isCustomAllowedAction(actionId) ? actionId : DEFAULT_ID;
        FeatureUsageData data2 = new FeatureUsageData().addData("action_id", recorded);
        if (event instanceof KeyEvent) {
            data2.addInputEvent((KeyEvent)event);
        } else if (event instanceof MouseEvent) {
            data2.addInputEvent((MouseEvent)event);
        }
        FUCounterUsageLogger.getInstance().logEvent(GROUP, "custom.action.invoked", data2);
    }

    @Override
    public void record(@Nullable Project project2, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable Language lang2) {
        ActionsCollectorImpl.recordActionInvoked(project2, action2, event, data2 -> {
            if (lang2 != null) {
                data2.addCurrentFile(lang2);
            }
        });
    }

    public static void recordActionInvoked(@Nullable Project project2, @Nullable AnAction action2, @Nullable AnActionEvent event, @NotNull Consumer<FeatureUsageData> configurator) {
        if (configurator == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(1);
        }
        ActionsCollectorImpl.record(GROUP, ACTION_INVOKED_EVENT_ID, project2, action2, event, configurator);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    public static void record(@NotNull String groupId2, @Nullable Project project2, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable Consumer<FeatureUsageData> configurator) {
        if (groupId2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(2);
        }
        ActionsCollectorImpl.record(groupId2, null, project2, action2, event, configurator);
    }

    public static void record(@NotNull String groupId2, @Nullable String eventId, @Nullable Project project2, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable Consumer<FeatureUsageData> configurator) {
        if (groupId2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(3);
        }
        if (action2 == null) {
            return;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(action2.getClass());
        FeatureUsageData data2 = new FeatureUsageData().addProject(project2).addPluginInfo(info);
        if (event != null) {
            data2.addInputEvent(event).addPlace(event.getPlace()).addData("context_menu", event.isFromContextMenu());
        }
        if (configurator != null) {
            configurator.accept(data2);
        }
        String actionId = ActionsCollectorImpl.addActionClass(data2, action2, info);
        String reportedEventId = StringUtil.notNullize(eventId, actionId);
        FUCounterUsageLogger.getInstance().logEvent(groupId2, reportedEventId, data2);
    }

    @NotNull
    public static String addActionClass(@NotNull FeatureUsageData data2, @NotNull AnAction action2, @NotNull PluginInfo info) {
        if (data2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(4);
        }
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(5);
        }
        if (info == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(6);
        }
        String actionClassName = info.isSafeToReport() ? action2.getClass().getName() : DEFAULT_ID;
        String actionId = ((ActionsCollectorImpl)ActionsCollectorImpl.getInstance()).getActionId(info, action2);
        if (action2 instanceof ActionWithDelegate) {
            Object delegate = ((ActionWithDelegate)((Object)action2)).getDelegate();
            PluginInfo delegateInfo = PluginInfoDetectorKt.getPluginInfo(delegate.getClass());
            actionId = delegateInfo.isSafeToReport() ? delegate.getClass().getName() : DEFAULT_ID;
            data2.addData("class", actionId);
            data2.addData("parent", actionClassName);
        } else {
            data2.addData("class", actionClassName);
        }
        data2.addData("action_id", actionId);
        String string = actionId;
        if (string == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private String getActionId(@NotNull PluginInfo pluginInfo, @NotNull AnAction action2) {
        if (pluginInfo == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(8);
        }
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(9);
        }
        if (!pluginInfo.isSafeToReport()) {
            return DEFAULT_ID;
        }
        String actionId = ActionManager.getInstance().getId(action2);
        if (actionId == null && action2 instanceof ActionIdProvider) {
            actionId = ((ActionIdProvider)((Object)action2)).getId();
        }
        if (actionId != null && !ActionsCollectorImpl.canReportActionId(actionId)) {
            String string = action2.getClass().getName();
            if (string == null) {
                ActionsCollectorImpl.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (actionId == null) {
            actionId = this.myOtherActions.get(action2);
        }
        String string = actionId != null ? actionId : action2.getClass().getName();
        if (string == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static boolean canReportActionId(@NotNull String actionId) {
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(12);
        }
        return ourWhitelist.isWhitelistedActionId(actionId);
    }

    @Override
    public void onActionConfiguredByActionId(@NotNull AnAction action2, @NotNull String actionId) {
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(13);
        }
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(14);
        }
        if (ActionsCollectorImpl.canReportActionId(actionId)) {
            this.myOtherActions.put(action2, actionId);
        }
    }

    public static void onActionLoadedFromXml(@NotNull AnAction action2, @NotNull String actionId, @Nullable IdeaPluginDescriptor plugin) {
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(15);
        }
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(16);
        }
        ourWhitelist.addActionLoadedFromXml(actionId, plugin);
    }

    public static void onActionsLoadedFromKeymapXml(@NotNull Keymap keymap2, @NotNull Set<String> actionIds) {
        if (keymap2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(17);
        }
        if (actionIds == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(18);
        }
        ourWhitelist.addActionsLoadedFromKeymapXml(keymap2, actionIds);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurator";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginInfo";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addActionClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "recordActionInvoked";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addActionClass";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getActionId";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canReportActionId";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onActionConfiguredByActionId";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onActionLoadedFromXml";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onActionsLoadedFromKeymapXml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

