/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageSchemaDescriptor;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsagesCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeUsageCounterCollector {
    private static final Logger LOG = Logger.getInstance(FileTypeUsageCounterCollector.class);
    private static final ExtensionPointName<FileTypeUsageSchemaDescriptorEP<FileTypeUsageSchemaDescriptor>> EP = ExtensionPointName.create("com.intellij.fileTypeUsageSchemaDescriptor");

    public static void triggerEdit(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(1);
        }
        FileTypeUsageCounterCollector.trigger(project2, file2, "edit");
    }

    public static void triggerSelect(@NotNull Project project2, @Nullable VirtualFile file2) {
        if (project2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(2);
        }
        if (file2 != null) {
            FileTypeUsageCounterCollector.trigger(project2, file2, "select");
        } else {
            FeatureUsageData data2 = new FeatureUsageData().addAnonymizedPath(null);
            FUCounterUsageLogger.getInstance().logEvent(project2, "file.types.usage", "select", data2);
        }
    }

    public static void triggerOpen(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(4);
        }
        FileTypeUsageCounterCollector.trigger(project2, file2, "open");
    }

    public static void triggerClosed(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(6);
        }
        FileTypeUsageCounterCollector.trigger(project2, file2, "close");
    }

    private static void trigger(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull String event) {
        if (project2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(8);
        }
        if (event == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(9);
        }
        FeatureUsageData data2 = FileTypeUsagesCollector.newFeatureUsageData(file2.getFileType()).addAnonymizedPath(file2.getPath());
        for (FileTypeUsageSchemaDescriptorEP<FileTypeUsageSchemaDescriptor> ext : EP.getExtensionList()) {
            FileTypeUsageSchemaDescriptor instance2 = (FileTypeUsageSchemaDescriptor)ext.getInstance();
            if (ext.schema == null) {
                LOG.warn("Extension " + ext.implementationClass + " should define a 'schema' attribute");
                continue;
            }
            if (!instance2.describes(file2)) continue;
            data2.addData("schema", PluginInfoDetectorKt.getPluginInfo(instance2.getClass()).isSafeToReport() ? ext.schema : "third.party");
            break;
        }
        FUCounterUsageLogger.getInstance().logEvent(project2, "file.types.usage", event, data2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerEdit";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerSelect";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerOpen";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerClosed";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "trigger";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        @Override
        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(1);
            }
            FileTypeUsageCounterCollector.triggerOpen(source.getProject(), file2);
        }

        @Override
        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(3);
            }
            FileTypeUsageCounterCollector.triggerClosed(source.getProject(), file2);
        }

        @Override
        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(4);
            }
            FileTypeUsageCounterCollector.triggerSelect(event.getManager().getProject(), event.getNewFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector$MyFileEditorManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileOpened";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileClosed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyAnActionListener
    implements AnActionListener {
        private static final Key<Long> LAST_EDIT_USAGE = Key.create("LAST_EDIT_USAGE");

        @Override
        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(2);
            }
            if (action2 instanceof EditorAction && ((EditorAction)action2).getHandler() instanceof EditorWriteActionHandler) {
                MyAnActionListener.onChange(dataContext);
            }
        }

        private static void onChange(DataContext dataContext) {
            Long lastEdit;
            Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
            if (editor == null) {
                return;
            }
            Project project2 = editor.getProject();
            if (project2 == null) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (file2 != null && ((lastEdit = editor.getUserData(LAST_EDIT_USAGE)) == null || System.currentTimeMillis() - lastEdit > 60000L)) {
                editor.putUserData(LAST_EDIT_USAGE, System.currentTimeMillis());
                FileTypeUsageCounterCollector.triggerEdit(project2, file2);
            }
        }

        @Override
        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(3);
            }
            MyAnActionListener.onChange(dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector$MyAnActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class FileTypeSchemaValidator
    extends CustomWhiteListRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "file_type_schema".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                FileTypeSchemaValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                FileTypeSchemaValidator.$$$reportNull$$$0(1);
            }
            if (FileTypeSchemaValidator.isThirdPartyValue((String)data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    FileTypeSchemaValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            for (FileTypeUsageSchemaDescriptorEP ext : EP.getExtensionList()) {
                if (!StringUtil.equals(ext.schema, data2)) continue;
                ValidationResultType validationResultType = PluginInfoDetectorKt.getPluginInfo(((FileTypeUsageSchemaDescriptor)ext.getInstance()).getClass()).isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    FileTypeSchemaValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                FileTypeSchemaValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector$FileTypeSchemaValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector$FileTypeSchemaValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class FileTypeUsageSchemaDescriptorEP<T>
    extends BaseKeyedLazyInstance<T>
    implements KeyedLazyInstance<T> {
        @Attribute(value="schema")
        public String schema;
        @Attribute(value="implementationClass")
        public String implementationClass;

        @Override
        @Nullable
        protected String getImplementationClassName() {
            return this.implementationClass;
        }

        @Override
        public String getKey() {
            return this.schema;
        }
    }
}

