/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectIntHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.serialization.JpsElementPropertiesSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;

public class ProjectStructureUsageCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "project.structure";
    }

    public int getVersion() {
        return 3;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Module[] modules;
        if (project2 == null) {
            ProjectStructureUsageCollector.$$$reportNull$$$0(0);
        }
        Map<JpsModuleSourceRootType, String> typeNames = JBIterable.from(JpsModelSerializerExtension.getExtensions()).filter(o -> PluginInfoDetectorKt.getPluginInfo(o.getClass()).isDevelopedByJetBrains()).flatMap(JpsModelSerializerExtension::getModuleSourceRootPropertiesSerializers).toMap(JpsElementPropertiesSerializer::getType, JpsElementPropertiesSerializer::getTypeId);
        int contentRoots2 = 0;
        int sourceRoots2 = 0;
        int excludedRoots = 0;
        int packagePrefix = 0;
        TObjectIntHashMap<String> types = new TObjectIntHashMap<String>();
        for (Module module2 : modules = ModuleManager.getInstance(project2).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance(module2);
            contentRoots2 += rootManager.getContentEntries().length;
            sourceRoots2 += rootManager.getSourceRoots(true).length;
            excludedRoots += rootManager.getExcludeRoots().length;
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder source : entry.getSourceFolders()) {
                    String key2;
                    if (StringUtil.isNotEmpty(source.getPackagePrefix())) {
                        ++packagePrefix;
                    }
                    if ((key2 = typeNames.get(source.getRootType())) == null || types.increment(key2)) continue;
                    types.put(key2, 1);
                }
            }
        }
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        result2.add(MetricEventFactoryKt.newCounterMetric((String)"modules.total", (int)modules.length));
        result2.add(MetricEventFactoryKt.newCounterMetric((String)"content.roots.total", (int)contentRoots2));
        result2.add(MetricEventFactoryKt.newCounterMetric((String)"source.roots.total", (int)sourceRoots2));
        result2.add(MetricEventFactoryKt.newCounterMetric((String)"excluded.roots.total", (int)excludedRoots));
        types.forEachEntry((key, count) -> result2.add(MetricEventFactoryKt.newCounterMetric((String)"source.root", (int)count, (FeatureUsageData)new FeatureUsageData().addData("type", key))));
        if (PlatformUtils.isIntelliJ()) {
            result2.add(MetricEventFactoryKt.newCounterMetric((String)"package.prefix", (int)packagePrefix));
        }
        NamedScope[] localScopes = NamedScopeManager.getInstance(project2).getEditableScopes();
        result2.add(MetricEventFactoryKt.newCounterMetric((String)"named.scopes.total.local", (int)localScopes.length));
        NamedScope[] sharedScopes = DependencyValidationManager.getInstance(project2).getEditableScopes();
        result2.add(MetricEventFactoryKt.newCounterMetric((String)"named.scopes.total.shared", (int)sharedScopes.length));
        HashSet<MetricEvent> hashSet = result2;
        if (hashSet == null) {
            ProjectStructureUsageCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/ProjectStructureUsageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/ProjectStructureUsageCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

