/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.os;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinuxWindowManagerUsageCollector
extends ApplicationUsagesCollector {
    @NotNull
    public Set<MetricEvent> getMetrics() {
        if (SystemInfo.isLinux) {
            HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
            result2.add(MetricEventFactoryKt.newMetric((String)"xdg.current.desktop", (String)LinuxWindowManagerUsageCollector.toReportedName(System.getenv("XDG_CURRENT_DESKTOP"))));
            HashSet<MetricEvent> hashSet = result2;
            if (hashSet == null) {
                LinuxWindowManagerUsageCollector.$$$reportNull$$$0(0);
            }
            return hashSet;
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            LinuxWindowManagerUsageCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    @VisibleForTesting
    @NotNull
    public static String toReportedName(@Nullable String windowManger) {
        if (windowManger == null) {
            return "empty";
        }
        boolean isGnome = (windowManger = StringUtil.toLowerCase(windowManger)).contains("gnome");
        return isGnome ? LinuxWindowManagerUsageCollector.findReportedName(windowManger, Lazy.GNOME_WINDOW_MANAGERS) : LinuxWindowManagerUsageCollector.findReportedName(windowManger, Lazy.WINDOW_MANAGERS);
    }

    @NotNull
    private static String findReportedName(@NotNull String original, @NotNull Map<String, String> keywordToName) {
        if (original == null) {
            LinuxWindowManagerUsageCollector.$$$reportNull$$$0(2);
        }
        if (keywordToName == null) {
            LinuxWindowManagerUsageCollector.$$$reportNull$$$0(3);
        }
        for (Map.Entry<String, String> entry : keywordToName.entrySet()) {
            if (!original.contains(entry.getKey())) continue;
            String string = entry.getValue();
            if (string == null) {
                LinuxWindowManagerUsageCollector.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = original;
        if (string == null) {
            LinuxWindowManagerUsageCollector.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getGroupId() {
        return "os.linux.wm";
    }

    public int getVersion() {
        return 3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/os/LinuxWindowManagerUsageCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordToName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/os/LinuxWindowManagerUsageCollector";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findReportedName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findReportedName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Lazy {
        private static final Map<String, String> GNOME_WINDOW_MANAGERS = new LinkedHashMap<String, String>();
        private static final Map<String, String> WINDOW_MANAGERS = new LinkedHashMap<String, String>();

        Lazy() {
        }

        static {
            GNOME_WINDOW_MANAGERS.put("shell", "Gnome Shell");
            GNOME_WINDOW_MANAGERS.put("ubuntu", "Ubuntu Gnome");
            GNOME_WINDOW_MANAGERS.put("budgie", "Budgie Gnome");
            GNOME_WINDOW_MANAGERS.put("classic", "Gnome Classic");
            GNOME_WINDOW_MANAGERS.put("flashback:unity", "GNOME Flashback Unity");
            GNOME_WINDOW_MANAGERS.put("flashback_unity", "GNOME Flashback Unity");
            GNOME_WINDOW_MANAGERS.put("flashback:gnome", "GNOME Flashback Gnome");
            GNOME_WINDOW_MANAGERS.put("flashback_gnome", "GNOME Flashback Gnome");
            GNOME_WINDOW_MANAGERS.put("flashback", "GNOME Flashback");
            GNOME_WINDOW_MANAGERS.put("pop", "pop_GNOME");
            GNOME_WINDOW_MANAGERS.put("awesome", "Awesome_GNOME");
            GNOME_WINDOW_MANAGERS.put("gnome", "Gnome");
            WINDOW_MANAGERS.put("unity7", "Unity7");
            WINDOW_MANAGERS.put("x-cinnamon", "X-Cinnamon");
            WINDOW_MANAGERS.put("xfce", "XFCE");
            WINDOW_MANAGERS.put("deepin", "Deepin");
            WINDOW_MANAGERS.put("unity", "Unity");
            WINDOW_MANAGERS.put("pantheon", "Pantheon");
            WINDOW_MANAGERS.put("i3", "i3");
            WINDOW_MANAGERS.put("kde", "KDE");
            WINDOW_MANAGERS.put("lxde", "LXDE");
            WINDOW_MANAGERS.put("mate", "MATE");
            WINDOW_MANAGERS.put("lxqt", "LXQt");
            WINDOW_MANAGERS.put("x-generic", "X-Generic");
            WINDOW_MANAGERS.put("icewm", "ICEWM");
            WINDOW_MANAGERS.put("ukui", "UKUI");
            WINDOW_MANAGERS.put("fluxbox", "Fluxbox");
            WINDOW_MANAGERS.put("lg3d", "LG3D");
            WINDOW_MANAGERS.put("enlightenment", "Enlightenment");
            WINDOW_MANAGERS.put("default.desktop", "default.desktop");
        }
    }
}

