/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.FeatureUsageUiEvents;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J$\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\u001c\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0019\u0010\u0019\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/ui/FeatureUsageUiEventsImpl;", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageUiEvents;", "()V", "CLOSE_CANCEL_DIALOG_DATA", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "CLOSE_CUSTOM_DIALOG_DATA", "CLOSE_OK_DIALOG_DATA", "getDialogCloseData", "exitCode", "", "logApplyConfigurable", "", "configurable", "Lcom/intellij/openapi/options/Configurable;", "logClickOnHelpDialog", "name", "", "context", "Ljava/lang/Class;", "logCloseDialog", "logResetConfigurable", "logSelectConfigurable", "logSettingsEvent", "event", "logShowDialog", "addDialogClass", "addDialogClass$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
public final class FeatureUsageUiEventsImpl
implements FeatureUsageUiEvents {
    private final FeatureUsageData CLOSE_OK_DIALOG_DATA = new FeatureUsageData().addData("code", 0);
    private final FeatureUsageData CLOSE_CANCEL_DIALOG_DATA = new FeatureUsageData().addData("code", 1);
    private final FeatureUsageData CLOSE_CUSTOM_DIALOG_DATA = new FeatureUsageData().addData("code", 2);

    @Override
    public void logSelectConfigurable(@NotNull Configurable configurable2) {
        Intrinsics.checkParameterIsNotNull((Object)configurable2, (String)"configurable");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            this.logSettingsEvent(configurable2, "select");
        }
    }

    @Override
    public void logApplyConfigurable(@NotNull Configurable configurable2) {
        Intrinsics.checkParameterIsNotNull((Object)configurable2, (String)"configurable");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            this.logSettingsEvent(configurable2, "apply");
        }
    }

    @Override
    public void logResetConfigurable(@NotNull Configurable configurable2) {
        Intrinsics.checkParameterIsNotNull((Object)configurable2, (String)"configurable");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            this.logSettingsEvent(configurable2, "reset");
        }
    }

    private final void logSettingsEvent(Configurable configurable2, String event) {
        block0: {
            UnnamedConfigurable base;
            UnnamedConfigurable unnamedConfigurable = base = configurable2 instanceof ConfigurableWrapper ? ((ConfigurableWrapper)configurable2).getConfigurable() : (UnnamedConfigurable)configurable2;
            if (unnamedConfigurable == null) break block0;
            UnnamedConfigurable unnamedConfigurable2 = unnamedConfigurable;
            boolean bl = false;
            boolean bl2 = false;
            UnnamedConfigurable it = unnamedConfigurable2;
            boolean bl3 = false;
            FeatureUsageData featureUsageData = new FeatureUsageData();
            String string = base.getClass().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"base::class.java.name");
            FeatureUsageData data2 = featureUsageData.addData("configurable", string);
            FUCounterUsageLogger.getInstance().logEvent("ui.settings", event, data2);
        }
    }

    @Override
    public void logShowDialog(@NotNull String name, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            FeatureUsageData data2 = this.addDialogClass$intellij_platform_ide_impl(new FeatureUsageData(), name);
            FUCounterUsageLogger.getInstance().logEvent("ui.dialogs", "show", data2);
        }
    }

    @Override
    public void logCloseDialog(@NotNull String name, int exitCode, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            FeatureUsageData data2 = this.addDialogClass$intellij_platform_ide_impl(this.getDialogCloseData(exitCode).copy(), name);
            FUCounterUsageLogger.getInstance().logEvent("ui.dialogs", "close", data2);
        }
    }

    @Override
    public void logClickOnHelpDialog(@NotNull String name, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            FeatureUsageData data2 = this.addDialogClass$intellij_platform_ide_impl(new FeatureUsageData(), name);
            FUCounterUsageLogger.getInstance().logEvent("ui.dialogs", "help.clicked", data2);
        }
    }

    private final FeatureUsageData getDialogCloseData(int exitCode) {
        FeatureUsageData featureUsageData;
        switch (exitCode) {
            case 0: {
                featureUsageData = this.CLOSE_OK_DIALOG_DATA;
                break;
            }
            case 1: {
                featureUsageData = this.CLOSE_CANCEL_DIALOG_DATA;
                break;
            }
            default: {
                featureUsageData = this.CLOSE_CUSTOM_DIALOG_DATA;
            }
        }
        return featureUsageData;
    }

    @NotNull
    public final FeatureUsageData addDialogClass$intellij_platform_ide_impl(@NotNull FeatureUsageData $this$addDialogClass, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$addDialogClass, (String)"$this$addDialogClass");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return $this$addDialogClass.addData("dialog_class", name);
    }
}

