/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import gnu.trove.THashSet;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.Set;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class UiInfoUsageCollector
extends ApplicationUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "ui.info.features";
    }

    public int getVersion() {
        return 6;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        return UiInfoUsageCollector.getDescriptors();
    }

    @NotNull
    public static Set<MetricEvent> getDescriptors() {
        THashSet<MetricEvent> set = new THashSet<MetricEvent>();
        UiInfoUsageCollector.addValue(set, "Nav.Bar", UiInfoUsageCollector.navbar() ? "visible" : "floating");
        UiInfoUsageCollector.addValue(set, "Nav.Bar.members", UISettings.getInstance().getShowMembersInNavigationBar() ? "visible" : "hidden");
        UiInfoUsageCollector.addValue(set, "Toolbar", UiInfoUsageCollector.toolbar() ? "visible" : "hidden");
        UiInfoUsageCollector.addValue(set, "Toolbar.and.NavBar", new FeatureUsageData().addData("toolbar", UiInfoUsageCollector.toolbar() ? "visible" : "hidden").addData("navbar", UiInfoUsageCollector.navbar() ? "visible" : "hidden"));
        UiInfoUsageCollector.addEnabled(set, "Retina", UIUtil.isRetina());
        PropertiesComponent properties = PropertiesComponent.getInstance();
        UiInfoUsageCollector.addEnabled(set, "QuickDoc.Show.Toolwindow", properties.isTrueValue("ShowDocumentationInToolWindow"));
        UiInfoUsageCollector.addEnabled(set, "QuickDoc.AutoUpdate", properties.getBoolean("DocumentationAutoUpdateEnabled", true));
        UIManager.LookAndFeelInfo laf = LafManager.getInstance().getCurrentLookAndFeel();
        UiInfoUsageCollector.addValue(set, "Look.and.Feel", StringUtil.notNullize(laf != null ? laf.getName() : null, "unknown"));
        UiInfoUsageCollector.addValue(set, "Hidpi.Mode", JreHiDpiUtil.isJreHiDPIEnabled() ? "per_monitor_dpi" : "system_dpi");
        UiInfoUsageCollector.addEnabled(set, "Screen.Reader", ScreenReader.isActive());
        set.add(MetricEventFactoryKt.newMetric((String)"QuickListsCount", (int)QuickListsManager.getInstance().getAllQuickLists().length));
        UiInfoUsageCollector.addScreenScale(set);
        UiInfoUsageCollector.addNumberOfMonitors(set);
        UiInfoUsageCollector.addScreenResolutions(set);
        THashSet<MetricEvent> tHashSet = set;
        if (tHashSet == null) {
            UiInfoUsageCollector.$$$reportNull$$$0(0);
        }
        return tHashSet;
    }

    private static void addScreenResolutions(Set<MetricEvent> set) {
        Arrays.stream(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()).map(x -> x.getDefaultConfiguration().getBounds()).map(r -> r.width + "x" + r.height).forEach(x -> UiInfoUsageCollector.addValue((Set<? super MetricEvent>)set, "Screen.Resolution", x));
    }

    private static void addNumberOfMonitors(Set<MetricEvent> set) {
        int numberOfMonitors = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
        UiInfoUsageCollector.addValue(set, "Number.Of.Monitors", String.valueOf(numberOfMonitors));
    }

    private static void addValue(Set<? super MetricEvent> set, String key, FeatureUsageData data2) {
        set.add((MetricEvent)MetricEventFactoryKt.newMetric((String)key, (FeatureUsageData)data2));
    }

    private static void addValue(Set<? super MetricEvent> set, String key, String value2) {
        set.add((MetricEvent)MetricEventFactoryKt.newMetric((String)key, (FeatureUsageData)new FeatureUsageData().addValue((Object)value2)));
    }

    private static void addEnabled(Set<? super MetricEvent> set, String key, boolean enabled) {
        set.add((MetricEvent)MetricEventFactoryKt.newBooleanMetric((String)key, (boolean)enabled));
    }

    private static boolean toolbar() {
        return UISettings.getInstance().getShowMainToolbar();
    }

    private static boolean navbar() {
        return UISettings.getInstance().getShowNavigationBar();
    }

    private static void addScreenScale(Set<? super MetricEvent> set) {
        int scaleBase;
        float scale = JBUIScale.sysScale();
        float scaleFract = scale - (float)(scaleBase = (int)Math.floor(scale));
        scaleFract = scaleFract == 0.0f ? 0.0f : (scaleFract < 0.375f ? 0.25f : (scaleFract < 0.625f ? 0.5f : 0.75f));
        scale = (float)scaleBase + scaleFract;
        boolean isScaleMode = false;
        if (!GraphicsEnvironment.isHeadless()) {
            DisplayMode dm = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
            isScaleMode = JdkEx.getDisplayModeEx().isDefault(dm);
        }
        FeatureUsageData data2 = new FeatureUsageData().addData("scale_mode", isScaleMode).addData("scale", scale);
        set.add((MetricEvent)MetricEventFactoryKt.newMetric((String)"Screen.Scale", (FeatureUsageData)data2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/fus/ui/UiInfoUsageCollector", "getDescriptors"));
    }
}

