/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.fileTypes;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.fileTypes.FileTypeStatisticProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/statistic/fileTypes/UpdateComponentEditorListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "()V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "Companion", "intellij.platform.ide.impl"})
final class UpdateComponentEditorListener
implements EditorFactoryListener {
    private static final Object lock;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void editorCreated(@NotNull EditorFactoryEvent event) {
        block6: {
            Object v7;
            boolean bl;
            Object object;
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    return;
                }
                Editor editor = event.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"event.editor");
                Document document = editor.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"event.editor.document");
                Document document2 = document;
                VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document2);
                if (virtualFile2 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"FileDocumentManager.getI\u2026tFile(document) ?: return");
                VirtualFile file2 = virtualFile2;
                FileType fileType = file2.getFileType();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"file.fileType");
                FileType fileType2 = fileType;
                ExtensionPointName<FileTypeStatisticProvider> extensionPointName = FileTypeStatisticProvider.EP_NAME;
                Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"FileTypeStatisticProvider.EP_NAME");
                List<FileTypeStatisticProvider> list2 = extensionPointName.getExtensionList();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"FileTypeStatisticProvider.EP_NAME.extensionList");
                object = list2;
                bl = false;
                Iterable iterable = object;
                boolean bl2 = false;
                for (Object t : iterable) {
                    FileTypeStatisticProvider ep = (FileTypeStatisticProvider)t;
                    boolean bl3 = false;
                    if (!ep.accept(event, fileType2)) continue;
                    v7 = t;
                    break block5;
                }
                v7 = null;
            }
            FileTypeStatisticProvider fileTypeStatisticProvider = v7;
            if (fileTypeStatisticProvider == null) break block6;
            object = fileTypeStatisticProvider;
            bl = false;
            boolean bl4 = false;
            Object ep = object;
            boolean bl5 = false;
            UpdateComponentEditorListener.Companion.updateOnPooledThread((FileTypeStatisticProvider)ep);
            Editor editor = event.getEditor();
            if (!(editor instanceof EditorEx)) {
                editor = null;
            }
            EditorEx editorEx = (EditorEx)editor;
            if (editorEx != null) {
                editorEx.addFocusListener(new FocusChangeListener((FileTypeStatisticProvider)ep){
                    final /* synthetic */ FileTypeStatisticProvider $ep;

                    public final void focusGained(@NotNull Editor it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        com.intellij.internal.statistic.fileTypes.UpdateComponentEditorListener$Companion.access$updateOnPooledThread(UpdateComponentEditorListener.Companion, this.$ep);
                    }
                    {
                        this.$ep = fileTypeStatisticProvider;
                    }
                });
            }
        }
    }

    static {
        Companion = new Companion(null);
        Object object = ObjectUtils.sentinel("updating_monitor");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ObjectUtils.sentinel(\"updating_monitor\")");
        lock = object;
        Logger logger = Logger.getInstance(UpdateComponentEditorListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Updat\u2026itorListener::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0019\u0010\u0013\u001a\u000b\u0012\u0002\b\u00030\u0014\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/fileTypes/UpdateComponentEditorListener$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "lock", "checkUpdateRequired", "", "pluginIdString", "", "pluginVersion", "getUpdateUrl", "sendRequest", "", "url", "update", "ep", "Lcom/intellij/internal/statistic/fileTypes/FileTypeStatisticProvider;", "updateOnPooledThread", "Ljava/util/concurrent/Future;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final Future<?> updateOnPooledThread(FileTypeStatisticProvider ep) {
            Future<?> future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(ep){
                final /* synthetic */ FileTypeStatisticProvider $ep;

                public final void run() {
                    com.intellij.internal.statistic.fileTypes.UpdateComponentEditorListener$Companion.access$update(UpdateComponentEditorListener.Companion, this.$ep);
                }
                {
                    this.$ep = fileTypeStatisticProvider;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(future2, (String)"ApplicationManager.getAp\u2026       update(ep)\n      }");
            return future2;
        }

        private final void update(FileTypeStatisticProvider ep) {
            String pluginVersion;
            String string = ep.getPluginId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ep.pluginId");
            String pluginIdString = string;
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin(PluginId.getId(pluginIdString));
            if (plugin == null) {
                LOG.error("Unknown plugin id: " + pluginIdString + " is reported by " + ep.getClass());
                return;
            }
            String string2 = pluginVersion = plugin.getVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"pluginVersion");
            if (!this.checkUpdateRequired(pluginIdString, string2)) {
                return;
            }
            String url = this.getUpdateUrl(pluginIdString, pluginVersion);
            this.sendRequest(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean checkUpdateRequired(String pluginIdString, String pluginVersion) {
            Object object = lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                PropertiesComponent properties;
                String lastUpdateKey;
                String lastVersionKey;
                block4: {
                    boolean shouldUpdate;
                    boolean bl3 = false;
                    lastVersionKey = pluginIdString + ".LAST_VERSION";
                    lastUpdateKey = pluginIdString + ".LAST_UPDATE";
                    properties = PropertiesComponent.getInstance();
                    String lastPluginVersion = properties.getValue(lastVersionKey);
                    long lastUpdate = properties.getLong(lastUpdateKey, 0L);
                    boolean bl4 = shouldUpdate = lastUpdate == 0L || System.currentTimeMillis() - lastUpdate > TimeUnit.DAYS.toMillis(1L) || lastPluginVersion == null || Intrinsics.areEqual((Object)lastPluginVersion, (Object)pluginVersion) ^ true;
                    if (shouldUpdate) break block4;
                    boolean bl5 = false;
                    return bl5;
                }
                properties.setValue(lastUpdateKey, String.valueOf(System.currentTimeMillis()));
                properties.setValue(lastVersionKey, pluginVersion);
                boolean bl6 = true;
                return bl6;
            }
        }

        private final void sendRequest(String url) {
            try {
                HttpRequests.request(url).connect(new HttpRequests.RequestProcessor<Unit>(url){
                    final /* synthetic */ String $url;

                    public final void process(@NotNull HttpRequests.Request it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        try {
                            JDOMUtil.load(it.getReader());
                        }
                        catch (JDOMException e) {
                            UpdateComponentEditorListener.access$getLOG$cp().warn(e);
                        }
                        UpdateComponentEditorListener.access$getLOG$cp().info("updated: " + this.$url);
                    }
                    {
                        this.$url = string;
                    }
                });
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (IOException e) {
                LOG.warn(e);
            }
        }

        private final String getUpdateUrl(String pluginIdString, String pluginVersion) {
            ApplicationInfoEx applicationInfo;
            ApplicationInfoEx applicationInfoEx = applicationInfo = ApplicationInfoEx.getInstanceEx();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfoEx, (String)"applicationInfo");
            String string = applicationInfoEx.getBuild().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"applicationInfo.build.asString()");
            String buildNumber = string;
            String os = URLEncoder.encode(SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION, Charsets.UTF_8.name());
            String string2 = PermanentInstallationID.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PermanentInstallationID.get()");
            String uid = string2;
            String baseUrl = "https://plugins.jetbrains.com/plugins/list";
            return baseUrl + "?pluginId=" + pluginIdString + "&build=" + buildNumber + "&pluginVersion=" + pluginVersion + "&os=" + os + "&uuid=" + uid;
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$update(Companion $this, FileTypeStatisticProvider ep) {
            $this.update(ep);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

