/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.tools;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionsUsagesCollector
extends ProjectUsagesCollector {
    private static final Predicate<ScopeToolState> ENABLED = state -> !state.getTool().isEnabledByDefault() && state.isEnabled();
    private static final Predicate<ScopeToolState> DISABLED = state -> state.getTool().isEnabledByDefault() && !state.isEnabled();
    private static final String SETTING_VALUE = "option_value";
    private static final String SETTING_TYPE = "option_type";
    private static final String SETTING_INDEX = "option_index";
    private static final String INSPECTION_ID = "inspection_id";

    @NotNull
    public String getGroupId() {
        return "inspections";
    }

    public int getVersion() {
        return 4;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project2) {
        if (project2 == null) {
            InspectionsUsagesCollector.$$$reportNull$$$0(0);
        }
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        List<ScopeToolState> tools = InspectionProjectProfileManager.getInstance(project2).getCurrentProfile().getAllTools();
        for (ScopeToolState state : tools) {
            InspectionToolWrapper<?, ?> tool = state.getTool();
            PluginInfo pluginInfo = InspectionsUsagesCollector.getInfo(tool);
            if (ENABLED.test(state)) {
                result2.add(InspectionsUsagesCollector.create(tool, pluginInfo, true));
            } else if (DISABLED.test(state)) {
                result2.add(InspectionsUsagesCollector.create(tool, pluginInfo, false));
            }
            result2.addAll(InspectionsUsagesCollector.getChangedSettingsEvents(tool, pluginInfo, state.isEnabled()));
        }
        HashSet<MetricEvent> hashSet = result2;
        if (hashSet == null) {
            InspectionsUsagesCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static Collection<MetricEvent> getChangedSettingsEvents(InspectionToolWrapper<?, ?> tool, PluginInfo pluginInfo, boolean inspectionEnabled) {
        if (!InspectionsUsagesCollector.isSafeToReport(pluginInfo)) {
            return Collections.emptyList();
        }
        ArrayList<MetricEvent> result2 = new ArrayList<MetricEvent>();
        String inspectionId = tool.getID();
        List<Content> options = InspectionsUsagesCollector.getOptions(tool);
        for (int i = 0; i < options.size(); ++i) {
            Attribute settingValue;
            Content option2 = options.get(i);
            if (!(option2 instanceof Element) || (settingValue = ((Element)option2).getAttribute("value")) == null) continue;
            FeatureUsageData data2 = new FeatureUsageData();
            data2.addData(SETTING_INDEX, i);
            data2.addData(INSPECTION_ID, inspectionId);
            data2.addData("inspection_enabled", inspectionEnabled);
            data2.addPluginInfo(pluginInfo);
            if (!InspectionsUsagesCollector.addSettingValue(settingValue, data2)) continue;
            result2.add(MetricEventFactoryKt.newMetric((String)"setting.non.default.state", (FeatureUsageData)data2));
        }
        return result2;
    }

    private static boolean addSettingValue(Attribute settingValueAttribute, FeatureUsageData data2) {
        try {
            boolean booleanValue = settingValueAttribute.getBooleanValue();
            data2.addData(SETTING_VALUE, booleanValue);
            data2.addData(SETTING_TYPE, "boolean");
            return true;
        }
        catch (DataConversionException e) {
            return InspectionsUsagesCollector.addIntValue(settingValueAttribute, data2);
        }
    }

    private static boolean addIntValue(Attribute value2, FeatureUsageData data2) {
        try {
            int intValue = value2.getIntValue();
            data2.addData(SETTING_VALUE, intValue);
            data2.addData(SETTING_TYPE, "integer");
            return true;
        }
        catch (DataConversionException e) {
            return false;
        }
    }

    @NotNull
    private static MetricEvent create(InspectionToolWrapper<?, ?> tool, PluginInfo info, boolean enabled) {
        FeatureUsageData data2 = new FeatureUsageData().addData("enabled", enabled);
        String language2 = tool.getLanguage();
        if (StringUtil.isNotEmpty(language2)) {
            data2.addLanguage(Language.findLanguageByID(language2));
        }
        if (info != null) {
            data2.addPluginInfo(info);
        }
        data2.addData(INSPECTION_ID, InspectionsUsagesCollector.isSafeToReport(info) ? tool.getID() : "third.party");
        MetricEvent metricEvent = MetricEventFactoryKt.newMetric((String)"not.default.state", (FeatureUsageData)data2);
        if (metricEvent == null) {
            InspectionsUsagesCollector.$$$reportNull$$$0(2);
        }
        return metricEvent;
    }

    private static boolean isSafeToReport(PluginInfo info) {
        return info != null && info.isSafeToReport();
    }

    @Nullable
    private static PluginInfo getInfo(InspectionToolWrapper<?, ?> tool) {
        Object extension = tool.getExtension();
        PluginDescriptor pluginDescriptor = extension == null ? null : ((BaseKeyedLazyInstance)extension).getPluginDescriptor();
        return pluginDescriptor != null ? PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor) : null;
    }

    @NotNull
    private static List<Content> getOptions(InspectionToolWrapper<?, ?> tool) {
        List<Content> list2;
        Element options = new Element("options");
        try {
            ScopeToolState.tryWriteSettings(tool.getTool(), options);
            list2 = options.getContent();
        }
        catch (Exception e) {
            List<Content> list3 = Collections.emptyList();
            if (list3 == null) {
                InspectionsUsagesCollector.$$$reportNull$$$0(4);
            }
            return list3;
        }
        if (list2 == null) {
            InspectionsUsagesCollector.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/tools/InspectionsUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/tools/InspectionsUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InspectionToolValidator
    extends CustomWhiteListRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "tool".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                InspectionToolValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                InspectionToolValidator.$$$reportNull$$$0(1);
            }
            if (InspectionToolValidator.isThirdPartyValue((String)data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    InspectionToolValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = InspectionToolValidator.acceptWhenReportedByPluginFromPluginRepository((EventContext)context);
            if (validationResultType == null) {
                InspectionToolValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/InspectionsUsagesCollector$InspectionToolValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/InspectionsUsagesCollector$InspectionToolValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

