/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.validation;

import com.intellij.internal.validation.ValidTest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ValidationTest
extends DialogWrapper {
    private final ValidTest myPanel = new ValidTest();
    final ValidationInfo[] ERRORS;

    protected ValidationTest(Project project2) {
        super(project2);
        this.ERRORS = new ValidationInfo[]{new ValidationInfo("Field1 should not be empty", this.myPanel.field1), new ValidationInfo("Field2 is zip. It should contain 5 digits", this.myPanel.field2), new ValidationInfo("Field3. Value is not chosen", this.myPanel.field3), new ValidationInfo("Field4: Select A or B", this.myPanel.p4), new ValidationInfo("Field5: You should accept license agreement<br/>text text text text text text text text text text text text<br/>text text text text text text text text text text text text"), new ValidationInfo("editableComboBox: should contain some value", this.myPanel.comboBox), new ValidationInfo("Spinner should contain values between 20 and 30", this.myPanel.spinner)};
        this.init();
        this.myPanel.field5.addActionListener(e -> this.myPanel.spinner.setEnabled(this.myPanel.field5.isSelected()));
        this.myPanel.spinner.setEnabled(this.myPanel.field5.isSelected());
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.field2;
    }

    @Override
    protected void doOKAction() {
        super.doOKAction();
        Messages.showInfoMessage("on OK", "Info");
    }

    @Override
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ArrayList<ValidationInfo> result2 = new ArrayList<ValidationInfo>();
        if (this.myPanel.field1.getText().isEmpty()) {
            result2.add(this.ERRORS[0]);
        }
        if (!Pattern.compile("[0-9]{5}").matcher(this.myPanel.field2.getText()).matches()) {
            result2.add(this.ERRORS[1]);
        }
        if (this.myPanel.field3.getSelectedItem() == null || "".equals(this.myPanel.field3.getSelectedItem())) {
            result2.add(this.ERRORS[2]);
        }
        if (!this.myPanel.field4A.isSelected() && !this.myPanel.field4B.isSelected()) {
            result2.add(this.ERRORS[3]);
        }
        if (!this.myPanel.field5.isSelected()) {
            result2.add(this.ERRORS[4]);
        }
        if (this.myPanel.comboBox.getSelectedItem() == null || "".equals(this.myPanel.comboBox.getSelectedItem()) || this.myPanel.comboBox.getEditor().getItem() == null) {
            result2.add(this.ERRORS[5]);
        }
        Object value2 = this.myPanel.spinner.getValue();
        try {
            int iv = Integer.parseInt(String.valueOf(value2));
            if (value2 == null || iv < 20 || iv > 30) {
                result2.add(this.ERRORS[6]);
            }
        }
        catch (NumberFormatException nfe) {
            result2.add(this.ERRORS[6]);
        }
        ArrayList<ValidationInfo> arrayList = result2;
        if (arrayList == null) {
            ValidationTest.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    protected JComponent createCenterPanel() {
        return this.myPanel.panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/validation/ValidationTest", "doValidateAll"));
    }
}

