/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare(o1.getDisplayName(), o2.getDisplayName());
    private static final Key<Collection<MetaLanguage>> MATCHING_LANGUAGES = Key.create("language.matching");

    private LanguageUtil() {
    }

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project2, @Nullable VirtualFile file2) {
        Language language2;
        if (project2 == null) {
            LanguageUtil.$$$reportNull$$$0(0);
        }
        if ((language2 = LanguageUtil.getFileLanguage(file2)) == null) {
            return null;
        }
        return LanguageSubstitutors.getInstance().substituteLanguage(language2, file2, project2);
    }

    @Nullable
    public static Language getFileLanguage(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        Language l = file2 instanceof LightVirtualFile ? ((LightVirtualFile)file2).getLanguage() : null;
        return l != null ? l : LanguageUtil.getFileTypeLanguage(file2.getFileType());
    }

    @Nullable
    public static Language getFileTypeLanguage(@Nullable FileType fileType) {
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    @Nullable
    public static FileType getLanguageFileType(@Nullable Language language2) {
        return language2 == null ? null : language2.getAssociatedFileType();
    }

    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(ASTNode left, ASTNode right, Lexer lexer) {
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenEnd() != left.getTextLength()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenType() != right.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public static Set<Language> getAllDerivedLanguages(@NotNull Language base) {
        if (base == null) {
            LanguageUtil.$$$reportNull$$$0(1);
        }
        HashSet<Language> result2 = new HashSet<Language>();
        LanguageUtil.getAllDerivedLanguages(base, result2);
        HashSet<Language> hashSet = result2;
        if (hashSet == null) {
            LanguageUtil.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static void getAllDerivedLanguages(Language base, Set<Language> result2) {
        result2.add(base);
        for (Language dialect : base.getDialects()) {
            LanguageUtil.getAllDerivedLanguages(dialect, result2);
        }
    }

    public static boolean isInTemplateLanguageFile(@Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        PsiFile psiFile = element2.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        Language language2 = psiFile.getViewProvider().getBaseLanguage();
        return language2 instanceof TemplateLanguage;
    }

    public static boolean isInjectableLanguage(@NotNull Language language2) {
        if (language2 == null) {
            LanguageUtil.$$$reportNull$$$0(3);
        }
        if (language2 == Language.ANY) {
            return false;
        }
        if (language2.getID().startsWith("$")) {
            return false;
        }
        if (language2 instanceof InjectableLanguage) {
            return true;
        }
        if (language2 instanceof TemplateLanguage || language2 instanceof DependentLanguage) {
            return false;
        }
        return LanguageParserDefinitions.INSTANCE.forLanguage(language2) != null;
    }

    public static boolean isFileLanguage(@NotNull Language language2) {
        if (language2 == null) {
            LanguageUtil.$$$reportNull$$$0(4);
        }
        if (language2 instanceof DependentLanguage || language2 instanceof InjectableLanguage) {
            return false;
        }
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language2) == null) {
            return false;
        }
        LanguageFileType type = language2.getAssociatedFileType();
        if (type == null || StringUtil.isEmpty(type.getDefaultExtension())) {
            return false;
        }
        return StringUtil.isNotEmpty(type.getDefaultExtension());
    }

    @NotNull
    public static List<Language> getFileLanguages() {
        LanguageParserDefinitions.INSTANCE.ensureValuesLoaded();
        ArrayList<Language> result2 = new ArrayList<Language>();
        for (Language language2 : Language.getRegisteredLanguages()) {
            if (!LanguageUtil.isFileLanguage(language2)) continue;
            result2.add(language2);
        }
        result2.sort(LANGUAGE_COMPARATOR);
        ArrayList<Language> arrayList = result2;
        if (arrayList == null) {
            LanguageUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static Language getRootLanguage(@NotNull PsiElement element2) {
        Language language2;
        PsiFile containingFile;
        FileViewProvider provider;
        Set<Language> languages;
        if (element2 == null) {
            LanguageUtil.$$$reportNull$$$0(6);
        }
        if ((languages = (provider = (containingFile = element2.getContainingFile()).getViewProvider()).getLanguages()).size() > 1 && languages.contains(language2 = containingFile.getLanguage())) {
            Language language3 = language2;
            if (language3 == null) {
                LanguageUtil.$$$reportNull$$$0(7);
            }
            return language3;
        }
        Language language4 = provider.getBaseLanguage();
        if (language4 == null) {
            LanguageUtil.$$$reportNull$$$0(8);
        }
        return language4;
    }

    @NotNull
    static Collection<MetaLanguage> matchingMetaLanguages(@NotNull Language language2) {
        if (language2 == null) {
            LanguageUtil.$$$reportNull$$$0(9);
        }
        if (!Extensions.getRootArea().hasExtensionPoint(MetaLanguage.EP_NAME)) {
            List<MetaLanguage> list2 = Collections.emptyList();
            if (list2 == null) {
                LanguageUtil.$$$reportNull$$$0(10);
            }
            return list2;
        }
        Collection<MetaLanguage> cached = language2.getUserData(MATCHING_LANGUAGES);
        if (cached != null) {
            Collection<MetaLanguage> collection = cached;
            if (collection == null) {
                LanguageUtil.$$$reportNull$$$0(11);
            }
            return collection;
        }
        Set result2 = MetaLanguage.getAllMatchingMetaLanguages(language2).collect(Collectors.toSet());
        Collection collection = language2.putUserDataIfAbsent(MATCHING_LANGUAGES, result2);
        if (collection == null) {
            LanguageUtil.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    static JBIterable<Language> hierarchy(@NotNull Language language2) {
        if (language2 == null) {
            LanguageUtil.$$$reportNull$$$0(13);
        }
        JBIterable<Language> jBIterable = JBIterable.generate(language2, Language::getBaseLanguage);
        if (jBIterable == null) {
            LanguageUtil.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/LanguageUtil";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/LanguageUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDerivedLanguages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileLanguages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootLanguage";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "matchingMetaLanguages";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "hierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForPsi";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllDerivedLanguages";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInjectableLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRootLanguage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matchingMetaLanguages";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

