/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.annotation;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Annotation
implements Segment {
    private final int myStartOffset;
    private final int myEndOffset;
    private final HighlightSeverity mySeverity;
    private final String myMessage;
    private ProblemHighlightType myHighlightType;
    private TextAttributesKey myEnforcedAttributesKey;
    private TextAttributes myEnforcedAttributes;
    private List<QuickFixInfo> myQuickFixes;
    private Boolean myNeedsUpdateOnTyping;
    private String myTooltip;
    private boolean myAfterEndOfLine;
    private boolean myIsFileLevelAnnotation;
    private GutterIconRenderer myGutterIconRenderer;
    @Nullable
    private ProblemGroup myProblemGroup;
    private List<QuickFixInfo> myBatchFixes;

    @ApiStatus.Internal
    public Annotation(int startOffset, int endOffset, @NotNull HighlightSeverity severity, String message, String tooltip) {
        if (severity == null) {
            Annotation.$$$reportNull$$$0(0);
        }
        this.myHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        assert (startOffset <= endOffset) : startOffset + ":" + endOffset;
        assert (startOffset >= 0) : "Start offset must not be negative: " + startOffset;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myMessage = message;
        this.myTooltip = tooltip;
        this.mySeverity = severity;
    }

    public void registerFix(@NotNull IntentionAction fix2) {
        if (fix2 == null) {
            Annotation.$$$reportNull$$$0(1);
        }
        this.registerFix(fix2, null);
    }

    public void registerFix(@NotNull IntentionAction fix2, TextRange range2) {
        if (fix2 == null) {
            Annotation.$$$reportNull$$$0(2);
        }
        this.registerFix(fix2, range2, null);
    }

    public void registerFix(@NotNull LocalQuickFix fix2, @Nullable TextRange range2, @Nullable HighlightDisplayKey key, @NotNull ProblemDescriptor problemDescriptor) {
        if (fix2 == null) {
            Annotation.$$$reportNull$$$0(3);
        }
        if (problemDescriptor == null) {
            Annotation.$$$reportNull$$$0(4);
        }
        range2 = this.notNullize(range2);
        if (this.myQuickFixes == null) {
            this.myQuickFixes = new ArrayList<QuickFixInfo>();
        }
        this.myQuickFixes.add(new QuickFixInfo(new LocalQuickFixAsIntentionAdapter(fix2, problemDescriptor), range2, key));
    }

    public void registerFix(@NotNull IntentionAction fix2, @Nullable TextRange range2, @Nullable HighlightDisplayKey key) {
        if (fix2 == null) {
            Annotation.$$$reportNull$$$0(5);
        }
        range2 = this.notNullize(range2);
        List<QuickFixInfo> fixes = this.myQuickFixes;
        if (fixes == null) {
            this.myQuickFixes = fixes = new ArrayList<QuickFixInfo>();
        }
        fixes.add(new QuickFixInfo(fix2, range2, key));
    }

    @NotNull
    private TextRange notNullize(@Nullable TextRange range2) {
        TextRange textRange = range2 == null ? new TextRange(this.myStartOffset, this.myEndOffset) : range2;
        if (textRange == null) {
            Annotation.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    public <T extends IntentionAction & LocalQuickFix> void registerBatchFix(@NotNull T fix2, @Nullable TextRange range2, @Nullable HighlightDisplayKey key) {
        if (fix2 == null) {
            Annotation.$$$reportNull$$$0(7);
        }
        range2 = this.notNullize(range2);
        List<QuickFixInfo> fixes = this.myBatchFixes;
        if (fixes == null) {
            this.myBatchFixes = fixes = new ArrayList<QuickFixInfo>();
        }
        fixes.add(new QuickFixInfo(fix2, range2, key));
    }

    public <T extends IntentionAction & LocalQuickFix> void registerUniversalFix(@NotNull T fix2, @Nullable TextRange range2, @Nullable HighlightDisplayKey key) {
        if (fix2 == null) {
            Annotation.$$$reportNull$$$0(8);
        }
        this.registerBatchFix(fix2, range2, key);
        this.registerFix(fix2, range2, key);
    }

    public void setNeedsUpdateOnTyping(boolean b) {
        this.myNeedsUpdateOnTyping = b;
    }

    public boolean needsUpdateOnTyping() {
        if (this.myNeedsUpdateOnTyping == null) {
            return this.mySeverity != HighlightSeverity.INFORMATION;
        }
        return this.myNeedsUpdateOnTyping;
    }

    @Override
    public int getStartOffset() {
        return this.myStartOffset;
    }

    @Override
    public int getEndOffset() {
        return this.myEndOffset;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            Annotation.$$$reportNull$$$0(9);
        }
        return highlightSeverity;
    }

    @NotNull
    public ProblemHighlightType getHighlightType() {
        ProblemHighlightType problemHighlightType = this.myHighlightType;
        if (problemHighlightType == null) {
            Annotation.$$$reportNull$$$0(10);
        }
        return problemHighlightType;
    }

    @NotNull
    public TextAttributesKey getTextAttributes() {
        if (this.myEnforcedAttributesKey != null) {
            TextAttributesKey textAttributesKey = this.myEnforcedAttributesKey;
            if (textAttributesKey == null) {
                Annotation.$$$reportNull$$$0(11);
            }
            return textAttributesKey;
        }
        switch (this.myHighlightType) {
            case GENERIC_ERROR_OR_WARNING: {
                if (this.mySeverity == HighlightSeverity.ERROR) {
                    TextAttributesKey textAttributesKey = CodeInsightColors.ERRORS_ATTRIBUTES;
                    if (textAttributesKey == null) {
                        Annotation.$$$reportNull$$$0(12);
                    }
                    return textAttributesKey;
                }
                if (this.mySeverity == HighlightSeverity.WARNING) {
                    TextAttributesKey textAttributesKey = CodeInsightColors.WARNINGS_ATTRIBUTES;
                    if (textAttributesKey == null) {
                        Annotation.$$$reportNull$$$0(13);
                    }
                    return textAttributesKey;
                }
                if (this.mySeverity == HighlightSeverity.WEAK_WARNING) {
                    TextAttributesKey textAttributesKey = CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
                    if (textAttributesKey == null) {
                        Annotation.$$$reportNull$$$0(14);
                    }
                    return textAttributesKey;
                }
                TextAttributesKey textAttributesKey = HighlighterColors.NO_HIGHLIGHTING;
                if (textAttributesKey == null) {
                    Annotation.$$$reportNull$$$0(15);
                }
                return textAttributesKey;
            }
            case GENERIC_ERROR: {
                TextAttributesKey textAttributesKey = CodeInsightColors.ERRORS_ATTRIBUTES;
                if (textAttributesKey == null) {
                    Annotation.$$$reportNull$$$0(16);
                }
                return textAttributesKey;
            }
            case LIKE_DEPRECATED: {
                TextAttributesKey textAttributesKey = CodeInsightColors.DEPRECATED_ATTRIBUTES;
                if (textAttributesKey == null) {
                    Annotation.$$$reportNull$$$0(17);
                }
                return textAttributesKey;
            }
            case LIKE_UNUSED_SYMBOL: {
                TextAttributesKey textAttributesKey = CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
                if (textAttributesKey == null) {
                    Annotation.$$$reportNull$$$0(18);
                }
                return textAttributesKey;
            }
            case LIKE_UNKNOWN_SYMBOL: 
            case ERROR: {
                TextAttributesKey textAttributesKey = CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES;
                if (textAttributesKey == null) {
                    Annotation.$$$reportNull$$$0(19);
                }
                return textAttributesKey;
            }
        }
        TextAttributesKey textAttributesKey = HighlighterColors.NO_HIGHLIGHTING;
        if (textAttributesKey == null) {
            Annotation.$$$reportNull$$$0(20);
        }
        return textAttributesKey;
    }

    public TextAttributes getEnforcedTextAttributes() {
        return this.myEnforcedAttributes;
    }

    public void setEnforcedTextAttributes(TextAttributes enforcedAttributes) {
        this.myEnforcedAttributes = enforcedAttributes;
    }

    @Nullable
    public List<QuickFixInfo> getQuickFixes() {
        return this.myQuickFixes;
    }

    @Nullable
    public List<QuickFixInfo> getBatchFixes() {
        return this.myBatchFixes;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public String getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(String tooltip) {
        this.myTooltip = tooltip;
    }

    public void setHighlightType(@NotNull ProblemHighlightType highlightType) {
        if (highlightType == null) {
            Annotation.$$$reportNull$$$0(21);
        }
        this.myHighlightType = highlightType;
    }

    public void setTextAttributes(TextAttributesKey enforcedAttributes) {
        this.myEnforcedAttributesKey = enforcedAttributes;
    }

    public boolean isAfterEndOfLine() {
        return this.myAfterEndOfLine;
    }

    public void setAfterEndOfLine(boolean afterEndOfLine) {
        this.myAfterEndOfLine = afterEndOfLine;
    }

    public boolean isFileLevelAnnotation() {
        return this.myIsFileLevelAnnotation;
    }

    public void setFileLevelAnnotation(boolean isFileLevelAnnotation) {
        this.myIsFileLevelAnnotation = isFileLevelAnnotation;
    }

    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    public void setGutterIconRenderer(@Nullable GutterIconRenderer gutterIconRenderer) {
        this.myGutterIconRenderer = gutterIconRenderer;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
        this.myProblemGroup = problemGroup;
    }

    @NonNls
    public String toString() {
        return "Annotation(message='" + this.myMessage + "', severity='" + this.mySeverity + "', toolTip='" + this.myTooltip + "')";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/annotation/Annotation";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/annotation/Annotation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerFix";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerBatchFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerUniversalFix";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class QuickFixInfo {
        @NotNull
        public final IntentionAction quickFix;
        @NotNull
        public final TextRange textRange;
        public final HighlightDisplayKey key;

        QuickFixInfo(@NotNull IntentionAction fix2, @NotNull TextRange range2, @Nullable HighlightDisplayKey key) {
            if (fix2 == null) {
                QuickFixInfo.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                QuickFixInfo.$$$reportNull$$$0(1);
            }
            this.key = key;
            this.quickFix = fix2;
            this.textRange = range2;
        }

        public String toString() {
            return this.quickFix.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/annotation/Annotation$QuickFixInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

