/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFoldingRegionsPopup {
    public static void show(@NotNull Collection<? extends FoldingDescriptor> descriptors, @NotNull Editor editor, @NotNull Project project2) {
        if (descriptors == null) {
            CustomFoldingRegionsPopup.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CustomFoldingRegionsPopup.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            CustomFoldingRegionsPopup.$$$reportNull$$$0(2);
        }
        List<MyFoldingDescriptorWrapper> model = CustomFoldingRegionsPopup.orderByPosition(descriptors);
        JBPopupFactory.getInstance().createPopupChooserBuilder(model).setTitle(IdeBundle.message("goto.custom.region.command", new Object[0])).setResizable(false).setMovable(false).setItemChosenCallback(selection -> {
            PsiElement navigationElement = selection.getDescriptor().getElement().getPsi();
            if (navigationElement != null) {
                CustomFoldingRegionsPopup.navigateTo(editor, navigationElement);
                IdeDocumentHistory.getInstance(project2).includeCurrentCommandAsNavigation();
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    private static List<MyFoldingDescriptorWrapper> orderByPosition(Collection<? extends FoldingDescriptor> descriptors) {
        ArrayList<? extends FoldingDescriptor> sorted = new ArrayList<FoldingDescriptor>(descriptors.size());
        sorted.addAll(descriptors);
        Collections.sort(sorted, (descriptor1, descriptor2) -> {
            int pos1 = descriptor1.getElement().getTextRange().getStartOffset();
            int pos2 = descriptor2.getElement().getTextRange().getStartOffset();
            return pos1 - pos2;
        });
        Stack<FoldingDescriptor> stack = new Stack<FoldingDescriptor>();
        ArrayList<MyFoldingDescriptorWrapper> result2 = new ArrayList<MyFoldingDescriptorWrapper>();
        for (FoldingDescriptor foldingDescriptor : sorted) {
            while (!stack.isEmpty() && foldingDescriptor.getRange().getStartOffset() >= ((FoldingDescriptor)stack.peek()).getRange().getEndOffset()) {
                stack.pop();
            }
            result2.add(new MyFoldingDescriptorWrapper(foldingDescriptor, stack.size()));
            stack.push(foldingDescriptor);
        }
        return result2;
    }

    private static void navigateTo(@NotNull Editor editor, @NotNull PsiElement element2) {
        int offset;
        if (editor == null) {
            CustomFoldingRegionsPopup.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            CustomFoldingRegionsPopup.$$$reportNull$$$0(4);
        }
        if ((offset = element2.getTextRange().getStartOffset()) >= 0 && offset < editor.getDocument().getTextLength()) {
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            editor.getSelectionModel().removeSelection();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/customFolding/CustomFoldingRegionsPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyFoldingDescriptorWrapper {
        @NotNull
        private final FoldingDescriptor myDescriptor;
        private final int myIndent;

        private MyFoldingDescriptorWrapper(@NotNull FoldingDescriptor descriptor2, int indent) {
            if (descriptor2 == null) {
                MyFoldingDescriptorWrapper.$$$reportNull$$$0(0);
            }
            this.myDescriptor = descriptor2;
            this.myIndent = indent;
        }

        @NotNull
        public FoldingDescriptor getDescriptor() {
            FoldingDescriptor foldingDescriptor = this.myDescriptor;
            if (foldingDescriptor == null) {
                MyFoldingDescriptorWrapper.$$$reportNull$$$0(1);
            }
            return foldingDescriptor;
        }

        @Nullable
        public String toString() {
            return StringUtil.repeat("   ", this.myIndent) + this.myDescriptor.getPlaceholderText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/customFolding/CustomFoldingRegionsPopup$MyFoldingDescriptorWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/customFolding/CustomFoldingRegionsPopup$MyFoldingDescriptorWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

