/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.lang.customFolding.CustomFoldingRegionsPopup;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoCustomRegionAction
extends AnAction
implements DumbAware,
PopupAction {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(0);
        }
        Project project2 = e.getProject();
        Editor editor = e.getData(CommonDataKeys.EDITOR);
        if (Boolean.TRUE.equals(e.getData(PlatformDataKeys.IS_MODAL_CONTEXT))) {
            return;
        }
        if (project2 != null && editor != null) {
            if (DumbService.getInstance(project2).isDumb()) {
                DumbService.getInstance(project2).showDumbModeNotification(IdeBundle.message("goto.custom.region.message.dumb.mode", new Object[0]));
                return;
            }
            CommandProcessor processor2 = CommandProcessor.getInstance();
            processor2.executeCommand(project2, () -> {
                Collection<FoldingDescriptor> foldingDescriptors = GotoCustomRegionAction.getCustomFoldingDescriptors(editor, project2);
                if (foldingDescriptors.size() > 0) {
                    CustomFoldingRegionsPopup.show(foldingDescriptors, editor, project2);
                } else {
                    GotoCustomRegionAction.notifyCustomRegionsUnavailable(editor, project2);
                }
            }, IdeBundle.message("goto.custom.region.command", new Object[0]), null);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        presentation.setText(IdeBundle.messagePointer("goto.custom.region.menu.item", new Object[0]));
        Editor editor = e.getData(CommonDataKeys.EDITOR);
        Project project2 = e.getProject();
        boolean isAvailable = editor != null && project2 != null;
        presentation.setEnabledAndVisible(isAvailable);
    }

    @NotNull
    private static Collection<FoldingDescriptor> getCustomFoldingDescriptors(@NotNull Editor editor, @NotNull Project project2) {
        PsiFile file2;
        if (editor == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(3);
        }
        HashSet<FoldingDescriptor> foldingDescriptors = new HashSet<FoldingDescriptor>();
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
        PsiFile psiFile = file2 = documentManager != null ? documentManager.getPsiFile(document) : null;
        if (file2 != null) {
            FileViewProvider viewProvider = file2.getViewProvider();
            for (Language language2 : viewProvider.getLanguages()) {
                PsiFile psi = viewProvider.getPsi(language2);
                FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language2);
                if (psi == null) continue;
                for (FoldingDescriptor descriptor2 : LanguageFolding.buildFoldingDescriptors(foldingBuilder, psi, document, false)) {
                    CustomFoldingBuilder customFoldingBuilder = GotoCustomRegionAction.getCustomFoldingBuilder(foldingBuilder, descriptor2);
                    if (customFoldingBuilder == null || !customFoldingBuilder.isCustomRegionStart(descriptor2.getElement())) continue;
                    foldingDescriptors.add(descriptor2);
                }
            }
        }
        HashSet<FoldingDescriptor> hashSet = foldingDescriptors;
        if (hashSet == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @Nullable
    private static CustomFoldingBuilder getCustomFoldingBuilder(FoldingBuilder builder2, FoldingDescriptor descriptor2) {
        if (builder2 instanceof CustomFoldingBuilder) {
            return (CustomFoldingBuilder)builder2;
        }
        FoldingBuilder originalBuilder = CompositeFoldingBuilder.getOriginalBuilder(descriptor2);
        if (originalBuilder instanceof CustomFoldingBuilder) {
            return (CustomFoldingBuilder)originalBuilder;
        }
        return null;
    }

    private static void notifyCustomRegionsUnavailable(@NotNull Editor editor, @NotNull Project project2) {
        if (editor == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(6);
        }
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        Balloon balloon = popupFactory.createHtmlTextBalloonBuilder(IdeBundle.message("goto.custom.region.message.unavailable", new Object[0]), MessageType.INFO, null).setFadeoutTime(2000L).setHideOnClickOutside(true).setHideOnKeyOutside(true).createBalloon();
        Disposer.register(project2, balloon);
        balloon.show(popupFactory.guessBestPopupLocation(editor), Balloon.Position.below);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/customFolding/GotoCustomRegionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/customFolding/GotoCustomRegionAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomFoldingDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCustomFoldingDescriptors";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyCustomRegionsUnavailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

