/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.psi.PsiElement;
import com.intellij.util.KeyedLazyInstance;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageFolding
extends LanguageExtension<FoldingBuilder> {
    public static final ExtensionPointName<KeyedLazyInstance<FoldingBuilder>> EP_NAME = ExtensionPointName.create("com.intellij.lang.foldingBuilder");
    public static final LanguageFolding INSTANCE = new LanguageFolding();
    private static final Logger LOG = Logger.getInstance(LanguageFolding.class);

    private LanguageFolding() {
        super(EP_NAME);
    }

    @Override
    public FoldingBuilder forLanguage(@NotNull Language l) {
        if (l == null) {
            LanguageFolding.$$$reportNull$$$0(0);
        }
        return (FoldingBuilder)super.forLanguage(l);
    }

    @Override
    protected FoldingBuilder findForLanguage(@NotNull Language l) {
        List<FoldingBuilder> extensions2;
        if (l == null) {
            LanguageFolding.$$$reportNull$$$0(1);
        }
        if ((extensions2 = this.allForLanguage(l)).isEmpty()) {
            return null;
        }
        if (extensions2.size() == 1) {
            return extensions2.get(0);
        }
        return new CompositeFoldingBuilder(extensions2);
    }

    @Override
    @NotNull
    public List<FoldingBuilder> allForLanguage(@NotNull Language language2) {
        if (language2 == null) {
            LanguageFolding.$$$reportNull$$$0(2);
        }
        for (Language l = language2; l != null; l = l.getBaseLanguage()) {
            List<FoldingBuilder> extensions2 = this.forKey(l);
            if (extensions2.isEmpty()) continue;
            List<FoldingBuilder> list2 = extensions2;
            if (list2 == null) {
                LanguageFolding.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List<FoldingBuilder> list3 = Collections.emptyList();
        if (list3 == null) {
            LanguageFolding.$$$reportNull$$$0(4);
        }
        return list3;
    }

    public static FoldingDescriptor @NotNull [] buildFoldingDescriptors(@Nullable FoldingBuilder builder2, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        FoldingDescriptor[] descriptors;
        if (root == null) {
            LanguageFolding.$$$reportNull$$$0(5);
        }
        if (document == null) {
            LanguageFolding.$$$reportNull$$$0(6);
        }
        for (FoldingDescriptor descriptor2 : descriptors = LanguageFolding.buildFoldingDescriptorsNoPlaceholderCaching(builder2, root, document, quick)) {
            descriptor2.setPlaceholderText(descriptor2.getPlaceholderText());
        }
        if (descriptors == null) {
            LanguageFolding.$$$reportNull$$$0(7);
        }
        return descriptors;
    }

    static FoldingDescriptor @NotNull [] buildFoldingDescriptorsNoPlaceholderCaching(@Nullable FoldingBuilder builder2, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        FoldingDescriptor[] foldingDescriptorArray;
        ASTNode astNode;
        block14: {
            block15: {
                block13: {
                    block11: {
                        block12: {
                            if (root == null) {
                                LanguageFolding.$$$reportNull$$$0(8);
                            }
                            if (document == null) {
                                LanguageFolding.$$$reportNull$$$0(9);
                            }
                            if (DumbService.isDumbAware(builder2) || !DumbService.getInstance(root.getProject()).isDumb()) break block11;
                            if (FoldingDescriptor.EMPTY != null) break block12;
                            LanguageFolding.$$$reportNull$$$0(10);
                        }
                        return FoldingDescriptor.EMPTY;
                    }
                    if (!(builder2 instanceof FoldingBuilderEx)) break block13;
                    FoldingDescriptor[] foldingDescriptorArray2 = ((FoldingBuilderEx)builder2).buildFoldRegions(root, document, quick);
                    if (foldingDescriptorArray2 == null) {
                        LanguageFolding.$$$reportNull$$$0(11);
                    }
                    return foldingDescriptorArray2;
                }
                astNode = root.getNode();
                if (astNode != null && builder2 != null) break block14;
                if (FoldingDescriptor.EMPTY != null) break block15;
                LanguageFolding.$$$reportNull$$$0(12);
            }
            return FoldingDescriptor.EMPTY;
        }
        try {
            foldingDescriptorArray = builder2.buildFoldRegions(astNode, document);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
            if (FoldingDescriptor.EMPTY == null) {
                LanguageFolding.$$$reportNull$$$0(14);
            }
            return FoldingDescriptor.EMPTY;
        }
        if (foldingDescriptorArray == null) {
            LanguageFolding.$$$reportNull$$$0(13);
        }
        return foldingDescriptorArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/folding/LanguageFolding";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/folding/LanguageFolding";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldingDescriptors";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldingDescriptorsNoPlaceholderCaching";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findForLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguage";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldingDescriptors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldingDescriptorsNoPlaceholderCaching";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

