/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.impl.MarkerOptionalData;
import com.intellij.lang.impl.MarkerPool;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MarkerProduction
extends TIntArrayList {
    private static final Logger LOG = Logger.getInstance(MarkerProduction.class);
    private static final int LINEAR_SEARCH_LIMIT = 20;
    private final MarkerPool myPool;
    private final MarkerOptionalData myOptionalData;

    MarkerProduction(MarkerPool pool, MarkerOptionalData optionalData) {
        super(256);
        this.myPool = pool;
        this.myOptionalData = optionalData;
    }

    void addBefore(PsiBuilderImpl.ProductionMarker marker, PsiBuilderImpl.ProductionMarker anchor2) {
        this.insert(this.indexOf(anchor2), marker.markerId);
    }

    private int indexOf(PsiBuilderImpl.ProductionMarker marker) {
        int idx = this.findLinearly(marker.markerId);
        if (idx < 0) {
            idx = this.indexOf(this.findMarkerAtLexeme(marker.getLexemeIndex(false)), marker.markerId);
        }
        if (idx < 0) {
            LOG.error("Dropped or rolled-back marker");
        }
        return idx;
    }

    private int findLinearly(int markerId) {
        int low = Math.max(0, this.size() - 20);
        for (int i = this.size() - 1; i >= low; --i) {
            if (this._data[i] != markerId) continue;
            return i;
        }
        return -1;
    }

    private int findMarkerAtLexeme(int lexemeIndex) {
        int i = ObjectUtils.binarySearch(0, this.size() - 20, mid -> Integer.compare(this.getLexemeIndexAt(mid), lexemeIndex));
        return i < 0 ? -1 : this.findSameLexemeGroupStart(lexemeIndex, i);
    }

    private int findSameLexemeGroupStart(int lexemeIndex, int prodIndex) {
        while (prodIndex > 0 && this.getLexemeIndexAt(prodIndex - 1) == lexemeIndex) {
            --prodIndex;
        }
        return prodIndex;
    }

    void addMarker(PsiBuilderImpl.ProductionMarker marker) {
        this.add(marker.markerId);
    }

    void rollbackTo(PsiBuilderImpl.ProductionMarker marker) {
        int idx = this.indexOf(marker);
        for (int i = this.size() - 1; i >= idx; --i) {
            int markerId = this._data[i];
            if (markerId <= 0) continue;
            this.myPool.freeMarker((PsiBuilderImpl.ProductionMarker)this.myPool.get(markerId));
        }
        this.remove(idx, this.size() - idx);
    }

    boolean hasErrorsAfter(@NotNull PsiBuilderImpl.StartMarker marker) {
        if (marker == null) {
            MarkerProduction.$$$reportNull$$$0(0);
        }
        for (int i = this.indexOf(marker) + 1; i < this.size(); ++i) {
            PsiBuilderImpl.ProductionMarker m = this.getStartMarkerAt(i);
            if (m == null || !this.hasError(m)) continue;
            return true;
        }
        return false;
    }

    private boolean hasError(PsiBuilderImpl.ProductionMarker marker) {
        return marker instanceof PsiBuilderImpl.ErrorItem || this.myOptionalData.getDoneError(marker.markerId) != null;
    }

    void dropMarker(@NotNull PsiBuilderImpl.StartMarker marker) {
        if (marker == null) {
            MarkerProduction.$$$reportNull$$$0(1);
        }
        if (marker.isDone()) {
            this.remove(this.lastIndexOf(-marker.markerId));
        }
        this.remove(this.indexOf(marker));
        this.myPool.freeMarker(marker);
    }

    void addDone(PsiBuilderImpl.StartMarker marker, @Nullable PsiBuilderImpl.ProductionMarker anchorBefore) {
        this.insert(anchorBefore == null ? this.size() : this.indexOf(anchorBefore), -marker.markerId);
    }

    @Nullable
    PsiBuilderImpl.ProductionMarker getMarkerAt(int index) {
        int id2 = this.get(index);
        return (PsiBuilderImpl.ProductionMarker)this.myPool.get(id2 > 0 ? id2 : -id2);
    }

    @Nullable
    PsiBuilderImpl.ProductionMarker getStartMarkerAt(int index) {
        int id2 = this.get(index);
        return id2 > 0 ? (PsiBuilderImpl.ProductionMarker)this.myPool.get(id2) : null;
    }

    @Nullable
    PsiBuilderImpl.StartMarker getDoneMarkerAt(int index) {
        int id2 = this.get(index);
        return id2 < 0 ? (PsiBuilderImpl.StartMarker)this.myPool.get(-id2) : null;
    }

    int getLexemeIndexAt(int productionIndex) {
        int id2 = this.get(productionIndex);
        return ((PsiBuilderImpl.ProductionMarker)this.myPool.get(Math.abs(id2))).getLexemeIndex(id2 < 0);
    }

    void confineMarkersToMaxLexeme(int markersBefore, int lexemeIndex) {
        for (int k = markersBefore - 1; k > 1; --k) {
            boolean done;
            int id2 = this._data[k];
            PsiBuilderImpl.ProductionMarker marker = (PsiBuilderImpl.ProductionMarker)this.myPool.get(Math.abs(id2));
            boolean bl = done = id2 < 0;
            if (marker.getLexemeIndex(done) < lexemeIndex) break;
            marker.setLexemeIndex(lexemeIndex, done);
        }
    }

    void doHeavyChecksOnMarkerDone(@NotNull PsiBuilderImpl.StartMarker doneMarker, @Nullable PsiBuilderImpl.StartMarker anchorBefore) {
        if (doneMarker == null) {
            MarkerProduction.$$$reportNull$$$0(2);
        }
        int idx = this.indexOf(doneMarker);
        int endIdx = this.size();
        if (anchorBefore != null && idx > (endIdx = this.indexOf(anchorBefore))) {
            LOG.error("'Before' marker precedes this one.");
        }
        for (int i = endIdx - 1; i > idx; --i) {
            Throwable debugAllocOther;
            PsiBuilderImpl.StartMarker otherMarker;
            PsiBuilderImpl.ProductionMarker item = this.getStartMarkerAt(i);
            if (!(item instanceof PsiBuilderImpl.StartMarker) || (otherMarker = (PsiBuilderImpl.StartMarker)item).isDone()) continue;
            Throwable debugAllocThis = this.myOptionalData.getAllocationTrace(doneMarker);
            Throwable currentTrace = new Throwable();
            if (debugAllocThis != null) {
                ExceptionUtil.makeStackTraceRelative(debugAllocThis, currentTrace).printStackTrace(System.err);
            }
            if ((debugAllocOther = this.myOptionalData.getAllocationTrace(otherMarker)) != null) {
                ExceptionUtil.makeStackTraceRelative(debugAllocOther, currentTrace).printStackTrace(System.err);
            }
            LOG.error("Another not done marker added after this one. Must be done before this.");
        }
    }

    void assertNoDoneMarkerAround(@NotNull PsiBuilderImpl.StartMarker pivot) {
        if (pivot == null) {
            MarkerProduction.$$$reportNull$$$0(3);
        }
        int pivotIndex = this.indexOf(pivot);
        for (int i = pivotIndex + 1; i < this.size(); ++i) {
            PsiBuilderImpl.StartMarker m = this.getDoneMarkerAt(i);
            if (m != null && m.myLexemeIndex <= pivot.myLexemeIndex && this.indexOf(m) < pivotIndex) {
                throw new AssertionError("There's a marker of type '" + m.getTokenType() + "' that starts before and finishes after the current marker. See cause for its allocation trace.", this.myOptionalData.getAllocationTrace(m));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doneMarker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pivot";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/impl/MarkerProduction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasErrorsAfter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "dropMarker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doHeavyChecksOnMarkerDone";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "assertNoDoneMarkerAround";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

