/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.net.URL;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGithubTagDownloadedProjectGenerator
extends WebProjectTemplate<GithubTagInfo> {
    private static final Logger LOG = Logger.getInstance(AbstractGithubTagDownloadedProjectGenerator.class);

    @Override
    @NotNull
    @Nls
    public final String getName() {
        String string = this.getDisplayName();
        if (string == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected abstract String getDisplayName();

    @NotNull
    public abstract String getGithubUserName();

    @NotNull
    public abstract String getGithubRepositoryName();

    @Override
    @Nullable
    public abstract String getDescription();

    private String getTitle() {
        return this.getDisplayName();
    }

    @Override
    @Nullable
    public String getHelpId() {
        return "create.from.template." + this.getGithubUserName() + "." + this.getGithubRepositoryName();
    }

    @Override
    public void generateProject(@NotNull Project project2, @NotNull VirtualFile baseDir, @NotNull GithubTagInfo tag2, @NotNull Module module2) {
        if (project2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(2);
        }
        if (tag2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(3);
        }
        if (module2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(4);
        }
        try {
            this.unpackToDir(project2, VfsUtilCore.virtualToIoFile(baseDir), tag2);
        }
        catch (GeneratorException e) {
            this.reportError(project2, e);
        }
        ApplicationManager.getApplication().runWriteAction(() -> baseDir.refresh(true, true));
    }

    @NotNull
    public GithubProjectGeneratorPeer createPeer() {
        return new GithubProjectGeneratorPeer(this);
    }

    @Override
    public boolean isPrimaryGenerator() {
        return PlatformUtils.isWebStorm();
    }

    private void unpackToDir(@Nullable Project project2, @NotNull File extractToDir, @NotNull GithubTagInfo tag2) throws GeneratorException {
        if (extractToDir == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(5);
        }
        if (tag2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(6);
        }
        File zipArchiveFile = this.getCacheFile(tag2);
        String primaryUrl = this.getPrimaryZipArchiveUrlForDownload(tag2);
        boolean downloaded = false;
        if (primaryUrl != null) {
            try {
                this.downloadAndUnzip(project2, primaryUrl, zipArchiveFile, extractToDir, false);
                downloaded = true;
            }
            catch (GeneratorException e) {
                LOG.info("Can't download " + primaryUrl, e);
                FileUtil.delete(zipArchiveFile);
            }
        }
        if (!downloaded) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new GeneratorException("Download " + tag2.getZipballUrl() + " is skipped in unit test mode");
            }
            this.downloadAndUnzip(project2, tag2.getZipballUrl(), zipArchiveFile, extractToDir, true);
        }
    }

    private void downloadAndUnzip(@Nullable Project project2, @NotNull String url, @NotNull File zipArchiveFile, @NotNull File extractToDir, boolean retryOnError) throws GeneratorException {
        if (url == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(7);
        }
        if (zipArchiveFile == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(8);
        }
        if (extractToDir == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                File file2 = URLUtil.urlToFile(new URL(url));
                ZipUtil.unzip(null, extractToDir, file2, null, null, true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        GithubDownloadUtil.downloadContentToFileWithProgressSynchronously(project2, url, this.getTitle(), zipArchiveFile, this.getGithubUserName(), this.getGithubRepositoryName(), retryOnError);
        LOG.info("Content of " + url + " has been successfully downloaded to " + zipArchiveFile.getAbsolutePath() + ", size " + zipArchiveFile.length() + " bytes");
        ZipUtil.unzipWithProgressSynchronously(project2, this.getTitle(), zipArchiveFile, extractToDir, this.getPathConvertor(), true);
    }

    @Nullable
    protected NullableFunction<String, String> getPathConvertor() {
        return null;
    }

    @Nullable
    public abstract String getPrimaryZipArchiveUrlForDownload(@NotNull GithubTagInfo var1);

    @NotNull
    private File getCacheFile(@NotNull GithubTagInfo tag2) {
        if (tag2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(10);
        }
        String fileName = URLUtil.encodeURIComponent(tag2.getName() + ".zip");
        File file2 = GithubDownloadUtil.findCacheFile(this.getGithubUserName(), this.getGithubRepositoryName(), fileName);
        if (file2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(11);
        }
        return file2;
    }

    private void reportError(@NotNull Project project2, @NotNull GeneratorException e) {
        if (project2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(12);
        }
        if (e == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(13);
        }
        String message = "Error creating " + this.getDisplayName() + " project";
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(message, e);
            return;
        }
        LOG.info(message, e);
        String title = "Create " + this.getDisplayName() + " Project";
        Messages.showErrorDialog(project2, message + ". " + e.getMessage(), title);
    }

    public ActionLink createGitHubLink() {
        ActionLink link = new ActionLink(this.getName() + " on GitHub", DumbAwareAction.create(e -> BrowserUtil.open("https://github.com/" + this.getGithubUserName() + "/" + this.getGithubRepositoryName())));
        link.setFont(UIUtil.getLabelFont(UIUtil.FontSize.SMALL));
        return link;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractToDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipArchiveFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unpackToDir";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "downloadAndUnzip";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCacheFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

