/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.util;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.util.JvmUtil;
import com.intellij.openapi.progress.ProgressManager;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class JvmHierarchyUtil {
    private JvmHierarchyUtil() {
    }

    public static boolean testSupers(@NotNull JvmClass start2, boolean skipStart, @NotNull Predicate<? super JvmClass> predicate) {
        Boolean result2;
        if (start2 == null) {
            JvmHierarchyUtil.$$$reportNull$$$0(0);
        }
        if (predicate == null) {
            JvmHierarchyUtil.$$$reportNull$$$0(1);
        }
        return (result2 = JvmHierarchyUtil.traverseSupers(start2, skipStart, it -> predicate.test((JvmClass)it) ? Boolean.TRUE : null)) != null && result2 != false;
    }

    public static <R> R traverseSupers(@NotNull JvmClass start2, @NotNull Function<? super JvmClass, R> f) {
        if (start2 == null) {
            JvmHierarchyUtil.$$$reportNull$$$0(2);
        }
        if (f == null) {
            JvmHierarchyUtil.$$$reportNull$$$0(3);
        }
        return JvmHierarchyUtil.traverseSupers(start2, false, f);
    }

    public static <R> R traverseSupers(@NotNull JvmClass start2, boolean skipStart, @NotNull Function<? super JvmClass, R> f) {
        if (start2 == null) {
            JvmHierarchyUtil.$$$reportNull$$$0(4);
        }
        if (f == null) {
            JvmHierarchyUtil.$$$reportNull$$$0(5);
        }
        ArrayDeque<JvmClass> queue = new ArrayDeque<JvmClass>();
        if (skipStart) {
            JvmHierarchyUtil.queueSupers(queue, start2);
        } else {
            queue.offer(start2);
        }
        THashSet<JvmClass> visited = new THashSet<JvmClass>();
        while (!queue.isEmpty()) {
            ProgressManager.checkCanceled();
            JvmClass current2 = (JvmClass)queue.remove();
            if (!visited.add(current2)) continue;
            R result2 = f.apply(current2);
            if (result2 != null) {
                return result2;
            }
            JvmHierarchyUtil.queueSupers(queue, current2);
        }
        return null;
    }

    private static void queueSupers(@NotNull Queue<? super JvmClass> queue, @NotNull JvmClass current2) {
        JvmClass superClass;
        if (queue == null) {
            JvmHierarchyUtil.$$$reportNull$$$0(6);
        }
        if (current2 == null) {
            JvmHierarchyUtil.$$$reportNull$$$0(7);
        }
        if ((superClass = JvmUtil.resolveClass(current2.getSuperClassType())) != null) {
            queue.offer(superClass);
        }
        for (JvmClass anInterface : JvmUtil.resolveClasses(current2.getInterfaceTypes())) {
            queue.offer(anInterface);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/jvm/util/JvmHierarchyUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "testSupers";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "traverseSupers";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "queueSupers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

