/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.parameterInfo;

import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUtilsBase;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoUtils {
    public static final String DEFAULT_PARAMETER_CLOSE_CHARS = ",){}";

    @Nullable
    public static <T extends PsiElement> T findParentOfType(PsiFile file2, int offset, Class<T> parentClass) {
        return ParameterInfoUtilsBase.findParentOfType(file2, offset, parentClass);
    }

    @SafeVarargs
    @Nullable
    public static <T extends PsiElement> T findParentOfTypeWithStopElements(PsiFile file2, int offset, Class<T> parentClass, Class<? extends PsiElement> ... stopAt) {
        if (stopAt == null) {
            ParameterInfoUtils.$$$reportNull$$$0(0);
        }
        return ParameterInfoUtilsBase.findParentOfTypeWithStopElements(file2, offset, parentClass, stopAt);
    }

    public static int getCurrentParameterIndex(ASTNode argList, int offset, IElementType delimiterType) {
        SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.astTraverser(argList).expandAndSkip(Conditions.is(argList));
        return ParameterInfoUtils.getCurrentParameterIndex(s, offset, delimiterType);
    }

    public static <V> int getCurrentParameterIndex(SyntaxTraverser<V> s, int offset, IElementType delimiterType) {
        Object root = s.getRoot();
        int curOffset = s.api.rangeOf(root).getStartOffset();
        if (offset < curOffset) {
            return -1;
        }
        int index = 0;
        for (Object child2 : s) {
            if (offset < (curOffset += s.api.rangeOf(child2).getLength())) break;
            IElementType type = s.api.typeOf(child2);
            if (type != delimiterType) continue;
            ++index;
        }
        return index;
    }

    @Nullable
    public static <E extends PsiElement> E findArgumentList(PsiFile file2, int offset, int lbraceOffset, @NotNull ParameterInfoHandlerWithTabActionSupport findArgumentListHelper) {
        if (findArgumentListHelper == null) {
            ParameterInfoUtils.$$$reportNull$$$0(1);
        }
        return ParameterInfoUtils.findArgumentList(file2, offset, lbraceOffset, findArgumentListHelper, true);
    }

    @Nullable
    public static <E extends PsiElement> E findArgumentList(PsiFile file2, int offset, int lbraceOffset, @NotNull ParameterInfoHandlerWithTabActionSupport findArgumentListHelper, boolean allowOuter) {
        PsiElement element2;
        int offset1;
        if (findArgumentListHelper == null) {
            ParameterInfoUtils.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            return null;
        }
        CharSequence chars = file2.getViewProvider().getContents();
        if (offset >= chars.length()) {
            offset = chars.length() - 1;
        }
        if ((offset1 = CharArrayUtil.shiftBackward(chars, offset, " \t\n\r")) < 0) {
            return null;
        }
        boolean acceptRparenth = true;
        boolean acceptLparenth = false;
        if (offset1 != offset) {
            offset = offset1;
            acceptRparenth = false;
            acceptLparenth = true;
        }
        if ((element2 = file2.findElementAt(offset)) == null) {
            return null;
        }
        PsiElement parent = element2.getParent();
        while (true) {
            TextRange range2;
            if (findArgumentListHelper.getArgumentListClass().isInstance(parent) && (range2 = parent.getTextRange()) != null) {
                if (!acceptRparenth && offset == range2.getEndOffset() - 1) {
                    PsiElement[] children2 = parent.getChildren();
                    if (children2.length == 0) {
                        return null;
                    }
                    PsiElement last = children2[children2.length - 1];
                    if (last.getNode().getElementType() == findArgumentListHelper.getActualParametersRBraceType()) {
                        parent = parent.getParent();
                        continue;
                    }
                }
                if (!acceptLparenth && offset == range2.getStartOffset()) {
                    parent = parent.getParent();
                    continue;
                }
                if (lbraceOffset < 0 || range2.getStartOffset() == lbraceOffset) break;
                if (!allowOuter) {
                    return null;
                }
                parent = parent.getParent();
                continue;
            }
            if (parent instanceof PsiFile || parent == null) {
                return null;
            }
            Set<Class<?>> set = findArgumentListHelper.getArgListStopSearchClasses();
            for (Class<?> aClass : set) {
                if (!aClass.isInstance(parent)) continue;
                return null;
            }
            parent = parent.getParent();
        }
        PsiElement listParent = parent.getParent();
        for (Class<?> c : findArgumentListHelper.getArgumentListAllowedParentClasses()) {
            if (!c.isInstance(listParent)) continue;
            return (E)parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findArgumentListHelper";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/parameterInfo/ParameterInfoUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findParentOfTypeWithStopElements";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findArgumentList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

