/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.encoding;

import com.intellij.ide.DataManager;
import com.intellij.largeFilesEditor.encoding.EncodingWidget;
import com.intellij.largeFilesEditor.encoding.LargeFileEditorAccess;
import com.intellij.largeFilesEditor.encoding.LargeFileEditorAccessor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeFileEncodingAction
extends com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction {
    private static final Logger logger = Logger.getInstance(ChangeFileEncodingAction.class);
    private final LargeFileEditorAccessor myLargeFileEditorAccessor;
    private final Project project;
    private final StatusBar statusBar;

    ChangeFileEncodingAction(LargeFileEditorAccessor largeFileEditorAccessor, Project project2, StatusBar statusBar) {
        this.myLargeFileEditorAccessor = largeFileEditorAccessor;
        this.project = project2;
        this.statusBar = statusBar;
    }

    private boolean chosen(@NotNull Charset charset) {
        LargeFileEditorAccess largeFileEditorAccess;
        if (charset == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(0);
        }
        if ((largeFileEditorAccess = this.myLargeFileEditorAccessor.getAccess(this.project, this.statusBar)) == null) {
            logger.warn("tried to change encoding while editor is not accessible");
            return false;
        }
        boolean result2 = largeFileEditorAccess.tryChangeEncoding(charset);
        this.updateWidget();
        return result2;
    }

    private void updateWidget() {
        StatusBarWidget widget = this.statusBar.getWidget("lfeEncoding");
        if (widget instanceof EncodingWidget) {
            ((EncodingWidget)widget).requestUpdate();
        } else {
            logger.warn("[LargeFileEditorSubsystem] ChangeFileEncodingAction.updateWidget(): " + (widget == null ? " variable 'widget' is null" : " variable is instance of " + widget.getClass().getName()));
        }
    }

    @Override
    protected boolean chosen(Document document, Editor editor, @Nullable VirtualFile virtualFile2, byte[] bytes, @NotNull Charset charset) {
        if (charset == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(1);
        }
        return this.chosen(charset);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    ListPopup createPopup(VirtualFile vFile, Editor editor, Component componentParent) {
        DataContext dataContext = ChangeFileEncodingAction.wrapInDataContext(vFile, editor, componentParent);
        DefaultActionGroup group = this.createActionGroup(vFile, editor, null, null, null);
        return JBPopupFactory.getInstance().createActionGroupPopup(this.getTemplatePresentation().getText(), group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    private static DataContext wrapInDataContext(VirtualFile vFile, Editor editor, Component componentParent) {
        DataContext parent = DataManager.getInstance().getDataContext(componentParent);
        return SimpleDataContext.getSimpleContext(ContainerUtil.immutableMapBuilder().put(CommonDataKeys.VIRTUAL_FILE.getName(), vFile).put(CommonDataKeys.VIRTUAL_FILE_ARRAY.getName(), (VirtualFile)new VirtualFile[]{vFile}).put(CommonDataKeys.PROJECT.getName(), (VirtualFile)((Object)editor.getProject())).put(PlatformDataKeys.CONTEXT_COMPONENT.getName(), (VirtualFile)((Object)editor.getComponent())).build(), parent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/largeFilesEditor/encoding/ChangeFileEncodingAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "chosen";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

