/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.file;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

class FileAdapter {
    private static final Logger logger = Logger.getInstance(FileAdapter.class);
    private static final int UNDEFINED = -1;
    private final VirtualFile vFile;
    private final RandomAccessFile randomAccessFile;
    private final ReentrantLock randomAccessFileLock;
    private final int pageSize;
    private final int maxPageBorderShift;
    private volatile long cashedFileSize;

    FileAdapter(int pageSize, int maxPageBorderShift, @NotNull VirtualFile vFile) throws FileNotFoundException {
        if (vFile == null) {
            FileAdapter.$$$reportNull$$$0(0);
        }
        this.randomAccessFileLock = new ReentrantLock();
        this.cashedFileSize = -1L;
        this.pageSize = pageSize;
        this.maxPageBorderShift = maxPageBorderShift;
        this.vFile = vFile;
        this.randomAccessFile = new RandomAccessFile(VfsUtilCore.virtualToIoFile(vFile), "r");
        try {
            this.cashedFileSize = this.randomAccessFile.length();
        }
        catch (IOException e) {
            logger.warn(e);
        }
    }

    void setCharset(Charset newCharset) {
        this.randomAccessFileLock.lock();
        try {
            this.vFile.setCharset(newCharset);
        }
        finally {
            this.randomAccessFileLock.unlock();
        }
    }

    void closeFile() throws IOException {
        this.randomAccessFileLock.lock();
        try {
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
            }
        }
        finally {
            this.randomAccessFileLock.unlock();
        }
    }

    String getCharsetName() {
        return this.vFile.getCharset().name();
    }

    long getPagesAmount() throws IOException {
        return (this.getFileSize() + (long)this.pageSize - 1L) / (long)this.pageSize;
    }

    long getFileSize() throws IOException {
        if (this.randomAccessFileLock.isHeldByCurrentThread()) {
            this.cashedFileSize = this.randomAccessFile.length();
        } else {
            if (this.randomAccessFileLock.tryLock()) {
                try {
                    this.cashedFileSize = this.randomAccessFile.length();
                }
                finally {
                    this.randomAccessFileLock.unlock();
                }
            }
            if (this.cashedFileSize == -1L) {
                this.randomAccessFileLock.lock();
                try {
                    this.cashedFileSize = this.randomAccessFile.length();
                }
                finally {
                    this.randomAccessFileLock.unlock();
                }
            }
        }
        return this.cashedFileSize;
    }

    int getPageSize() {
        return this.pageSize;
    }

    @NotNull
    VirtualFile getVirtualFile() {
        VirtualFile virtualFile2 = this.vFile;
        if (virtualFile2 == null) {
            FileAdapter.$$$reportNull$$$0(1);
        }
        return virtualFile2;
    }

    String getFileName() {
        return this.vFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getPageText(long pageNumber) throws IOException {
        this.randomAccessFileLock.lock();
        try {
            long pagesAmount = this.getPagesAmount();
            if (pageNumber < 0L || pageNumber >= pagesAmount) {
                String string = null;
                return string;
            }
            long minProbStartPos = pageNumber * (long)this.pageSize;
            long startByte = pageNumber == 0L ? 0L : minProbStartPos + (long)FileAdapter.findPageShiftFrom(minProbStartPos, this.randomAccessFile, this.vFile.getCharset(), this.maxPageBorderShift);
            if (startByte > this.randomAccessFile.length() - 1L) {
                String string = "";
                return string;
            }
            long endByte = (minProbStartPos += (long)this.pageSize) >= this.randomAccessFile.length() ? this.randomAccessFile.length() : minProbStartPos + (long)FileAdapter.findPageShiftFrom(minProbStartPos, this.randomAccessFile, this.vFile.getCharset(), this.maxPageBorderShift);
            this.randomAccessFile.seek(startByte);
            byte[] buffer = new byte[(int)(endByte - startByte)];
            this.randomAccessFile.readFully(buffer);
            String string = CharsetToolkit.decodeString(buffer, this.vFile.getCharset());
            return string;
        }
        finally {
            this.randomAccessFileLock.unlock();
        }
    }

    private static int findPageShiftFrom(long minProbStartPos, RandomAccessFile randomAccessFile, Charset charset, int maxPageBorderShift) throws IOException {
        int offsetToSymbolBeginning = FileAdapter.findNextSymbolBeginningOffsetFrom(minProbStartPos, randomAccessFile, charset);
        if (offsetToSymbolBeginning >= maxPageBorderShift) {
            return offsetToSymbolBeginning;
        }
        int bufferLength = minProbStartPos + (long)maxPageBorderShift >= randomAccessFile.length() ? (int)(randomAccessFile.length() - minProbStartPos - (long)offsetToSymbolBeginning) : maxPageBorderShift - offsetToSymbolBeginning;
        byte[] buffer1 = new byte[bufferLength];
        randomAccessFile.seek(minProbStartPos + (long)offsetToSymbolBeginning);
        randomAccessFile.readFully(buffer1);
        String text1 = CharsetToolkit.decodeString(buffer1, charset);
        int substringLength = -1;
        int indexOfSlashN = text1.indexOf(10);
        if (indexOfSlashN != -1) {
            substringLength = indexOfSlashN + 1;
        } else {
            int indexOfSlashR = text1.indexOf(13);
            if (indexOfSlashR != -1) {
                substringLength = indexOfSlashR + 1;
            }
        }
        if (substringLength != -1) {
            int substringLengthInBytes = charset.equals(CharsetToolkit.UTF_16_CHARSET) ? text1.substring(0, substringLength).getBytes(CharsetToolkit.UTF_16BE_CHARSET).length : text1.substring(0, substringLength).getBytes(charset).length;
            return offsetToSymbolBeginning + substringLengthInBytes;
        }
        return offsetToSymbolBeginning;
    }

    private static int findNextSymbolBeginningOffsetFrom(long numberOfStartByte, RandomAccessFile randomAccessFile, Charset charset) throws IOException {
        if (charset.compareTo(CharsetToolkit.UTF8_CHARSET) == 0) {
            return FileAdapter.findNextSymbolBeginningOffsetFrom_UTF8(numberOfStartByte, randomAccessFile);
        }
        if (charset.compareTo(CharsetToolkit.UTF_16_CHARSET) == 0 || charset.compareTo(CharsetToolkit.UTF_16BE_CHARSET) == 0 || charset.compareTo(CharsetToolkit.UTF_16LE_CHARSET) == 0) {
            return FileAdapter.findNextSymbolBeginningOffsetFrom_UTF16(numberOfStartByte, randomAccessFile, charset);
        }
        if (charset.compareTo(CharsetToolkit.UTF_32BE_CHARSET) == 0 || charset.compareTo(CharsetToolkit.UTF_32LE_CHARSET) == 0) {
            return FileAdapter.findNextSymbolBeginningOffsetFrom_UTF32(numberOfStartByte);
        }
        return 0;
    }

    private static int findNextSymbolBeginningOffsetFrom_UTF8(long numberOfStartByte, RandomAccessFile randomAccessFile) throws IOException {
        int maxSymbolLengthInUtf8 = 4;
        randomAccessFile.seek(numberOfStartByte);
        int offset = 0;
        for (int i = 0; i < 4; ++i) {
            byte _byte;
            try {
                _byte = randomAccessFile.readByte();
            }
            catch (EOFException e) {
                return offset;
            }
            if ((_byte & 0xC0) != 128) {
                return offset;
            }
            ++offset;
        }
        logger.warn("Can't decode file correctly in UTF-8. There are more than 3 bytes one after another, which match bit mask 10xxxxxx");
        return 0;
    }

    private static int findNextSymbolBeginningOffsetFrom_UTF32(long numberOfStartByte) {
        if (numberOfStartByte % 4L == 0L) {
            return 0;
        }
        return (int)(4L - numberOfStartByte % 4L);
    }

    private static int findNextSymbolBeginningOffsetFrom_UTF16(long numberOfStartByte, RandomAccessFile randomAccessFile, Charset charset) throws IOException {
        long offset = numberOfStartByte % 2L;
        if (charset.compareTo(CharsetToolkit.UTF_16_CHARSET) == 0 || charset.compareTo(CharsetToolkit.UTF_16BE_CHARSET) == 0) {
            randomAccessFile.seek(numberOfStartByte + offset);
        } else {
            randomAccessFile.seek(numberOfStartByte + offset + 1L);
        }
        int unsignedByte = randomAccessFile.readByte() & 0xFF;
        if (unsignedByte <= 216 || unsignedByte >= 224) {
            return (int)offset;
        }
        if (unsignedByte <= 219) {
            return (int)offset;
        }
        return (int)offset + 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/largeFilesEditor/file/FileAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/largeFilesEditor/file/FileAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

