/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ImmutableUserMap;
import com.intellij.util.containers.Queue;
import org.jetbrains.annotations.NotNull;

public abstract class LookAheadLexer
extends LexerBase {
    private int myLastOffset;
    private int myLastState;
    private final Lexer myBaseLexer;
    private int myTokenStart;
    private final Queue<IElementType> myTypeCache;
    private final Queue<Integer> myEndOffsetCache;

    public LookAheadLexer(@NotNull Lexer baseLexer, int capacity) {
        if (baseLexer == null) {
            LookAheadLexer.$$$reportNull$$$0(0);
        }
        this.myBaseLexer = baseLexer;
        this.myTypeCache = new Queue(capacity);
        this.myEndOffsetCache = new Queue(capacity);
    }

    public LookAheadLexer(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            LookAheadLexer.$$$reportNull$$$0(1);
        }
        this(baseLexer, 64);
    }

    protected void addToken(IElementType type) {
        this.addToken(this.myBaseLexer.getTokenEnd(), type);
    }

    protected void addToken(int endOffset, IElementType type) {
        this.myTypeCache.addLast(type);
        this.myEndOffsetCache.addLast(endOffset);
    }

    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            LookAheadLexer.$$$reportNull$$$0(2);
        }
        this.advanceLexer(baseLexer);
    }

    @Override
    public void advance() {
        if (!this.myTypeCache.isEmpty()) {
            this.myTypeCache.pullFirst();
            this.myTokenStart = this.myEndOffsetCache.pullFirst();
        }
        if (this.myTypeCache.isEmpty()) {
            this.doLookAhead();
        }
    }

    private void doLookAhead() {
        this.myLastOffset = this.myTokenStart;
        this.myLastState = this.myBaseLexer.getState();
        this.lookAhead(this.myBaseLexer);
        assert (!this.myTypeCache.isEmpty());
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBaseLexer.getBufferSequence();
        if (charSequence == null) {
            LookAheadLexer.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @Override
    public int getBufferEnd() {
        return this.myBaseLexer.getBufferEnd();
    }

    protected int getCacheSize() {
        return this.myTypeCache.size();
    }

    protected void resetCacheSize(int size) {
        while (this.myTypeCache.size() > size) {
            this.myTypeCache.removeLast();
            this.myEndOffsetCache.removeLast();
        }
    }

    public IElementType replaceCachedType(int index, IElementType token) {
        return this.myTypeCache.set(index, token);
    }

    protected final IElementType getCachedType(int index) {
        return this.myTypeCache.get(index);
    }

    protected final int getCachedOffset(int index) {
        return this.myEndOffsetCache.get(index);
    }

    @Override
    public int getState() {
        int offset = this.myTokenStart - this.myLastOffset;
        return this.myLastState | offset << 16;
    }

    @Override
    public int getTokenEnd() {
        return this.myEndOffsetCache.peekFirst();
    }

    @Override
    public int getTokenStart() {
        return this.myTokenStart;
    }

    @Override
    @NotNull
    public LookAheadLexerPosition getCurrentPosition() {
        return new LookAheadLexerPosition(this, ImmutableUserMap.EMPTY);
    }

    @Override
    public final void restore(@NotNull LexerPosition _position) {
        if (_position == null) {
            LookAheadLexer.$$$reportNull$$$0(4);
        }
        this.restore((LookAheadLexerPosition)_position);
    }

    protected void restore(LookAheadLexerPosition position) {
        this.start(this.myBaseLexer.getBufferSequence(), position.lastOffset, this.myBaseLexer.getBufferEnd(), position.lastState);
        for (int i = 0; i < position.advanceCount; ++i) {
            this.advance();
        }
    }

    @Override
    public IElementType getTokenType() {
        return this.myTypeCache.peekFirst();
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            LookAheadLexer.$$$reportNull$$$0(5);
        }
        this.myBaseLexer.start(buffer, startOffset, endOffset, initialState & 0xFFFF);
        this.myTokenStart = startOffset;
        this.myTypeCache.clear();
        this.myEndOffsetCache.clear();
        this.doLookAhead();
    }

    protected final void advanceLexer(Lexer lexer) {
        this.advanceAs(lexer, lexer.getTokenType());
    }

    protected final void advanceAs(Lexer lexer, IElementType type) {
        this.addToken(type);
        lexer.advance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lexer/LookAheadLexer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lexer/LookAheadLexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lookAhead";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class LookAheadLexerPosition
    implements LexerPosition {
        final int lastOffset;
        final int lastState;
        final int tokenStart;
        final int advanceCount;
        final ImmutableUserMap customMap;

        public LookAheadLexerPosition(LookAheadLexer lookAheadLexer, ImmutableUserMap map2) {
            this.customMap = map2;
            this.lastOffset = lookAheadLexer.myLastOffset;
            this.lastState = lookAheadLexer.myLastState;
            this.tokenStart = lookAheadLexer.myTokenStart;
            this.advanceCount = lookAheadLexer.myTypeCache.size() - 1;
        }

        public ImmutableUserMap getCustomMap() {
            return this.customMap;
        }

        @Override
        public int getOffset() {
            return this.tokenStart;
        }

        @Override
        public int getState() {
            return this.lastState;
        }
    }
}

