/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class PrefixSuffixStripperLexer
extends LexerBase {
    private CharSequence myBuffer;
    private char[] myBufferArray;
    private int myTokenStart;
    private int myTokenEnd;
    private IElementType myTokenType;
    private int myState;
    private int myBufferEnd;
    private final String myPrefix;
    private final IElementType myPrefixType;
    private final String mySuffix;
    private final IElementType myMiddleTokenType;
    private final IElementType mySuffixType;

    public PrefixSuffixStripperLexer(String prefix, IElementType prefixType, String suffix, IElementType suffixType, IElementType middleTokenType) {
        this.mySuffixType = suffixType;
        this.myMiddleTokenType = middleTokenType;
        this.mySuffix = suffix;
        this.myPrefixType = prefixType;
        this.myPrefix = prefix;
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            PrefixSuffixStripperLexer.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myBufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        this.myTokenStart = startOffset;
        this.myTokenEnd = startOffset;
        this.myTokenType = null;
        this.myState = initialState;
        this.myBufferEnd = endOffset;
    }

    @Override
    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    @Override
    public int getTokenStart() {
        this.locateToken();
        return this.myTokenStart;
    }

    @Override
    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEnd;
    }

    @Override
    public int getState() {
        return this.myState;
    }

    @Override
    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            PrefixSuffixStripperLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    @Override
    public void advance() {
        this.myTokenType = null;
    }

    private void locateToken() {
        if (this.myTokenType != null || this.myState == 3) {
            return;
        }
        if (this.myState == 0) {
            this.myTokenEnd = this.myTokenStart + this.myPrefix.length();
            this.myTokenType = this.myPrefixType;
            this.myState = this.myTokenEnd < this.myBufferEnd ? 1 : 3;
            return;
        }
        if (this.myState == 1) {
            this.myTokenStart = this.myTokenEnd;
            int suffixStart = this.myBufferEnd - this.mySuffix.length();
            this.myTokenType = this.myMiddleTokenType;
            if (this.myBufferArray != null && CharArrayUtil.regionMatches(this.myBufferArray, suffixStart, this.myBufferEnd, (CharSequence)this.mySuffix) || this.myBufferArray == null && CharArrayUtil.regionMatches(this.myBuffer, suffixStart, this.myBufferEnd, (CharSequence)this.mySuffix)) {
                this.myTokenEnd = suffixStart;
                if (this.myTokenStart < this.myTokenEnd) {
                    this.myState = 2;
                } else {
                    this.myState = 3;
                    this.myTokenType = this.mySuffixType;
                    this.myTokenEnd = this.myBufferEnd;
                }
            } else {
                this.myTokenEnd = this.myBufferEnd;
                this.myState = 3;
            }
            return;
        }
        if (this.myState == 2) {
            this.myTokenStart = this.myTokenEnd;
            this.myTokenEnd = this.myBufferEnd;
            this.myTokenType = this.mySuffixType;
            this.myState = 3;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lexer/PrefixSuffixStripperLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lexer/PrefixSuffixStripperLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

