/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockVirtualFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.SmartList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockVirtualFile
extends VirtualFile {
    private static final MockVirtualFileSystem ourFileSystem = new MockVirtualFileSystem();
    private VirtualFile myParent;
    private final String myName;
    private final boolean myDirectory;
    private final List<VirtualFile> myChildren = new SmartList<VirtualFile>();
    private String myText;
    private boolean myIsWritable = true;
    private long myModStamp = LocalTimeCounter.currentTime();
    private final long myTimeStamp = System.currentTimeMillis();
    private VirtualFileListener myListener;

    public static MockVirtualFile dir(@NotNull String name, MockVirtualFile ... children2) {
        if (name == null) {
            MockVirtualFile.$$$reportNull$$$0(0);
        }
        MockVirtualFile dir = new MockVirtualFile(true, name);
        for (MockVirtualFile child2 : children2) {
            dir.addChild(child2);
        }
        return dir;
    }

    public static MockVirtualFile file(@NotNull String name) {
        if (name == null) {
            MockVirtualFile.$$$reportNull$$$0(1);
        }
        return new MockVirtualFile(name);
    }

    public MockVirtualFile(String name) {
        this(false, name);
    }

    public MockVirtualFile(boolean directory, String name) {
        this.myDirectory = directory;
        this.myName = name;
    }

    public MockVirtualFile(String name, String text2) {
        this.myName = name;
        this.myText = text2;
        this.myDirectory = false;
    }

    public void setText(String text2) {
        this.myText = text2;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            MockVirtualFile.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setParent(VirtualFile parent) {
        this.myParent = parent;
    }

    @Override
    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) {
        if (name == null) {
            MockVirtualFile.$$$reportNull$$$0(3);
        }
        MockVirtualFile file2 = new MockVirtualFile(name);
        this.addChild(file2);
        MockVirtualFile mockVirtualFile = file2;
        if (mockVirtualFile == null) {
            MockVirtualFile.$$$reportNull$$$0(4);
        }
        return mockVirtualFile;
    }

    public void addChild(@NotNull MockVirtualFile child2) {
        if (child2 == null) {
            MockVirtualFile.$$$reportNull$$$0(5);
        }
        child2.setParent(this);
        this.myChildren.add(child2);
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        MockVirtualFileSystem mockVirtualFileSystem = ourFileSystem;
        if (mockVirtualFileSystem == null) {
            MockVirtualFile.$$$reportNull$$$0(6);
        }
        return mockVirtualFileSystem;
    }

    @Override
    @NotNull
    public String getPath() {
        String prefix = this.myParent == null ? "MOCK_ROOT:" : this.myParent.getPath();
        String string = prefix + "/" + this.myName;
        if (string == null) {
            MockVirtualFile.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return this.myIsWritable;
    }

    @Override
    public void setWritable(boolean writable) {
        this.myIsWritable = writable;
    }

    @Override
    public boolean isDirectory() {
        return this.myDirectory;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    @Override
    public VirtualFile[] getChildren() {
        return VfsUtilCore.toVirtualFileArray(this.myChildren);
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() {
                MockVirtualFile.this.myModStamp = newModificationStamp;
                MockVirtualFile.this.myText = this.toString();
            }
        };
    }

    @Override
    public long getModificationStamp() {
        return this.myModStamp;
    }

    public void setModificationStamp(long modStamp) {
        this.myModStamp = modStamp;
    }

    @Override
    public byte @NotNull [] contentsToByteArray() {
        byte[] byArray = this.myText == null ? ArrayUtilRt.EMPTY_BYTE_ARRAY : this.myText.getBytes(StandardCharsets.UTF_8);
        if (byArray == null) {
            MockVirtualFile.$$$reportNull$$$0(8);
        }
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.myTimeStamp;
    }

    @Override
    public long getLength() {
        return this.myText == null ? 0L : (long)this.myText.length();
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    public InputStream getInputStream() {
        throw new UnsupportedOperationException("Method getInputStream is not yet implemented in " + this.getClass().getName());
    }

    public void setListener(VirtualFileListener listener2) {
        this.myListener = listener2;
    }

    public void setContent(@Nullable Object requestor, String content2, boolean fireEvent) {
        long oldStamp = this.myModStamp;
        this.myText = content2;
        if (fireEvent) {
            this.myModStamp = LocalTimeCounter.currentTime();
            this.myListener.contentsChanged(new VirtualFileEvent(requestor, this, null, oldStamp, this.myModStamp));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockVirtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dir";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

