/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiElement2Declaration
implements PsiSymbolDeclaration {
    private final PsiElement myTargetElement;
    private final PsiElement myDeclaringElement;
    private final TextRange myDeclarationRange;

    PsiElement2Declaration(@NotNull PsiElement targetElement, @NotNull PsiElement declaringElement, @NotNull TextRange range2) {
        if (targetElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(0);
        }
        if (declaringElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(1);
        }
        if (range2 == null) {
            PsiElement2Declaration.$$$reportNull$$$0(2);
        }
        this.myTargetElement = targetElement;
        this.myDeclaringElement = declaringElement;
        this.myDeclarationRange = range2;
    }

    @Override
    @NotNull
    public Symbol getSymbol() {
        Symbol symbol = PsiSymbolService.getInstance().asSymbol(this.myTargetElement);
        if (symbol == null) {
            PsiElement2Declaration.$$$reportNull$$$0(3);
        }
        return symbol;
    }

    @Override
    @NotNull
    public PsiElement getDeclaringElement() {
        PsiElement psiElement = this.myDeclaringElement;
        if (psiElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public TextRange getDeclarationRange() {
        TextRange textRange = this.myDeclarationRange;
        if (textRange == null) {
            PsiElement2Declaration.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @Nullable
    static PsiSymbolDeclaration createFromTargetPsiElement(@NotNull PsiElement targetElement) {
        PsiElement identifyingElement;
        if (targetElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(6);
        }
        if ((identifyingElement = PsiElement2Declaration.getIdentifyingElement(targetElement)) != null) {
            return new PsiElement2Declaration(targetElement, identifyingElement, PsiElement2Declaration.rangeOf(identifyingElement));
        }
        return null;
    }

    @NotNull
    static PsiSymbolDeclaration createFromDeclaredPsiElement(@NotNull PsiElement declaredElement, @NotNull PsiElement declaringElement) {
        if (declaredElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(7);
        }
        if (declaringElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(8);
        }
        TextRange declarationRange = PsiElement2Declaration.getDeclarationRangeFromPsi(declaredElement, declaringElement);
        return new PsiElement2Declaration(declaredElement, declaringElement, declarationRange);
    }

    @NotNull
    private static TextRange getDeclarationRangeFromPsi(@NotNull PsiElement declaredElement, @NotNull PsiElement declaringElement) {
        PsiElement identifyingElement;
        if (declaredElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(9);
        }
        if (declaringElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(10);
        }
        if ((identifyingElement = PsiElement2Declaration.getIdentifyingElement(declaredElement)) == null) {
            return PsiElement2Declaration.rangeOf(declaringElement);
        }
        TextRange identifyingRange = PsiElement2Declaration.relateRange(identifyingElement, PsiElement2Declaration.rangeOf(identifyingElement), declaringElement);
        if (identifyingRange == null) {
            return PsiElement2Declaration.rangeOf(declaringElement);
        }
        TextRange textRange = identifyingRange;
        if (textRange == null) {
            PsiElement2Declaration.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    @Nullable
    static PsiSymbolDeclaration createFromPom(@NotNull PomTarget target2, @NotNull PsiElement declaringElement) {
        TextRange declarationRange;
        if (target2 == null) {
            PsiElement2Declaration.$$$reportNull$$$0(12);
        }
        if (declaringElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(13);
        }
        if ((declarationRange = PsiElement2Declaration.getDeclarationRangeFromPom(target2, declaringElement)) == null) {
            return null;
        }
        return new PsiElement2Declaration(PomService.convertToPsi(declaringElement.getProject(), target2), declaringElement, declarationRange);
    }

    @Nullable
    private static TextRange getDeclarationRangeFromPom(@NotNull PomTarget target2, @NotNull PsiElement declaringElement) {
        PsiDeclaredTarget declaredTarget;
        TextRange nameIdentifierRange;
        if (target2 == null) {
            PsiElement2Declaration.$$$reportNull$$$0(14);
        }
        if (declaringElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(15);
        }
        if (target2 instanceof PsiDeclaredTarget && (nameIdentifierRange = (declaredTarget = (PsiDeclaredTarget)target2).getNameIdentifierRange()) != null) {
            PsiElement navigationElement = declaredTarget.getNavigationElement();
            return PsiElement2Declaration.relateRange(navigationElement, nameIdentifierRange, declaringElement);
        }
        return PsiElement2Declaration.rangeOf(declaringElement);
    }

    @Nullable
    private static PsiElement getIdentifyingElement(@NotNull PsiElement targetElement) {
        if (targetElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(16);
        }
        if (targetElement instanceof PsiNameIdentifierOwner) {
            return PsiElement2Declaration.getIdentifyingElement((PsiNameIdentifierOwner)targetElement);
        }
        return null;
    }

    @Nullable
    private static PsiElement getIdentifyingElement(@NotNull PsiNameIdentifierOwner nameIdentifierOwner) {
        PsiElement identifyingElement;
        if (nameIdentifierOwner == null) {
            PsiElement2Declaration.$$$reportNull$$$0(17);
        }
        if ((identifyingElement = nameIdentifierOwner.getNameIdentifier()) == null) {
            return null;
        }
        TextRange identifyingElementRange = identifyingElement.getTextRange();
        if (identifyingElementRange == null) {
            return null;
        }
        return identifyingElement;
    }

    @Nullable
    private static TextRange relateRange(@NotNull PsiElement identifyingElement, @NotNull TextRange rangeInIdentifyingElement, @NotNull PsiElement declaringElement) {
        if (identifyingElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(18);
        }
        if (rangeInIdentifyingElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(19);
        }
        if (declaringElement == null) {
            PsiElement2Declaration.$$$reportNull$$$0(20);
        }
        if (identifyingElement == declaringElement) {
            return rangeInIdentifyingElement;
        }
        if (identifyingElement.getContainingFile() == declaringElement.getContainingFile()) {
            TextRange rangeInFile = rangeInIdentifyingElement.shiftRight(identifyingElement.getTextRange().getStartOffset());
            TextRange declaringElementRange = declaringElement.getTextRange();
            if (declaringElementRange.contains(rangeInFile)) {
                return rangeInFile.shiftLeft(declaringElementRange.getStartOffset());
            }
            return null;
        }
        return null;
    }

    @NotNull
    private static TextRange rangeOf(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiElement2Declaration.$$$reportNull$$$0(21);
        }
        TextRange textRange = TextRange.from(0, element2.getTextLength());
        if (textRange == null) {
            PsiElement2Declaration.$$$reportNull$$$0(22);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/model/psi/impl/PsiElement2Declaration";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredElement";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifierOwner";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifyingElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInIdentifyingElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/model/psi/impl/PsiElement2Declaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaringElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationRange";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationRangeFromPsi";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "rangeOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 22: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFromTargetPsiElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFromDeclaredPsiElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationRangeFromPsi";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFromPom";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationRangeFromPom";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifyingElement";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "relateRange";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "rangeOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

