/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class DelegatingItemPresentation
implements ColoredItemPresentation {
    private final ItemPresentation myBase;
    private String myPresentableText;
    private String myLocationString;
    private Icon myIcon;
    private boolean myCustomLocationString;

    public DelegatingItemPresentation(ItemPresentation base) {
        this.myBase = base;
    }

    public DelegatingItemPresentation withPresentableText(String presentableText) {
        this.myPresentableText = presentableText;
        return this;
    }

    public DelegatingItemPresentation withLocationString(@Nullable String locationString) {
        this.myCustomLocationString = true;
        this.myLocationString = locationString;
        return this;
    }

    public DelegatingItemPresentation withIcon(Icon icon2) {
        this.myIcon = icon2;
        return this;
    }

    @Override
    public String getPresentableText() {
        if (this.myPresentableText != null) {
            return this.myPresentableText;
        }
        return this.myBase.getPresentableText();
    }

    @Override
    public String getLocationString() {
        if (this.myCustomLocationString) {
            return this.myLocationString;
        }
        return this.myBase.getLocationString();
    }

    @Override
    public Icon getIcon(boolean open2) {
        if (this.myIcon != null) {
            return this.myIcon;
        }
        return this.myBase.getIcon(open2);
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        return this.myBase instanceof ColoredItemPresentation ? ((ColoredItemPresentation)this.myBase).getTextAttributesKey() : null;
    }
}

