/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class NavigationItemFileStatus {
    private NavigationItemFileStatus() {
    }

    public static FileStatus get(NavigationItem item) {
        PsiElement target2;
        if (item instanceof PsiElement) {
            return NavigationItemFileStatus.getPsiElementFileStatus((PsiElement)((Object)item));
        }
        if (item instanceof AbstractTreeNode) {
            return ((AbstractTreeNode)item).getFileStatus();
        }
        if (item instanceof PsiElementNavigationItem && (target2 = ((PsiElementNavigationItem)item).getTargetElement()) != null) {
            return NavigationItemFileStatus.getPsiElementFileStatus(target2);
        }
        return FileStatus.NOT_CHANGED;
    }

    private static FileStatus getPsiElementFileStatus(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            NavigationItemFileStatus.$$$reportNull$$$0(0);
        }
        if (!psiElement.isPhysical()) {
            return FileStatus.NOT_CHANGED;
        }
        PsiFile contFile = psiElement.getContainingFile();
        if (contFile == null) {
            return FileStatus.NOT_CHANGED;
        }
        VirtualFile vFile = contFile.getVirtualFile();
        return vFile == null ? FileStatus.NOT_CHANGED : FileStatusManager.getInstance(psiElement.getProject()).getStatus(vFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/navigation/NavigationItemFileStatus", "getPsiElementFileStatus"));
    }
}

