/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J@\u0010\u0010\u001a\u00020\u00112\b\b\u0003\u0010\u0016\u001a\u00020\u00132\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/notification/SingletonNotificationManager;", "", "group", "Lcom/intellij/notification/NotificationGroup;", "type", "Lcom/intellij/notification/NotificationType;", "defaultListener", "Lcom/intellij/notification/NotificationListener;", "(Lcom/intellij/notification/NotificationGroup;Lcom/intellij/notification/NotificationType;Lcom/intellij/notification/NotificationListener;)V", "expiredListener", "Ljava/lang/Runnable;", "notification", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/notification/Notification;", "clear", "", "notify", "", "content", "", "project", "Lcom/intellij/openapi/project/Project;", "title", "listener", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.platform.ide.impl"})
public final class SingletonNotificationManager {
    private final AtomicReference<Notification> notification;
    private final Runnable expiredListener;
    private final NotificationGroup group;
    private final NotificationType type;
    private final NotificationListener defaultListener;

    public final boolean notify(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String content2, @Nullable Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        return SingletonNotificationManager.notify$default(this, "", content2, project2, null, null, 24, null);
    }

    @JvmOverloads
    public final boolean notify(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String title, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String content2, @Nullable Project project2, @Nullable NotificationListener listener2, @Nullable AnAction action2) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        Notification oldNotification = this.notification.get();
        if (oldNotification != null) {
            String toolWindowId = this.group.getToolWindowId();
            if (!oldNotification.isExpired() && toolWindowId != null && (oldNotification.getBalloon() != null || project2 != null && this.group.getDisplayType() == NotificationDisplayType.TOOL_WINDOW && ToolWindowManager.Companion.getInstance(project2).getToolWindowBalloon(toolWindowId) != null)) {
                return false;
            }
            oldNotification.whenExpired(null);
            oldNotification.expire();
        }
        Notification newNotification = this.group.createNotification(title, content2, this.type, listener2);
        if (action2 != null) {
            newNotification.addAction(action2);
        }
        newNotification.whenExpired(this.expiredListener);
        this.notification.set(newNotification);
        newNotification.notify(project2);
        return true;
    }

    public static /* synthetic */ boolean notify$default(SingletonNotificationManager singletonNotificationManager, String string, String string2, Project project2, NotificationListener notificationListener, AnAction anAction, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            project2 = null;
        }
        if ((n & 8) != 0) {
            notificationListener = singletonNotificationManager.defaultListener;
        }
        if ((n & 0x10) != 0) {
            anAction = null;
        }
        return singletonNotificationManager.notify(string, string2, project2, notificationListener, anAction);
    }

    @JvmOverloads
    public final boolean notify(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String title, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String content2, @Nullable Project project2, @Nullable NotificationListener listener2) {
        return SingletonNotificationManager.notify$default(this, title, content2, project2, listener2, null, 16, null);
    }

    @JvmOverloads
    public final boolean notify(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String title, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String content2, @Nullable Project project2) {
        return SingletonNotificationManager.notify$default(this, title, content2, project2, null, null, 24, null);
    }

    @JvmOverloads
    public final boolean notify(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String title, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String content2) {
        return SingletonNotificationManager.notify$default(this, title, content2, null, null, null, 28, null);
    }

    @JvmOverloads
    public final boolean notify(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String content2) {
        return SingletonNotificationManager.notify$default(this, null, content2, null, null, null, 29, null);
    }

    public final void clear() {
        block0: {
            Notification notification = this.notification.getAndSet(null);
            if (notification == null) break block0;
            Notification notification2 = notification;
            boolean bl = false;
            boolean bl2 = false;
            Notification it = notification2;
            boolean bl3 = false;
            it.whenExpired(null);
            it.expire();
        }
    }

    public SingletonNotificationManager(@NotNull NotificationGroup group, @NotNull NotificationType type, @Nullable NotificationListener defaultListener) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        this.group = group;
        this.type = type;
        this.defaultListener = defaultListener;
        this.notification = new AtomicReference();
        this.expiredListener = new Runnable(this){
            final /* synthetic */ SingletonNotificationManager this$0;

            public final void run() {
                Notification currentNotification = (Notification)SingletonNotificationManager.access$getNotification$p(this.this$0).get();
                if (currentNotification != null && currentNotification.isExpired()) {
                    SingletonNotificationManager.access$getNotification$p(this.this$0).compareAndSet(currentNotification, null);
                }
            }
            {
                this.this$0 = singletonNotificationManager;
            }
        };
    }

    public /* synthetic */ SingletonNotificationManager(NotificationGroup notificationGroup, NotificationType notificationType, NotificationListener notificationListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            notificationListener = null;
        }
        this(notificationGroup, notificationType, notificationListener);
    }

    public static final /* synthetic */ AtomicReference access$getNotification$p(SingletonNotificationManager $this) {
        return $this.notification;
    }
}

