/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.MessageBus;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationTestAction
extends AnAction
implements DumbAware {
    public static final String TEST_GROUP_ID = "Test Notification";
    private static final String MESSAGE_KEY = "NotificationTestAction_Message";

    @Override
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            NotificationTestAction.$$$reportNull$$$0(0);
        }
        new NotificationDialog(event.getProject()).show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/impl/actions/NotificationTestAction", "actionPerformed"));
    }

    private static class NotificationInfo
    implements NotificationListener {
        private String myIcon;
        private String myTitle;
        private String mySubtitle;
        private List<String> myContent;
        private List<String> myActions;
        private NotificationType myType = NotificationType.INFORMATION;
        private boolean mySticky;
        private boolean myAddListener;
        private boolean myToolwindow;
        private boolean myRightActionsDirection = true;
        private Notification myNotification;

        private NotificationInfo() {
        }

        public Notification getNotification() {
            if (this.myNotification == null) {
                String displayId;
                Icon icon2 = StringUtil.isEmpty(this.myIcon) ? null : IconLoader.findIcon(this.myIcon);
                String string = displayId = this.mySticky ? Holder.TEST_STICKY_GROUP.getDisplayId() : NotificationTestAction.TEST_GROUP_ID;
                if (this.myToolwindow) {
                    displayId = Holder.TEST_TOOLWINDOW_GROUP.getDisplayId();
                }
                String content2 = this.myContent == null ? "" : StringUtil.join(this.myContent, "\n");
                this.myNotification = icon2 == null ? new Notification(displayId, StringUtil.notNullize(this.myTitle), content2, this.myType, this.getListener()) : new Notification(displayId, icon2, this.myTitle, this.mySubtitle, content2, this.myType, this.getListener());
                if (this.myActions != null && !this.myToolwindow) {
                    for (String action2 : this.myActions) {
                        this.myNotification.addAction(new MyAnAction(action2));
                    }
                }
            }
            this.myNotification.setCollapseActionsDirection(this.myRightActionsDirection ? Notification.CollapseActionsDirection.KEEP_RIGHTMOST : Notification.CollapseActionsDirection.KEEP_LEFTMOST);
            return this.myNotification;
        }

        @Nullable
        private NotificationListener getListener() {
            return this.myAddListener ? this : null;
        }

        public void setIcon(@Nullable String icon2) {
            this.myIcon = icon2;
        }

        public void setTitle(@Nullable String title) {
            this.myTitle = title;
        }

        public void setSubtitle(@Nullable String subtitle) {
            this.mySubtitle = subtitle;
        }

        public void setAddListener(boolean addListener2) {
            this.myAddListener = addListener2;
        }

        public void addContent(@NotNull String content2) {
            if (content2 == null) {
                NotificationInfo.$$$reportNull$$$0(0);
            }
            if (this.myContent == null) {
                this.myContent = new ArrayList<String>();
            }
            this.myContent.add(content2);
        }

        public void setActions(@NotNull List<String> actions) {
            if (actions == null) {
                NotificationInfo.$$$reportNull$$$0(1);
            }
            this.myActions = actions;
        }

        public void setSticky(boolean sticky) {
            this.mySticky = sticky;
        }

        public void setToolwindow(boolean toolwindow) {
            this.myToolwindow = toolwindow;
        }

        public void setType(@Nullable String type) {
            if ("info".equals(type)) {
                this.myType = NotificationType.INFORMATION;
            } else if ("error".equals(type)) {
                this.myType = NotificationType.ERROR;
            } else if ("warn".equals(type)) {
                this.myType = NotificationType.WARNING;
            }
        }

        @Override
        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                NotificationInfo.$$$reportNull$$$0(2);
            }
            if (event == null) {
                NotificationInfo.$$$reportNull$$$0(3);
            }
            if (this.myNotification != null && MessageDialogBuilder.yesNo("Notification Listener", event.getDescription() + "      Expire?").isYes()) {
                this.myNotification.expire();
                this.myNotification = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/notification/impl/actions/NotificationTestAction$NotificationInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addContent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setActions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyAnAction
        extends AnAction {
            private MyAnAction(String text2) {
                if (text2 != null) {
                    Icon icon2;
                    if (text2.endsWith(".png") && (icon2 = IconLoader.findIcon(text2)) != null) {
                        this.getTemplatePresentation().setIcon(icon2);
                        return;
                    }
                    this.getTemplatePresentation().setText(text2);
                }
            }

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyAnAction.$$$reportNull$$$0(0);
                }
                if (NotificationInfo.this.myNotification == null) {
                    return;
                }
                Notification.get(e);
                if (MessageDialogBuilder.yesNo("AnAction", this.getTemplatePresentation().getText() + "      Expire?").isYes()) {
                    NotificationInfo.this.myNotification.expire();
                    NotificationInfo.this.myNotification = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/notification/impl/actions/NotificationTestAction$NotificationInfo$MyAnAction", "actionPerformed"));
            }
        }
    }

    private static final class NotificationDialog
    extends DialogWrapper {
        private final JTextArea myMessage = new JTextArea(10, 50);
        private final MessageBus myMessageBus;

        private NotificationDialog(@Nullable Project project2) {
            super(project2, true, DialogWrapper.IdeModalityType.MODELESS);
            this.myMessageBus = project2 != null ? project2.getMessageBus() : ApplicationManager.getApplication().getMessageBus();
            this.init();
            this.setOKButtonText("Notify");
            this.setTitle(NotificationTestAction.TEST_GROUP_ID);
            this.myMessage.setText(PropertiesComponent.getInstance().getValue(NotificationTestAction.MESSAGE_KEY));
        }

        @Override
        protected String getDimensionServiceKey() {
            return "NotificationTestAction";
        }

        @Override
        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel(new BorderLayout(10, 10));
            panel2.add("Center", new JScrollPane(this.myMessage));
            return panel2;
        }

        @Override
        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                NotificationDialog.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        @Override
        protected Action @NotNull [] createLeftSideActions() {
            AbstractAction balloon = new AbstractAction("Balloon Examples"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setExamples("// Example 1\nIcon:/toolwindows/toolWindowChanges.png\nTitle:Deleted Branch\nContent:Unmerged commits discarded\nActions:Restore,View Commits,Delete Tracked Branch\n\n// Example 2\nType:warn\nTitle:Title\nSubtitle:Subtitle\nContent:Foo<br>Bar\nSticky\n--\n// Description\nType:info/error/warn\nIcon:\nTitle:\nSubtitle:\nContent:\nContent:\nActions:\nSticky\n--\n");
                }
            };
            AbstractAction toolwindow = new AbstractAction("Toolwindow Examples"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setExamples("// Example\nToolwindow\nContent:Build completed successfully in 7 s 851 ms\n--\n// Description: Notifications shows for toolwindow TODO\nToolwindow\nType:info/error/warn\nIcon:\nTitle:\nContent:\nContent:\n--\n");
                }
            };
            Action[] actionArray = new Action[]{balloon, toolwindow};
            if (actionArray == null) {
                NotificationDialog.$$$reportNull$$$0(1);
            }
            return actionArray;
        }

        @Override
        public void doCancelAction() {
            PropertiesComponent.getInstance().setValue(NotificationTestAction.MESSAGE_KEY, StringUtil.nullize(this.myMessage.getText(), true));
            super.doCancelAction();
        }

        @Override
        protected void doOKAction() {
            this.newNotification(this.myMessage.getText());
        }

        private void setExamples(@NotNull String text2) {
            if (text2 == null) {
                NotificationDialog.$$$reportNull$$$0(2);
            }
            try {
                this.myMessage.getDocument().insertString(0, text2, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void newNotification(@NotNull String text2) {
            if (text2 == null) {
                NotificationDialog.$$$reportNull$$$0(3);
            }
            ArrayList<NotificationInfo> notifications = new ArrayList<NotificationInfo>();
            NotificationInfo notification = null;
            for (String line : StringUtil.splitByLines(text2, false)) {
                String value2;
                if (line.length() == 0 && notification != null) {
                    notification = null;
                    continue;
                }
                if (line.startsWith("//")) continue;
                if (line.startsWith("--")) break;
                if (notification == null) {
                    notification = new NotificationInfo();
                    notifications.add(notification);
                }
                if (line.startsWith("Icon:")) {
                    notification.setIcon(StringUtil.substringAfter(line, ":"));
                    continue;
                }
                if (line.startsWith("Title:")) {
                    notification.setTitle(StringUtil.substringAfter(line, ":"));
                    continue;
                }
                if (line.startsWith("Content:")) {
                    value2 = StringUtil.substringAfter(line, ":");
                    if (value2 == null) continue;
                    notification.addContent(value2);
                    continue;
                }
                if (line.startsWith("Subtitle:")) {
                    notification.setSubtitle(StringUtil.substringAfter(line, ":"));
                    continue;
                }
                if (line.startsWith("Actions:")) {
                    value2 = StringUtil.substringAfter(line, ":");
                    if (value2 == null) continue;
                    notification.setActions(StringUtil.split(value2, ","));
                    continue;
                }
                if (line.startsWith("Type:")) {
                    notification.setType(StringUtil.substringAfter(line, ":"));
                    continue;
                }
                if (line.equals("Sticky")) {
                    notification.setSticky(true);
                    continue;
                }
                if (line.equals("Listener")) {
                    notification.setAddListener(true);
                    continue;
                }
                if (line.equals("Toolwindow")) {
                    notification.setToolwindow(true);
                    continue;
                }
                if (!line.equals("LeftCollapseActions")) continue;
                notification.myRightActionsDirection = false;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                for (NotificationInfo info : notifications) {
                    this.myMessageBus.syncPublisher(Notifications.TOPIC).notify(info.getNotification());
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/notification/impl/actions/NotificationTestAction$NotificationDialog";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLeftSideActions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/notification/impl/actions/NotificationTestAction$NotificationDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setExamples";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "newNotification";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Holder {
        private static final NotificationGroup TEST_STICKY_GROUP = new NotificationGroup("Test Sticky Notification", NotificationDisplayType.STICKY_BALLOON);
        private static final NotificationGroup TEST_TOOLWINDOW_GROUP = NotificationGroup.toolWindowGroup("Test ToolWindow Notification", "TODO");

        private Holder() {
        }
    }
}

