/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.widget;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.EventLog;
import com.intellij.notification.LogModel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.UIBundle;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

public class IdeNotificationArea
extends JLabel
implements CustomStatusBarWidget,
IconLikeCustomStatusBarWidget {
    public static final String WIDGET_ID = "Notifications";
    @Nullable
    private StatusBar myStatusBar;

    public IdeNotificationArea() {
        this.setBorder(StatusBarWidget.WidgetBorder.ICON);
    }

    @Override
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    @Override
    public void dispose() {
        this.myStatusBar = null;
        UIUtil.dispose(this);
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            IdeNotificationArea.$$$reportNull$$$0(0);
        }
        this.myStatusBar = statusBar;
        final Project project2 = this.myStatusBar.getProject();
        if (project2 != null && !project2.isDisposed()) {
            new ClickListener(){

                @Override
                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!project2.isDisposed()) {
                        EventLog.toggleLog(project2, null);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/notification/impl/widget/IdeNotificationArea$1", "onClick"));
                }
            }.installOn(this, true);
            ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(LogModel.LOG_MODEL_CHANGED, () -> ApplicationManager.getApplication().invokeLater(() -> this.updateStatus(project2)));
            this.updateStatus(project2);
        }
    }

    @Override
    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    private void updateStatus(@Nullable Project project2) {
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        ArrayList<Notification> notifications = EventLog.getLogModel(project2).getNotifications();
        this.updateIconOnStatusBar(notifications);
        int count = notifications.size();
        this.setToolTipText(count > 0 ? UIBundle.message("status.bar.notifications.widget.tooltip", count) : UIBundle.message("status.bar.notifications.widget.no.notification.tooltip", new Object[0]));
    }

    private void updateIconOnStatusBar(ArrayList<Notification> notifications) {
        this.setIcon((Icon)this.createIconWithNotificationCount(notifications));
    }

    @NotNull
    private LayeredIcon createIconWithNotificationCount(List<? extends Notification> notifications) {
        return IdeNotificationArea.createIconWithNotificationCount(this, IdeNotificationArea.getMaximumType(notifications), notifications.size(), false);
    }

    @NotNull
    public static LayeredIcon createIconWithNotificationCount(JComponent component2, NotificationType type, int size, boolean forToolWindow) {
        LayeredIcon icon2 = new LayeredIcon(2);
        Icon baseIcon = IdeNotificationArea.getPendingNotificationsIcon(type, forToolWindow);
        icon2.setIcon(baseIcon, 0);
        if (size > 0) {
            Color textColor = type == NotificationType.ERROR || type == NotificationType.INFORMATION ? new JBColor(Color.white, new Color(0xF2F2F2)) : new Color(0x333333);
            icon2.setIcon((Icon)new TextIcon(component2, size < 10 ? String.valueOf(size) : "9+", textColor, baseIcon), 1);
        }
        LayeredIcon layeredIcon = icon2;
        if (layeredIcon == null) {
            IdeNotificationArea.$$$reportNull$$$0(1);
        }
        return layeredIcon;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private static Icon getPendingNotificationsIcon(NotificationType maximumType, boolean forToolWindow) {
        if (maximumType != null) {
            switch (maximumType) {
                case WARNING: {
                    return forToolWindow ? AllIcons.Toolwindows.WarningEvents : AllIcons.Ide.Notification.WarningEvents;
                }
                case ERROR: {
                    return forToolWindow ? AllIcons.Toolwindows.ErrorEvents : AllIcons.Ide.Notification.ErrorEvents;
                }
                case INFORMATION: {
                    return forToolWindow ? AllIcons.Toolwindows.InfoEvents : AllIcons.Ide.Notification.InfoEvents;
                }
            }
        }
        return forToolWindow ? AllIcons.Toolwindows.NoEvents : AllIcons.Ide.Notification.NoEvents;
    }

    @Nullable
    public static NotificationType getMaximumType(List<? extends Notification> notifications) {
        NotificationType result2 = null;
        for (Notification notification : notifications) {
            if (NotificationType.ERROR == notification.getType()) {
                return NotificationType.ERROR;
            }
            if (NotificationType.WARNING == notification.getType()) {
                result2 = NotificationType.WARNING;
                continue;
            }
            if (result2 != null || NotificationType.INFORMATION != notification.getType()) continue;
            result2 = NotificationType.INFORMATION;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/widget/IdeNotificationArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/widget/IdeNotificationArea";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconWithNotificationCount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TextIcon
    implements Icon {
        private final String myStr;
        private final JComponent myComponent;
        private final Color myTextColor;
        private final Icon myBaseIcon;
        private final int myWidth;
        private final Font myFont;

        TextIcon(JComponent component2, @NotNull String str, @NotNull Color textColor, @NotNull Icon baseIcon) {
            if (str == null) {
                TextIcon.$$$reportNull$$$0(0);
            }
            if (textColor == null) {
                TextIcon.$$$reportNull$$$0(1);
            }
            if (baseIcon == null) {
                TextIcon.$$$reportNull$$$0(2);
            }
            this.myStr = str;
            this.myComponent = component2;
            this.myTextColor = textColor;
            this.myBaseIcon = baseIcon;
            this.myFont = new Font(NotificationsUtil.getFontName(), 1, JBUIScale.scale(9));
            this.myWidth = this.myComponent.getFontMetrics(this.myFont).stringWidth(this.myStr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TextIcon)) {
                return false;
            }
            TextIcon icon2 = (TextIcon)o;
            if (this.myWidth != icon2.myWidth) {
                return false;
            }
            if (!this.myComponent.equals(icon2.myComponent)) {
                return false;
            }
            return this.myStr.equals(icon2.myStr);
        }

        public int hashCode() {
            int result2 = this.myStr.hashCode();
            result2 = 31 * result2 + this.myComponent.hashCode();
            result2 = 31 * result2 + this.myWidth;
            return result2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            UISettings.setupAntialiasing(g);
            Font originalFont = g.getFont();
            Color originalColor = g.getColor();
            g.setFont(this.myFont);
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)c, g);
            boolean isTwoChar = this.myStr.length() == 2;
            float center = this.getIconWidth() - fm.stringWidth(this.myStr) + (isTwoChar ? JBUIScale.scale(1) : 0);
            float textX = (float)x + center / 2.0f;
            float textY = y + SimpleColoredComponent.getTextBaseLine(fm, this.getIconHeight());
            if (!JreHiDpiUtil.isJreHiDPI(g2)) {
                textX = (float)Math.floor(textX);
            }
            g.setColor(this.myTextColor);
            g2.drawString(this.myStr.substring(0, 1), textX, textY);
            if (isTwoChar) {
                g2.drawString(this.myStr.substring(1), textX += (float)(fm.charWidth(this.myStr.charAt(0)) - JBUIScale.scale(1)), textY);
            }
            g.setFont(originalFont);
            g.setColor(originalColor);
        }

        @Override
        public int getIconWidth() {
            return this.myBaseIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myBaseIcon.getIconHeight();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "str";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textColor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseIcon";
                    break;
                }
            }
            objectArray[1] = "com/intellij/notification/impl/widget/IdeNotificationArea$TextIcon";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

