/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.widget;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.notification.EventLog;
import com.intellij.notification.EventLogListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.widget.IdeNotificationArea;
import com.intellij.notification.impl.widget.NotificationWidgetFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.components.JBLabel;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class NotificationWidgetListener
implements UISettingsListener,
ToolWindowManagerListener,
EventLogListener {
    NotificationWidgetListener() {
    }

    @Override
    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            NotificationWidgetListener.$$$reportNull$$$0(0);
        }
        NotificationWidgetListener.updateWidgetAndIcon();
    }

    @Override
    public void toolWindowRegistered(@NotNull String id2) {
        if (id2 == null) {
            NotificationWidgetListener.$$$reportNull$$$0(1);
        }
        if ("Event Log".equals(id2)) {
            NotificationWidgetListener.updateWidgetAndIcon();
        }
    }

    @Override
    public void modelChanged() {
        if (NotificationWidgetFactory.isAvailable()) {
            return;
        }
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager == null) {
            return;
        }
        for (Project project2 : projectManager.getOpenProjects()) {
            if (NotificationWidgetFactory.isAvailable()) continue;
            NotificationWidgetListener.updateToolWindowNotificationsIcon(project2);
        }
    }

    private static void updateWidgetAndIcon() {
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager == null) {
            return;
        }
        boolean widgetIsAvailable = NotificationWidgetFactory.isAvailable();
        NotificationWidgetFactory widgetFactory = StatusBarWidgetFactory.EP_NAME.findExtension(NotificationWidgetFactory.class);
        for (Project project2 : projectManager.getOpenProjects()) {
            if (widgetIsAvailable) {
                StatusBarWidgetsManager widgetsManager;
                if (widgetFactory == null || (widgetsManager = project2.getService(StatusBarWidgetsManager.class)).wasWidgetCreated(widgetFactory)) continue;
                widgetsManager.updateWidget(widgetFactory);
                continue;
            }
            NotificationWidgetListener.updateToolWindowNotificationsIcon(project2);
            if (widgetFactory == null) continue;
            project2.getService(StatusBarWidgetsManager.class).updateWidget(widgetFactory);
        }
    }

    private static void updateToolWindowNotificationsIcon(@NotNull Project project2) {
        ToolWindow eventLog;
        if (project2 == null) {
            NotificationWidgetListener.$$$reportNull$$$0(2);
        }
        if ((eventLog = EventLog.getEventLog(project2)) != null) {
            List<Notification> notifications = EventLog.getNotifications(project2);
            NotificationType type = IdeNotificationArea.getMaximumType(notifications);
            int size = notifications.size();
            ApplicationManager.getApplication().invokeLater(() -> eventLog.setIcon((Icon)IdeNotificationArea.createIconWithNotificationCount(new JBLabel(), type, size, true)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/notification/impl/widget/NotificationWidgetListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "uiSettingsChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "toolWindowRegistered";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateToolWindowNotificationsIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

