/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.openapi.MnemonicWrapper;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentTreeWatcher;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntPredicate;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MnemonicHelper
extends ComponentTreeWatcher {
    private static final Logger LOG = Logger.getInstance(MnemonicHelper.class);
    public static final Key<IntPredicate> MNEMONIC_CHECKER = Key.create("MNEMONIC_CHECKER");
    private static final String TEXT_CHANGED_PROPERTY = "text";
    private static final PropertyChangeListener ourTextPropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Object source = event.getSource();
            if (source instanceof AbstractButton) {
                SwingUtilities.invokeLater(() -> DialogUtil.registerMnemonic((AbstractButton)source));
            } else if (source instanceof JLabel) {
                SwingUtilities.invokeLater(() -> DialogUtil.registerMnemonic((JLabel)source, null));
            }
        }
    };
    private Map<Integer, String> myMnemonics;
    private static final MnemonicFixer ourMnemonicFixer = new MnemonicFixer();

    @Deprecated
    public MnemonicHelper() {
        super(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    @Override
    protected void processComponent(Component component2) {
        if (component2 instanceof AbstractButton) {
            component2.addPropertyChangeListener(TEXT_CHANGED_PROPERTY, ourTextPropertyListener);
            DialogUtil.registerMnemonic((AbstractButton)component2);
            this.checkForDuplicateMnemonics((AbstractButton)component2);
            MnemonicHelper.fixMacMnemonicKeyStroke((JComponent)component2, null);
        } else if (component2 instanceof JLabel) {
            component2.addPropertyChangeListener(TEXT_CHANGED_PROPERTY, ourTextPropertyListener);
            DialogUtil.registerMnemonic((JLabel)component2, null);
            this.checkForDuplicateMnemonics((JLabel)component2);
            MnemonicHelper.fixMacMnemonicKeyStroke((JComponent)component2, "release");
        } else if (component2 instanceof ActionButtonComponent) {
            MnemonicHelper.fixMacMnemonicKeyStroke((JComponent)component2, null);
        }
    }

    private static void fixMacMnemonicKeyStroke(JComponent component2, String type) {
        KeyStroke[] strokes;
        InputMap inputMap;
        if (SystemInfo.isMac && Registry.is("ide.mac.alt.mnemonic.without.ctrl") && (inputMap = component2.getInputMap(2)) != null && (strokes = inputMap.allKeys()) != null) {
            int mask = 10;
            for (KeyStroke stroke : strokes) {
                if (mask != (mask & stroke.getModifiers())) continue;
                inputMap.put(MnemonicHelper.getKeyStrokeWithoutCtrlModifier(stroke), type != null ? type : inputMap.get(stroke));
            }
        }
    }

    private static KeyStroke getKeyStrokeWithoutCtrlModifier(KeyStroke stroke) {
        try {
            Method method2 = AWTKeyStroke.class.getDeclaredMethod("getCachedStroke", Character.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            method2.setAccessible(true);
            int modifiers = stroke.getModifiers() & 0xFFFFFFFD & 0xFFFFFF7F;
            return (KeyStroke)method2.invoke(null, Character.valueOf(stroke.getKeyChar()), stroke.getKeyCode(), modifiers, stroke.isOnKeyRelease());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    protected void unprocessComponent(Component component2) {
    }

    public void checkForDuplicateMnemonics(JLabel label2) {
        if (!Registry.is("ide.checkDuplicateMnemonics")) {
            return;
        }
        this.checkForDuplicateMnemonics(label2.getDisplayedMnemonic(), label2.getText());
    }

    public void checkForDuplicateMnemonics(AbstractButton button2) {
        if (!Registry.is("ide.checkDuplicateMnemonics")) {
            return;
        }
        this.checkForDuplicateMnemonics(button2.getMnemonic(), button2.getText());
    }

    public void checkForDuplicateMnemonics(int mnemonic, String text2) {
        String other;
        if (mnemonic == 0) {
            return;
        }
        if (this.myMnemonics == null) {
            this.myMnemonics = new HashMap<Integer, String>();
        }
        if ((other = this.myMnemonics.get(mnemonic)) != null && !other.equals(text2)) {
            LOG.error("conflict: multiple components with mnemonic '" + (char)mnemonic + "' seen on '" + text2 + "' and '" + other + "'");
        }
        this.myMnemonics.put(mnemonic, text2);
    }

    public static CustomShortcutSet createShortcut(char ch) {
        Character mnemonic = Character.valueOf(ch);
        return CustomShortcutSet.fromString("alt " + (SystemInfo.isMac ? "released" : "pressed") + " " + mnemonic);
    }

    public static void init(Component component2) {
        if (Registry.is("ide.mnemonic.helper.old", false) || Registry.is("ide.checkDuplicateMnemonics", false)) {
            new MnemonicHelper().register(component2);
        } else {
            ourMnemonicFixer.addTo(component2);
        }
    }

    public static boolean hasMnemonic(@Nullable Component component2, int keyCode) {
        if (component2 instanceof AbstractButton) {
            AbstractButton button2 = (AbstractButton)component2;
            if (button2 instanceof JBOptionButton) {
                return ((JBOptionButton)button2).isOkToProcessDefaultMnemonics() || button2.getMnemonic() == keyCode;
            }
            return button2.getMnemonic() == keyCode;
        }
        if (component2 instanceof JLabel) {
            return ((JLabel)component2).getDisplayedMnemonic() == keyCode;
        }
        IntPredicate checker = UIUtil.getClientProperty((Object)component2, MNEMONIC_CHECKER);
        return checker != null && checker.test(keyCode);
    }

    public static int getFocusAcceleratorKeyMask() {
        return SystemInfo.isMac ? 10 : 8;
    }

    public static void registerMnemonicAction(@NotNull JComponent component2, int mnemonic) {
        if (component2 == null) {
            MnemonicHelper.$$$reportNull$$$0(0);
        }
        InputMap map2 = component2.getInputMap(2);
        int mask = MnemonicHelper.getFocusAcceleratorKeyMask();
        if (component2 instanceof AbstractButton) {
            map2.put(KeyStroke.getKeyStroke(mnemonic, mask, false), "pressed");
            map2.put(KeyStroke.getKeyStroke(mnemonic, mask, true), "released");
            map2.put(KeyStroke.getKeyStroke(mnemonic, 0, true), "released");
        } else if (component2 instanceof JLabel) {
            map2.put(KeyStroke.getKeyStroke(mnemonic, mask, true), "released");
        } else if (component2 instanceof ActionButtonComponent) {
            map2.put(KeyStroke.getKeyStroke(mnemonic, mask, false), "doClick");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/MnemonicHelper", "registerMnemonicAction"));
    }

    private static final class MnemonicFixer
    implements ContainerListener {
        private MnemonicFixer() {
        }

        void addTo(Component component2) {
            for (Component c : UIUtil.uiTraverser(component2)) {
                if (c instanceof Container) {
                    ((Container)c).addContainerListener(this);
                }
                if (c instanceof ActionButtonComponent) {
                    assert (c instanceof JComponent);
                    MnemonicHelper.fixMacMnemonicKeyStroke((JComponent)c, null);
                }
                MnemonicWrapper.getWrapper(c);
            }
        }

        void removeFrom(Component component2) {
            for (Container c : UIUtil.uiTraverser(component2).filter(Container.class)) {
                c.removeContainerListener(this);
            }
        }

        @Override
        public void componentAdded(ContainerEvent event) {
            this.addTo(event.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent event) {
            this.removeFrom(event.getChild());
        }
    }
}

