/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

abstract class MnemonicWrapper<T extends JComponent>
implements Runnable,
PropertyChangeListener {
    final T myComponent;
    private final String myTextProperty;
    private final String myCodeProperty;
    private final String myIndexProperty;
    private int myCode;
    private int myIndex;
    private boolean myFocusable;
    private boolean myEvent;
    private boolean myTextChanged;
    private Runnable myRunnable;

    public static MnemonicWrapper getWrapper(Component component2) {
        if (component2 == null || component2.getClass().getName().equals("com.intellij.openapi.wm.impl.StripeButton")) {
            return null;
        }
        for (PropertyChangeListener listener2 : component2.getPropertyChangeListeners()) {
            if (!(listener2 instanceof MnemonicWrapper)) continue;
            MnemonicWrapper wrapper2 = (MnemonicWrapper)listener2;
            wrapper2.run();
            return wrapper2;
        }
        if (component2 instanceof JMenuItem) {
            return new MenuWrapper((AbstractButton)component2);
        }
        if (component2 instanceof AbstractButton) {
            return new ButtonWrapper((AbstractButton)component2);
        }
        if (component2 instanceof JLabel) {
            return new LabelWrapper((JLabel)component2);
        }
        return null;
    }

    private MnemonicWrapper(T component2, String text2, String code, String index) {
        this.myComponent = component2;
        this.myTextProperty = text2;
        this.myCodeProperty = code;
        this.myIndexProperty = index;
        if (!this.updateText()) {
            this.myCode = this.getMnemonicCode();
            this.myIndex = this.getMnemonicIndex();
        }
        this.myFocusable = this.isFocusable();
        ((Container)this.myComponent).addPropertyChangeListener(this);
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean disabled = this.isDisabled();
        try {
            Component component2;
            int index;
            InputMap map2;
            int code;
            this.myEvent = true;
            if (this.myTextChanged) {
                this.updateText();
            }
            int n = code = disabled ? 0 : this.myCode;
            if (code != this.getMnemonicCode()) {
                this.setMnemonicCode(code);
            }
            if (SystemInfo.isMac && Registry.is("ide.mac.alt.mnemonic.without.ctrl", true) && (map2 = ((JComponent)this.myComponent).getInputMap(2)) != null) {
                this.updateInputMap(map2, code);
            }
            int n2 = index = disabled ? -1 : this.myIndex;
            if (index != this.getMnemonicIndex()) {
                try {
                    this.setMnemonicIndex(index);
                }
                catch (IllegalArgumentException cause) {
                    StringBuilder sb = new StringBuilder("cannot set mnemonic index ");
                    if (this.myTextChanged) {
                        sb.append("if text changed ");
                    }
                    String message = sb.append(this.myComponent).toString();
                    Logger.getInstance(MnemonicWrapper.class).warn(message, cause);
                }
            }
            if ((component2 = this.getFocusableComponent()) != null) {
                component2.setFocusable(disabled || this.myFocusable);
            }
        }
        finally {
            this.myEvent = false;
            this.myTextChanged = false;
            this.myRunnable = null;
        }
    }

    @Override
    public final void propertyChange(PropertyChangeEvent event) {
        if (!this.myEvent) {
            String property = event.getPropertyName();
            if (this.myTextProperty.equals(property)) {
                this.myTextChanged = true;
                this.updateRequest();
            } else if (this.myCodeProperty.equals(property)) {
                this.myCode = this.getMnemonicCode();
                this.updateRequest();
            } else if (this.myIndexProperty.equals(property)) {
                this.myIndex = this.getMnemonicIndex();
                this.updateRequest();
            } else if ("focusable".equals(property) || "labelFor".equals(property)) {
                this.myFocusable = this.isFocusable();
                this.updateRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateText() {
        String text2 = this.getText();
        if (text2 != null) {
            int code = 0;
            int index = -1;
            int length = text2.length();
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                char ch = text2.charAt(i);
                if (ch != '\u001b') {
                    sb.append(ch);
                    continue;
                }
                if (i + 1 >= length) continue;
                code = KeyEvent.getExtendedKeyCodeForChar(text2.charAt(i + 1));
                index = sb.length();
            }
            if (code != 0) {
                try {
                    this.myEvent = true;
                    this.setText(sb.toString());
                }
                finally {
                    this.myEvent = false;
                }
                this.myCode = code;
                this.myIndex = index;
                return true;
            }
        }
        return false;
    }

    private void updateRequest() {
        if (this.myRunnable == null) {
            this.myRunnable = this;
            SwingUtilities.invokeLater(this);
        }
    }

    private boolean isFocusable() {
        Component component2 = this.getFocusableComponent();
        return component2 == null || component2.isFocusable();
    }

    Component getFocusableComponent() {
        return this.myComponent;
    }

    boolean isDisabled() {
        return UISettings.getShadowInstance().getDisableMnemonicsInControls();
    }

    abstract String getText();

    abstract void setText(String var1);

    abstract int getMnemonicCode();

    abstract void setMnemonicCode(int var1);

    abstract int getMnemonicIndex();

    abstract void setMnemonicIndex(int var1);

    abstract void updateInputMap(InputMap var1, int var2);

    static KeyStroke fixMacKeyStroke(KeyStroke stroke, InputMap map2, int code, boolean onKeyRelease, String action2) {
        if (stroke != null && code != stroke.getKeyCode()) {
            map2.remove(stroke);
            stroke = null;
        }
        if (stroke == null && code != 0) {
            stroke = KeyStroke.getKeyStroke(code, 520, onKeyRelease);
            map2.put(stroke, action2);
        }
        return stroke;
    }

    /* synthetic */ MnemonicWrapper(JComponent x0, String x1, String x2, String x3, 1 x4) {
        this(x0, x1, x2, x3);
    }

    private static class LabelWrapper
    extends MnemonicWrapper<JLabel> {
        private KeyStroke myStrokeRelease;

        private LabelWrapper(JLabel component2) {
            super(component2, "text", "displayedMnemonic", "displayedMnemonicIndex", null);
        }

        @Override
        void updateInputMap(InputMap map2, int code) {
            this.myStrokeRelease = LabelWrapper.fixMacKeyStroke(this.myStrokeRelease, map2, code, true, "release");
        }

        @Override
        String getText() {
            return ((JLabel)this.myComponent).getText();
        }

        @Override
        void setText(String text2) {
            ((JLabel)this.myComponent).setText(text2);
        }

        @Override
        int getMnemonicCode() {
            return ((JLabel)this.myComponent).getDisplayedMnemonic();
        }

        @Override
        void setMnemonicCode(int code) {
            ((JLabel)this.myComponent).setDisplayedMnemonic(code);
        }

        @Override
        int getMnemonicIndex() {
            return ((JLabel)this.myComponent).getDisplayedMnemonicIndex();
        }

        @Override
        void setMnemonicIndex(int index) {
            ((JLabel)this.myComponent).setDisplayedMnemonicIndex(index);
        }

        @Override
        Component getFocusableComponent() {
            return ((JLabel)this.myComponent).getLabelFor();
        }
    }

    private static abstract class AbstractButtonWrapper
    extends MnemonicWrapper<AbstractButton> {
        private AbstractButtonWrapper(AbstractButton component2) {
            super(component2, "text", "mnemonic", "displayedMnemonicIndex", null);
        }

        @Override
        String getText() {
            return ((AbstractButton)this.myComponent).getText();
        }

        @Override
        void setText(String text2) {
            ((AbstractButton)this.myComponent).setText(text2);
        }

        @Override
        int getMnemonicCode() {
            return ((AbstractButton)this.myComponent).getMnemonic();
        }

        @Override
        void setMnemonicCode(int code) {
            ((AbstractButton)this.myComponent).setMnemonic(code);
        }

        @Override
        int getMnemonicIndex() {
            return ((AbstractButton)this.myComponent).getDisplayedMnemonicIndex();
        }

        @Override
        void setMnemonicIndex(int index) {
            ((AbstractButton)this.myComponent).setDisplayedMnemonicIndex(index);
        }
    }

    private static class ButtonWrapper
    extends AbstractButtonWrapper {
        private KeyStroke myStrokePressed;
        private KeyStroke myStrokeReleased;

        private ButtonWrapper(AbstractButton component2) {
            super(component2);
        }

        @Override
        void updateInputMap(InputMap map2, int code) {
            this.myStrokePressed = ButtonWrapper.fixMacKeyStroke(this.myStrokePressed, map2, code, false, "pressed");
            this.myStrokeReleased = ButtonWrapper.fixMacKeyStroke(this.myStrokeReleased, map2, code, true, "released");
        }
    }

    private static class MenuWrapper
    extends AbstractButtonWrapper {
        private KeyStroke myStrokePressed;

        private MenuWrapper(AbstractButton component2) {
            super(component2);
        }

        @Override
        void updateInputMap(InputMap map2, int code) {
            this.myStrokePressed = MenuWrapper.fixMacKeyStroke(this.myStrokePressed, map2, code, false, "selectMenu");
        }
    }
}

