/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnAction
implements PossiblyDumbAware {
    private static final Logger LOG = Logger.getInstance(AnAction.class);
    public static final Key<List<AnAction>> ACTIONS_KEY = Key.create("AnAction.shortcutSet");
    public static final AnAction[] EMPTY_ARRAY = new AnAction[0];
    private Presentation myTemplatePresentation;
    @NotNull
    private ShortcutSet myShortcutSet;
    private boolean myEnabledInModalContext;
    private boolean myIsDefaultIcon;
    private boolean myWorksInInjected;
    private SmartFMap<String, String> myActionTextOverrides;

    public AnAction() {
        this.myShortcutSet = CustomShortcutSet.EMPTY;
        this.myIsDefaultIcon = true;
        this.myActionTextOverrides = SmartFMap.emptyMap();
    }

    public AnAction(Icon icon2) {
        this(Presentation.NULL_STRING, Presentation.NULL_STRING, icon2);
    }

    public AnAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text2) {
        this(text2, null, null);
    }

    public AnAction(@NotNull Supplier<String> dynamicText) {
        if (dynamicText == null) {
            AnAction.$$$reportNull$$$0(0);
        }
        this(dynamicText, Presentation.NULL_STRING, null);
    }

    public AnAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text2, @Nullable @Nls(capitalization=Nls.Capitalization.Sentence) String description, @Nullable Icon icon2) {
        this(() -> text2, () -> description, icon2);
    }

    public AnAction(@NotNull Supplier<String> dynamicText, @NotNull Icon icon2) {
        if (dynamicText == null) {
            AnAction.$$$reportNull$$$0(1);
        }
        if (icon2 == null) {
            AnAction.$$$reportNull$$$0(2);
        }
        this(dynamicText, Presentation.NULL_STRING, icon2);
    }

    public AnAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, @Nullable Icon icon2) {
        if (dynamicText == null) {
            AnAction.$$$reportNull$$$0(3);
        }
        if (dynamicDescription == null) {
            AnAction.$$$reportNull$$$0(4);
        }
        this.myShortcutSet = CustomShortcutSet.EMPTY;
        this.myIsDefaultIcon = true;
        this.myActionTextOverrides = SmartFMap.emptyMap();
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(dynamicText);
        presentation.setDescription(dynamicDescription);
        presentation.setIcon(icon2);
    }

    @NotNull
    public final ShortcutSet getShortcutSet() {
        ShortcutSet shortcutSet = this.myShortcutSet;
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(5);
        }
        return shortcutSet;
    }

    public final void registerCustomShortcutSet(@NotNull ShortcutSet shortcutSet, @Nullable JComponent component2) {
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(6);
        }
        this.registerCustomShortcutSet(shortcutSet, component2, null);
    }

    public final void registerCustomShortcutSet(int keyCode, @JdkConstants.InputEventMask int modifiers, @Nullable JComponent component2) {
        this.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(keyCode, modifiers)), component2);
    }

    public final void registerCustomShortcutSet(@NotNull ShortcutSet shortcutSet, @Nullable JComponent component2, @Nullable Disposable parentDisposable) {
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(7);
        }
        this.setShortcutSet(shortcutSet);
        this.registerCustomShortcutSet(component2, parentDisposable);
    }

    public final void registerCustomShortcutSet(@Nullable JComponent component2, @Nullable Disposable parentDisposable) {
        if (component2 == null) {
            return;
        }
        List<AnAction> actionList = ComponentUtil.getClientProperty(component2, ACTIONS_KEY);
        if (actionList == null) {
            actionList = new SmartList<AnAction>();
            SmartList<AnAction> value2 = actionList;
            ComponentUtil.putClientProperty(component2, ACTIONS_KEY, value2);
        }
        if (!actionList.contains(this)) {
            actionList.add(this);
        }
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.unregisterCustomShortcutSet(component2));
        }
    }

    public final void unregisterCustomShortcutSet(@Nullable JComponent component2) {
        List<AnAction> actionList = ComponentUtil.getClientProperty(component2, ACTIONS_KEY);
        if (actionList != null) {
            actionList.remove(this);
        }
    }

    public final void copyFrom(@NotNull AnAction sourceAction) {
        if (sourceAction == null) {
            AnAction.$$$reportNull$$$0(8);
        }
        Presentation sourcePresentation = sourceAction.getTemplatePresentation();
        Presentation presentation = this.getTemplatePresentation();
        presentation.copyFrom(sourcePresentation);
        this.copyShortcutFrom(sourceAction);
    }

    public final void copyShortcutFrom(@NotNull AnAction sourceAction) {
        if (sourceAction == null) {
            AnAction.$$$reportNull$$$0(9);
        }
        this.setShortcutSet(sourceAction.getShortcutSet());
    }

    public final boolean isEnabledInModalContext() {
        return this.myEnabledInModalContext;
    }

    protected final void setEnabledInModalContext(boolean enabledInModalContext) {
        this.myEnabledInModalContext = enabledInModalContext;
    }

    public boolean displayTextInToolbar() {
        return false;
    }

    public boolean useSmallerFontForTextInToolbar() {
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnAction.$$$reportNull$$$0(10);
        }
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            AnAction.$$$reportNull$$$0(11);
        }
        boolean worksInInjected = this.isInInjectedContext();
        e.setInjectedContext(worksInInjected);
        this.update(e);
        if (!e.getPresentation().isEnabled() && worksInInjected) {
            e.setInjectedContext(false);
            this.update(e);
        }
    }

    @NotNull
    public final Presentation getTemplatePresentation() {
        Presentation presentation = this.myTemplatePresentation;
        if (presentation == null) {
            this.myTemplatePresentation = presentation = this.createTemplatePresentation();
        }
        Presentation presentation2 = presentation;
        if (presentation2 == null) {
            AnAction.$$$reportNull$$$0(12);
        }
        return presentation2;
    }

    @NotNull
    Presentation createTemplatePresentation() {
        return new Presentation();
    }

    public abstract void actionPerformed(@NotNull AnActionEvent var1);

    protected void setShortcutSet(@NotNull ShortcutSet shortcutSet) {
        ActionManager actionManager;
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(13);
        }
        if (this.myShortcutSet != shortcutSet && this.myShortcutSet != CustomShortcutSet.EMPTY && LoadingState.PROJECT_OPENED.isOccurred() && (actionManager = ServiceManager.getServiceIfCreated(ActionManager.class)) != null && actionManager.getId(this) != null) {
            LOG.warn("ShortcutSet of global AnActions should not be changed outside of KeymapManager.\nThis is likely not what you wanted to do. Consider setting shortcut in keymap defaults, inheriting from other action using `use-shortcut-of` or wrapping with EmptyAction.wrap().", new Throwable());
        }
        this.myShortcutSet = shortcutSet;
    }

    public void setDefaultIcon(boolean isDefaultIconSet) {
        this.myIsDefaultIcon = isDefaultIconSet;
    }

    public boolean isDefaultIcon() {
        return this.myIsDefaultIcon;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public boolean isInInjectedContext() {
        return this.myWorksInInjected;
    }

    public boolean isTransparentUpdate() {
        return this instanceof TransparentUpdate;
    }

    @Deprecated
    public boolean startInTransaction() {
        return false;
    }

    public void addTextOverride(@NotNull String place, @NotNull String text2) {
        if (place == null) {
            AnAction.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            AnAction.$$$reportNull$$$0(15);
        }
        this.myActionTextOverrides = this.myActionTextOverrides.plus(place, text2);
    }

    public void applyTextOverride(AnActionEvent e) {
        String override = this.myActionTextOverrides.get(e.getPlace());
        if (override != null) {
            e.getPresentation().setText(() -> override);
        }
    }

    @Nullable
    public static Project getEventProject(AnActionEvent e) {
        return e == null ? null : e.getData(CommonDataKeys.PROJECT);
    }

    public String toString() {
        return this.getTemplatePresentation().toString();
    }

    @Nullable
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getTemplateText() {
        return this.getTemplatePresentation().getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/AnAction";
                break;
            }
            case 6: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/AnAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutSet";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomShortcutSet";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyShortcutFrom";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setShortcutSet";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addTextOverride";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface TransparentUpdate {
    }
}

