/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.util.SmartFMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Presentation
implements Cloneable {
    public static final Supplier<String> NULL_STRING = () -> null;
    private SmartFMap<String, Object> myUserMap;
    @NonNls
    public static final String PROP_TEXT = "text";
    @NonNls
    public static final String PROP_MNEMONIC_KEY = "mnemonicKey";
    @NonNls
    public static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    @NonNls
    public static final String PROP_DESCRIPTION = "description";
    @NonNls
    public static final String PROP_ICON = "icon";
    @NonNls
    public static final String PROP_DISABLED_ICON = "disabledIcon";
    @NonNls
    public static final String PROP_SELECTED_ICON = "selectedIcon";
    @NonNls
    public static final String PROP_HOVERED_ICON = "hoveredIcon";
    @NonNls
    public static final String PROP_VISIBLE = "visible";
    @NonNls
    public static final String PROP_ENABLED = "enabled";
    public static final double DEFAULT_WEIGHT = 0.0;
    public static final double HIGHER_WEIGHT = 42.0;
    public static final double EVEN_HIGHER_WEIGHT = 239.0;
    private PropertyChangeSupport myChangeSupport;
    @NotNull
    private Supplier<String> myDescriptionSupplier;
    private Icon myIcon;
    private Icon myDisabledIcon;
    private Icon myHoveredIcon;
    private Icon mySelectedIcon;
    @NotNull
    private Supplier<TextWithMnemonic> myTextWithMnemonicSupplier;
    private boolean myVisible;
    private boolean myEnabled;
    private double myWeight;

    public Presentation() {
        this.myUserMap = SmartFMap.emptyMap();
        this.myDescriptionSupplier = () -> null;
        this.myTextWithMnemonicSupplier = () -> null;
        this.myVisible = true;
        this.myEnabled = true;
        this.myWeight = 0.0;
    }

    public Presentation(@NotNull String text2) {
        if (text2 == null) {
            Presentation.$$$reportNull$$$0(0);
        }
        this.myUserMap = SmartFMap.emptyMap();
        this.myDescriptionSupplier = () -> null;
        this.myTextWithMnemonicSupplier = () -> null;
        this.myVisible = true;
        this.myEnabled = true;
        this.myWeight = 0.0;
        this.myTextWithMnemonicSupplier = () -> TextWithMnemonic.fromPlainText(text2);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener l) {
        PropertyChangeSupport support;
        if (l == null) {
            Presentation.$$$reportNull$$$0(1);
        }
        if ((support = this.myChangeSupport) == null) {
            this.myChangeSupport = support = new PropertyChangeSupport(this);
        }
        support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener l) {
        PropertyChangeSupport support;
        if (l == null) {
            Presentation.$$$reportNull$$$0(2);
        }
        if ((support = this.myChangeSupport) != null) {
            support.removePropertyChangeListener(l);
        }
    }

    public String getText() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.getText();
    }

    public void setText(@NotNull @Nls(capitalization=Nls.Capitalization.Title) Supplier<String> text2, boolean mayContainMnemonic) {
        if (text2 == null) {
            Presentation.$$$reportNull$$$0(3);
        }
        this.setTextWithMnemonic(this.getTextWithMnemonic(text2, mayContainMnemonic));
    }

    public void setText(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text2, boolean mayContainMnemonic) {
        this.setTextWithMnemonic(this.getTextWithMnemonic(() -> text2, mayContainMnemonic));
    }

    @NotNull
    public Supplier<TextWithMnemonic> getTextWithMnemonic(@Nls(capitalization=Nls.Capitalization.Title) @NotNull Supplier<String> text2, boolean mayContainMnemonic) {
        if (text2 == null) {
            Presentation.$$$reportNull$$$0(4);
        }
        Supplier<TextWithMnemonic> textWithMnemonic = () -> null;
        if (text2.get() != null) {
            if (mayContainMnemonic) {
                textWithMnemonic = () -> TextWithMnemonic.parse((String)text2.get());
                UISettings uiSettings = UISettings.getInstanceOrNull();
                if (uiSettings != null && uiSettings.getDisableMnemonicsInControls()) {
                    Supplier<TextWithMnemonic> finalTextWithMnemonic = textWithMnemonic;
                    textWithMnemonic = () -> ((TextWithMnemonic)finalTextWithMnemonic.get()).dropMnemonic();
                }
            } else {
                textWithMnemonic = () -> TextWithMnemonic.fromPlainText((String)text2.get());
            }
        }
        Supplier<TextWithMnemonic> supplier = textWithMnemonic;
        if (supplier == null) {
            Presentation.$$$reportNull$$$0(5);
        }
        return supplier;
    }

    public void setTextWithMnemonic(@NotNull Supplier<TextWithMnemonic> textWithMnemonicSupplier) {
        if (textWithMnemonicSupplier == null) {
            Presentation.$$$reportNull$$$0(6);
        }
        String oldText = this.getText();
        int oldMnemonic = this.getMnemonic();
        int oldIndex = this.getDisplayedMnemonicIndex();
        this.myTextWithMnemonicSupplier = textWithMnemonicSupplier;
        this.fireObjectPropertyChange(PROP_TEXT, oldText, this.getText());
        this.fireObjectPropertyChange(PROP_MNEMONIC_KEY, oldMnemonic, this.getMnemonic());
        this.fireObjectPropertyChange(PROP_MNEMONIC_INDEX, oldIndex, this.getDisplayedMnemonicIndex());
    }

    public void setText(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text2) {
        this.setText(() -> text2, true);
    }

    public void setText(@NotNull @Nls(capitalization=Nls.Capitalization.Title) Supplier<String> text2) {
        if (text2 == null) {
            Presentation.$$$reportNull$$$0(7);
        }
        this.setText(text2, true);
    }

    @Nullable
    public String getTextWithMnemonic() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.toString();
    }

    @NotNull
    public Supplier<TextWithMnemonic> getTextWithPossibleMnemonic() {
        Supplier<TextWithMnemonic> supplier = this.myTextWithMnemonicSupplier;
        if (supplier == null) {
            Presentation.$$$reportNull$$$0(8);
        }
        return supplier;
    }

    public void restoreTextWithMnemonic(Presentation presentation) {
        this.setTextWithMnemonic(presentation.getTextWithPossibleMnemonic());
    }

    public static String restoreTextWithMnemonic(@Nullable String text2, int mnemonic) {
        if (text2 == null) {
            return null;
        }
        TextWithMnemonic textWithMnemonic = TextWithMnemonic.fromPlainText(text2);
        for (int i = 0; i < text2.length(); ++i) {
            if (Character.toUpperCase(text2.charAt(i)) != mnemonic) continue;
            return textWithMnemonic.setMnemonicAt(i).toString();
        }
        return textWithMnemonic.toString();
    }

    public String getDescription() {
        return this.myDescriptionSupplier.get();
    }

    public void setDescription(@NotNull Supplier<String> dynamicDescription) {
        if (dynamicDescription == null) {
            Presentation.$$$reportNull$$$0(9);
        }
        Supplier<String> oldDescription = this.myDescriptionSupplier;
        this.myDescriptionSupplier = dynamicDescription;
        this.fireObjectPropertyChange(PROP_DESCRIPTION, oldDescription.get(), this.myDescriptionSupplier.get());
    }

    public void setDescription(@Nls(capitalization=Nls.Capitalization.Sentence) String description) {
        Supplier<String> oldDescriptionSupplier = this.myDescriptionSupplier;
        this.myDescriptionSupplier = () -> description;
        this.fireObjectPropertyChange(PROP_DESCRIPTION, oldDescriptionSupplier.get(), description);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(@Nullable Icon icon2) {
        Icon oldIcon = this.myIcon;
        this.myIcon = icon2;
        this.fireObjectPropertyChange(PROP_ICON, oldIcon, this.myIcon);
    }

    public Icon getDisabledIcon() {
        return this.myDisabledIcon;
    }

    public void setDisabledIcon(@Nullable Icon icon2) {
        Icon oldDisabledIcon = this.myDisabledIcon;
        this.myDisabledIcon = icon2;
        this.fireObjectPropertyChange(PROP_DISABLED_ICON, oldDisabledIcon, this.myDisabledIcon);
    }

    public Icon getHoveredIcon() {
        return this.myHoveredIcon;
    }

    public void setHoveredIcon(@Nullable Icon hoveredIcon) {
        Icon old = this.myHoveredIcon;
        this.myHoveredIcon = hoveredIcon;
        this.fireObjectPropertyChange(PROP_HOVERED_ICON, old, this.myHoveredIcon);
    }

    public Icon getSelectedIcon() {
        return this.mySelectedIcon;
    }

    public void setSelectedIcon(Icon selectedIcon) {
        Icon old = this.mySelectedIcon;
        this.mySelectedIcon = selectedIcon;
        this.fireObjectPropertyChange(PROP_SELECTED_ICON, old, this.mySelectedIcon);
    }

    public int getMnemonic() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? 0 : textWithMnemonic.getMnemonic();
    }

    public int getDisplayedMnemonicIndex() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? -1 : textWithMnemonic.getMnemonicIndex();
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.myVisible;
        this.myVisible = visible;
        this.fireBooleanPropertyChange(PROP_VISIBLE, oldVisible, this.myVisible);
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.myEnabled;
        this.myEnabled = enabled;
        this.fireBooleanPropertyChange(PROP_ENABLED, oldEnabled, this.myEnabled);
    }

    public final void setEnabledAndVisible(boolean enabled) {
        this.setEnabled(enabled);
        this.setVisible(enabled);
    }

    private void fireBooleanPropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (oldValue != newValue && support != null) {
            support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void fireObjectPropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (support != null && !Objects.equals(oldValue, newValue)) {
            support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public Presentation clone() {
        try {
            Presentation clone = (Presentation)super.clone();
            clone.myChangeSupport = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void copyFrom(Presentation presentation) {
        if (presentation == this) {
            return;
        }
        this.setTextWithMnemonic(presentation.getTextWithPossibleMnemonic());
        this.setDescription(presentation.myDescriptionSupplier);
        this.setIcon(presentation.getIcon());
        this.setSelectedIcon(presentation.getSelectedIcon());
        this.setDisabledIcon(presentation.getDisabledIcon());
        this.setHoveredIcon(presentation.getHoveredIcon());
        this.setVisible(presentation.isVisible());
        this.setEnabled(presentation.isEnabled());
        this.setWeight(presentation.getWeight());
        if (!this.myUserMap.equals(presentation.myUserMap)) {
            HashSet<String> allKeys = new HashSet<String>(presentation.myUserMap.keySet());
            allKeys.addAll(this.myUserMap.keySet());
            if (!allKeys.isEmpty()) {
                for (String key : allKeys) {
                    this.putClientProperty(key, presentation.getClientProperty(key));
                }
            }
        }
    }

    @Nullable
    public <T> T getClientProperty(@NotNull Key<T> key) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(10);
        }
        return (T)this.myUserMap.get(key.toString());
    }

    public <T> void putClientProperty(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(11);
        }
        this.putClientProperty(key.toString(), value2);
    }

    @Nullable
    public Object getClientProperty(@NonNls @NotNull String key) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(12);
        }
        return this.myUserMap.get(key);
    }

    public void putClientProperty(@NonNls @NotNull String key, @Nullable Object value2) {
        Object oldValue;
        if (key == null) {
            Presentation.$$$reportNull$$$0(13);
        }
        if (Comparing.equal(oldValue = this.myUserMap.get(key), value2)) {
            return;
        }
        this.myUserMap = value2 == null ? this.myUserMap.minus(key) : this.myUserMap.plus(key, value2);
        this.fireObjectPropertyChange(key, oldValue, value2);
    }

    public double getWeight() {
        return this.myWeight;
    }

    public void setWeight(double weight2) {
        this.myWeight = weight2;
    }

    public String toString() {
        return this.getText() + " (" + this.myDescriptionSupplier.get() + ")";
    }

    public boolean isEnabledAndVisible() {
        return this.isEnabled() && this.isVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROP_TEXT;
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/Presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textWithMnemonicSupplier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/Presentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithMnemonic";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithPossibleMnemonic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithMnemonic";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTextWithMnemonic";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

