/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PausesStat;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionUtil {
    private static final Logger LOG = Logger.getInstance(ActionUtil.class);
    @NonNls
    private static final String WAS_ENABLED_BEFORE_DUMB = "WAS_ENABLED_BEFORE_DUMB";
    @NonNls
    public static final String WOULD_BE_ENABLED_IF_NOT_DUMB_MODE = "WOULD_BE_ENABLED_IF_NOT_DUMB_MODE";
    @NonNls
    private static final String WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE = "WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE";
    @NonNls
    private static final Key<ActionUpdateData> ACTION_UPDATE_DATA = Key.create("ACTION_UPDATE_DATA");
    private static int insidePerformDumbAwareUpdate;

    private ActionUtil() {
    }

    public static void showDumbModeWarning(AnActionEvent ... events) {
        if (events == null) {
            ActionUtil.$$$reportNull$$$0(0);
        }
        Project project2 = null;
        ArrayList<String> actionNames = new ArrayList<String>();
        for (AnActionEvent event : events) {
            Project _project;
            String s = event.getPresentation().getText();
            if (StringUtil.isNotEmpty(s)) {
                actionNames.add(s);
            }
            if ((_project = event.getProject()) == null || project2 != null) continue;
            project2 = _project;
        }
        if (project2 == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Showing dumb mode warning for " + Arrays.asList(events), new Throwable());
        }
        DumbService.getInstance(project2).showDumbModeNotification(ActionUtil.getActionUnavailableMessage(actionNames));
    }

    @NotNull
    private static String getActionUnavailableMessage(@NotNull List<String> actionNames) {
        if (actionNames == null) {
            ActionUtil.$$$reportNull$$$0(1);
        }
        String message = actionNames.isEmpty() ? ActionUtil.getUnavailableMessage("This action", false) : (actionNames.size() == 1 ? ActionUtil.getUnavailableMessage("'" + actionNames.get(0) + "'", false) : ActionUtil.getUnavailableMessage("None of the following actions", true) + ": " + StringUtil.join(actionNames, ", "));
        String string = message;
        if (string == null) {
            ActionUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getUnavailableMessage(@NotNull String action2, boolean plural) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(3);
        }
        String string = action2 + (plural ? " are" : " is") + " not available while " + ApplicationNamesInfo.getInstance().getProductName() + " is updating indices";
        if (string == null) {
            ActionUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void performFastUpdate(boolean isInModalContext, @NotNull AnAction action2, @NotNull AnActionEvent event, boolean forceUseCached) {
        long finishUpdateNs;
        Presentation templatePresentation;
        ActionUpdateData ud;
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(5);
        }
        if (event == null) {
            ActionUtil.$$$reportNull$$$0(6);
        }
        if ((ud = (templatePresentation = action2.getTemplatePresentation()).getClientProperty(ACTION_UPDATE_DATA)) == null) {
            ud = new ActionUpdateData();
            templatePresentation.putClientProperty(ACTION_UPDATE_DATA, ud);
        }
        boolean isSlow = ud.averageUpdateDurationMs > 10L;
        long startTimeNs = System.nanoTime();
        long relaxMs = Math.min(ud.averageUpdateDurationMs * 100L, 10000L);
        if (isSlow && ud.lastUpdateEvent != null && (forceUseCached || (startTimeNs - ud.lastUpdateTimeNs) / 1000000L < relaxMs)) {
            event.getPresentation().copyFrom(ud.lastUpdateEvent.getPresentation());
            return;
        }
        ActionUtil.performDumbAwareUpdate(isInModalContext, action2, event, false);
        ud.lastUpdateTimeNs = finishUpdateNs = System.nanoTime();
        ud.lastUpdateEvent = event;
        float smoothAlpha = isSlow ? 0.8f : 0.3f;
        float smoothCoAlpha = 1.0f - smoothAlpha;
        long spentMs = (finishUpdateNs - startTimeNs) / 1000000L;
        ud.averageUpdateDurationMs = Math.round((float)spentMs * smoothAlpha + (float)ud.averageUpdateDurationMs * smoothCoAlpha);
    }

    public static boolean performDumbAwareUpdate(boolean isInModalContext, @NotNull AnAction action2, @NotNull AnActionEvent e, boolean beforeActionPerformed) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(7);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(8);
        }
        Presentation presentation = e.getPresentation();
        if (LightEdit.owns(e.getProject()) && !LightEdit.isActionCompatible(action2)) {
            presentation.setEnabledAndVisible(false);
            return false;
        }
        Boolean wasEnabledBefore = (Boolean)presentation.getClientProperty(WAS_ENABLED_BEFORE_DUMB);
        boolean dumbMode = ActionUtil.isDumbMode(e.getProject());
        if (wasEnabledBefore != null && !dumbMode) {
            presentation.putClientProperty(WAS_ENABLED_BEFORE_DUMB, null);
            presentation.setEnabled(wasEnabledBefore);
            presentation.setVisible(true);
        }
        boolean enabledBeforeUpdate = presentation.isEnabled();
        boolean allowed = !(dumbMode && !action2.isDumbAware() || Registry.is("actionSystem.honor.modal.context") && isInModalContext && !action2.isEnabledInModalContext());
        String presentationText = presentation.getText();
        boolean edt = ApplicationManager.getApplication().isDispatchThread();
        if (edt && insidePerformDumbAwareUpdate++ == 0) {
            ActionPauses.STAT.started();
        }
        action2.applyTextOverride(e);
        try {
            if (beforeActionPerformed) {
                action2.beforeActionPerformedUpdate(e);
            } else {
                action2.update(e);
            }
            presentation.putClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE, (Object)(!allowed && presentation.isEnabled() ? 1 : 0));
            presentation.putClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE, (Object)(!allowed && presentation.isVisible() ? 1 : 0));
        }
        catch (IndexNotReadyException e1) {
            if (!allowed) {
                boolean bl = true;
                return bl;
            }
            throw e1;
        }
        finally {
            if (edt && --insidePerformDumbAwareUpdate == 0) {
                ActionPauses.STAT.finished(presentationText + " action update (" + action2.getClass() + ")");
            }
            if (!allowed) {
                if (wasEnabledBefore == null) {
                    presentation.putClientProperty(WAS_ENABLED_BEFORE_DUMB, (Object)enabledBeforeUpdate);
                }
                presentation.setEnabled(false);
            }
        }
        return false;
    }

    @Deprecated
    public static boolean performDumbAwareUpdate(@NotNull AnAction action2, @NotNull AnActionEvent e, boolean beforeActionPerformed) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(9);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(10);
        }
        return ActionUtil.performDumbAwareUpdate(false, action2, e, beforeActionPerformed);
    }

    public static <T> T underModalProgress(@NotNull Project project2, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String progressTitle, @NotNull Computable<T> computable) throws ProcessCanceledException {
        if (project2 == null) {
            ActionUtil.$$$reportNull$$$0(11);
        }
        if (progressTitle == null) {
            ActionUtil.$$$reportNull$$$0(12);
        }
        if (computable == null) {
            ActionUtil.$$$reportNull$$$0(13);
        }
        DumbService dumbService = DumbService.getInstance(project2);
        boolean useAlternativeResolve = dumbService.isAlternativeResolveEnabled();
        ThrowableComputable inReadAction = () -> ApplicationManager.getApplication().runReadAction(computable);
        ThrowableComputable prioritizedRunnable = () -> ProgressManager.getInstance().computePrioritized(inReadAction);
        ThrowableComputable process2 = useAlternativeResolve ? () -> dumbService.computeWithAlternativeResolveEnabled(prioritizedRunnable) : prioritizedRunnable;
        return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(process2, progressTitle, true, project2);
    }

    public static boolean isDumbMode(@Nullable Project project2) {
        if (project2 != null) {
            return DumbService.getInstance(project2).isDumb();
        }
        for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
            if (!DumbService.getInstance(openProject).isDumb()) continue;
            return true;
        }
        return false;
    }

    public static boolean lastUpdateAndCheckDumb(AnAction action2, AnActionEvent e, boolean visibilityMatters) {
        ActionUtil.performDumbAwareUpdate(false, action2, e, true);
        Project project2 = e.getProject();
        if (project2 != null && DumbService.getInstance(project2).isDumb() && !action2.isDumbAware()) {
            if (Boolean.FALSE.equals(e.getPresentation().getClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE))) {
                return false;
            }
            if (visibilityMatters && Boolean.FALSE.equals(e.getPresentation().getClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE))) {
                return false;
            }
            ActionUtil.showDumbModeWarning(e);
            return false;
        }
        if (!e.getPresentation().isEnabled()) {
            return false;
        }
        return !visibilityMatters || e.getPresentation().isVisible();
    }

    public static void performActionDumbAwareWithCallbacks(@NotNull AnAction action2, @NotNull AnActionEvent e, @NotNull DataContext context) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(14);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(15);
        }
        if (context == null) {
            ActionUtil.$$$reportNull$$$0(16);
        }
        ActionManagerEx manager = ActionManagerEx.getInstanceEx();
        manager.fireBeforeActionPerformed(action2, context, e);
        ActionUtil.performActionDumbAware(action2, e);
        manager.fireAfterActionPerformed(action2, context, e);
    }

    public static void performActionDumbAware(AnAction action2, AnActionEvent e) {
        try {
            action2.actionPerformed(e);
        }
        catch (IndexNotReadyException ex) {
            LOG.info(ex);
            ActionUtil.showDumbModeWarning(e);
        }
    }

    @NotNull
    public static AnActionEvent createEmptyEvent() {
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext("unknown", null, dataId -> null);
        if (anActionEvent == null) {
            ActionUtil.$$$reportNull$$$0(17);
        }
        return anActionEvent;
    }

    public static void sortAlphabetically(@NotNull List<? extends AnAction> list2) {
        if (list2 == null) {
            ActionUtil.$$$reportNull$$$0(18);
        }
        list2.sort((o1, o2) -> Comparing.compare(o1.getTemplateText(), o2.getTemplateText()));
    }

    public static void moveActionTo(@NotNull List<AnAction> list2, @NotNull String actionText, @NotNull String targetActionText, boolean before) {
        if (list2 == null) {
            ActionUtil.$$$reportNull$$$0(19);
        }
        if (actionText == null) {
            ActionUtil.$$$reportNull$$$0(20);
        }
        if (targetActionText == null) {
            ActionUtil.$$$reportNull$$$0(21);
        }
        if (Comparing.equal(actionText, targetActionText)) {
            return;
        }
        int actionIndex = -1;
        int targetIndex = -1;
        for (int i = 0; i < list2.size(); ++i) {
            AnAction action2 = list2.get(i);
            if (actionIndex == -1 && Comparing.equal(actionText, action2.getTemplateText())) {
                actionIndex = i;
            }
            if (targetIndex == -1 && Comparing.equal(targetActionText, action2.getTemplateText())) {
                targetIndex = i;
            }
            if (actionIndex == -1 || targetIndex == -1) continue;
            if (actionIndex < targetIndex) {
                --targetIndex;
            }
            AnAction anAction = list2.remove(actionIndex);
            list2.add(before ? Math.max(0, targetIndex) : targetIndex + 1, anAction);
            return;
        }
    }

    @NotNull
    public static List<AnAction> getActions(@NotNull JComponent component2) {
        if (component2 == null) {
            ActionUtil.$$$reportNull$$$0(22);
        }
        List<AnAction> list2 = ContainerUtil.notNullize(ComponentUtil.getClientProperty(component2, AnAction.ACTIONS_KEY));
        if (list2 == null) {
            ActionUtil.$$$reportNull$$$0(23);
        }
        return list2;
    }

    public static void clearActions(@NotNull JComponent component2) {
        if (component2 == null) {
            ActionUtil.$$$reportNull$$$0(24);
        }
        ComponentUtil.putClientProperty(component2, AnAction.ACTIONS_KEY, null);
    }

    public static void copyRegisteredShortcuts(@NotNull JComponent to, @NotNull JComponent from) {
        if (to == null) {
            ActionUtil.$$$reportNull$$$0(25);
        }
        if (from == null) {
            ActionUtil.$$$reportNull$$$0(26);
        }
        for (AnAction anAction : ActionUtil.getActions(from)) {
            anAction.registerCustomShortcutSet(anAction.getShortcutSet(), to);
        }
    }

    public static void registerForEveryKeyboardShortcut(@NotNull JComponent component2, @NotNull ActionListener action2, @NotNull ShortcutSet shortcuts) {
        if (component2 == null) {
            ActionUtil.$$$reportNull$$$0(27);
        }
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(28);
        }
        if (shortcuts == null) {
            ActionUtil.$$$reportNull$$$0(29);
        }
        for (Shortcut shortcut : shortcuts.getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyboardShortcut ks = (KeyboardShortcut)shortcut;
            KeyStroke first = ks.getFirstKeyStroke();
            KeyStroke second = ks.getSecondKeyStroke();
            if (second != null) continue;
            component2.registerKeyboardAction(action2, first, 2);
        }
    }

    public static void recursiveRegisterShortcutSet(@NotNull ActionGroup group, @NotNull JComponent component2, @Nullable Disposable parentDisposable) {
        if (group == null) {
            ActionUtil.$$$reportNull$$$0(30);
        }
        if (component2 == null) {
            ActionUtil.$$$reportNull$$$0(31);
        }
        for (AnAction action2 : group.getChildren(null)) {
            if (action2 instanceof ActionGroup) {
                ActionUtil.recursiveRegisterShortcutSet((ActionGroup)action2, component2, parentDisposable);
            }
            action2.registerCustomShortcutSet(component2, parentDisposable);
        }
    }

    public static boolean recursiveContainsAction(@NotNull ActionGroup group, @NotNull AnAction action2) {
        if (group == null) {
            ActionUtil.$$$reportNull$$$0(32);
        }
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(33);
        }
        return ActionUtil.anyActionFromGroupMatches(group, true, Predicate.isEqual(action2));
    }

    public static boolean anyActionFromGroupMatches(@NotNull ActionGroup group, boolean processPopupSubGroups, @NotNull Predicate<? super AnAction> condition2) {
        if (group == null) {
            ActionUtil.$$$reportNull$$$0(34);
        }
        if (condition2 == null) {
            ActionUtil.$$$reportNull$$$0(35);
        }
        for (AnAction child2 : group.getChildren(null)) {
            if (condition2.test(child2)) {
                return true;
            }
            if (!(child2 instanceof ActionGroup)) continue;
            ActionGroup childGroup = (ActionGroup)child2;
            if (!processPopupSubGroups && childGroup.isPopup() || !ActionUtil.anyActionFromGroupMatches(childGroup, processPopupSubGroups, condition2)) continue;
            return true;
        }
        return false;
    }

    public static AnAction copyFrom(@NotNull AnAction action2, @NotNull @NonNls String actionId) {
        AnAction from;
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(36);
        }
        if (actionId == null) {
            ActionUtil.$$$reportNull$$$0(37);
        }
        if ((from = ActionManager.getInstance().getAction(actionId)) != null) {
            action2.copyFrom(from);
        }
        ActionsCollector.getInstance().onActionConfiguredByActionId(action2, actionId);
        return action2;
    }

    public static AnAction mergeFrom(@NotNull AnAction action2, @NotNull String actionId) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(38);
        }
        if (actionId == null) {
            ActionUtil.$$$reportNull$$$0(39);
        }
        AnAction a1 = action2;
        AnAction a2 = ActionManager.getInstance().getAction(actionId);
        Presentation p1 = a1.getTemplatePresentation();
        Presentation p2 = a2.getTemplatePresentation();
        p1.setIcon(ObjectUtils.chooseNotNull(p1.getIcon(), p2.getIcon()));
        p1.setDisabledIcon(ObjectUtils.chooseNotNull(p1.getDisabledIcon(), p2.getDisabledIcon()));
        p1.setSelectedIcon(ObjectUtils.chooseNotNull(p1.getSelectedIcon(), p2.getSelectedIcon()));
        p1.setHoveredIcon(ObjectUtils.chooseNotNull(p1.getHoveredIcon(), p2.getHoveredIcon()));
        if (StringUtil.isEmpty(p1.getText())) {
            p1.setTextWithMnemonic(p2.getTextWithPossibleMnemonic());
        }
        p1.setDescription(ObjectUtils.chooseNotNull(p1.getDescription(), p2.getDescription()));
        ShortcutSet ss1 = a1.getShortcutSet();
        if (ss1 == CustomShortcutSet.EMPTY) {
            a1.copyShortcutFrom(a2);
        }
        ActionsCollector.getInstance().onActionConfiguredByActionId(action2, actionId);
        return a1;
    }

    public static void invokeAction(@NotNull AnAction action2, @NotNull Component component2, @NotNull String place, @Nullable InputEvent inputEvent, @Nullable Runnable onDone) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(40);
        }
        if (component2 == null) {
            ActionUtil.$$$reportNull$$$0(41);
        }
        if (place == null) {
            ActionUtil.$$$reportNull$$$0(42);
        }
        ActionUtil.invokeAction(action2, DataManager.getInstance().getDataContext(component2), place, inputEvent, onDone);
    }

    public static void invokeAction(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull String place, @Nullable InputEvent inputEvent, @Nullable Runnable onDone) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(43);
        }
        if (dataContext == null) {
            ActionUtil.$$$reportNull$$$0(44);
        }
        if (place == null) {
            ActionUtil.$$$reportNull$$$0(45);
        }
        Presentation presentation = action2.getTemplatePresentation().clone();
        AnActionEvent event = new AnActionEvent(inputEvent, dataContext, place, presentation, ActionManager.getInstance(), 0);
        ActionUtil.performDumbAwareUpdate(false, action2, event, true);
        ActionManagerEx manager = ActionManagerEx.getInstanceEx();
        if (event.getPresentation().isEnabled() && event.getPresentation().isVisible()) {
            manager.fireBeforeActionPerformed(action2, dataContext, event);
            ActionUtil.performActionDumbAware(action2, event);
            if (onDone != null) {
                onDone.run();
            }
            manager.fireAfterActionPerformed(action2, dataContext, event);
        }
    }

    @NotNull
    public static ActionListener createActionListener(@NotNull String actionId, @NotNull Component component2, @NotNull String place) {
        if (actionId == null) {
            ActionUtil.$$$reportNull$$$0(46);
        }
        if (component2 == null) {
            ActionUtil.$$$reportNull$$$0(47);
        }
        if (place == null) {
            ActionUtil.$$$reportNull$$$0(48);
        }
        ActionListener actionListener = e -> {
            AnAction action2 = ActionManager.getInstance().getAction(actionId);
            if (action2 == null) {
                LOG.warn("Can not find action by id " + actionId);
                return;
            }
            ActionUtil.invokeAction(action2, component2, place, null, null);
        };
        if (actionListener == null) {
            ActionUtil.$$$reportNull$$$0(49);
        }
        return actionListener;
    }

    @Nullable
    public static ShortcutSet getMnemonicAsShortcut(@NotNull AnAction action2) {
        int mnemonic;
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(50);
        }
        if ((mnemonic = KeyEvent.getExtendedKeyCodeForChar(action2.getTemplatePresentation().getMnemonic())) != 0) {
            KeyboardShortcut ctrlAltShortcut = new KeyboardShortcut(KeyStroke.getKeyStroke(mnemonic, 640), null);
            KeyboardShortcut altShortcut = new KeyboardShortcut(KeyStroke.getKeyStroke(mnemonic, 512), null);
            CustomShortcutSet shortcutSet = SystemInfo.isMac ? (Registry.is("ide.mac.alt.mnemonic.without.ctrl") ? new CustomShortcutSet(ctrlAltShortcut, altShortcut) : new CustomShortcutSet(ctrlAltShortcut)) : new CustomShortcutSet(altShortcut);
            return shortcutSet;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 17: 
            case 23: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 17: 
            case 23: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionNames";
                break;
            }
            case 2: 
            case 4: 
            case 17: 
            case 23: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/ActionUtil";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 28: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionText";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetActionText";
                break;
            }
            case 22: 
            case 24: 
            case 27: 
            case 31: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 37: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ActionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUnavailableMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnavailableMessage";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyEvent";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showDumbModeWarning";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getActionUnavailableMessage";
                break;
            }
            case 2: 
            case 4: 
            case 17: 
            case 23: 
            case 49: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUnavailableMessage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performFastUpdate";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performDumbAwareUpdate";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "underModalProgress";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performActionDumbAwareWithCallbacks";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sortAlphabetically";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "moveActionTo";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "clearActions";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copyRegisteredShortcuts";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "registerForEveryKeyboardShortcut";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "recursiveRegisterShortcutSet";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "recursiveContainsAction";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "anyActionFromGroupMatches";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "mergeFrom";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createActionListener";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getMnemonicAsShortcut";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 17: 
            case 23: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ActionUpdateData {
        AnActionEvent lastUpdateEvent;
        long lastUpdateTimeNs = 0L;
        long averageUpdateDurationMs = 0L;

        private ActionUpdateData() {
        }
    }

    public static class ActionPauses {
        public static final PausesStat STAT = new PausesStat("AnAction.update()");
    }
}

