/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AbbreviationManager", storages={@Storage(value="abbreviations.xml", roamingType=RoamingType.PER_OS)})
public class AbbreviationManagerImpl
extends AbbreviationManager
implements PersistentStateComponent<Element> {
    private final Map<String, List<String>> myAbbreviation2ActionId = new THashMap<String, List<String>>();
    private final Map<String, Set<String>> myActionId2Abbreviations = new THashMap<String, Set<String>>();
    private final Map<String, Set<String>> myPluginsActionId2Abbreviations = new THashMap<String, Set<String>>();

    @Override
    @Nullable
    public Element getState() {
        Element actions = new Element("actions");
        if (this.myActionId2Abbreviations.isEmpty()) {
            return actions;
        }
        Element abbreviations = null;
        for (Map.Entry<String, Set<String>> entry : this.myActionId2Abbreviations.entrySet()) {
            Set<String> pluginAbbrs;
            String key = entry.getKey();
            Set<String> abbrs = entry.getValue();
            if (abbrs == (pluginAbbrs = this.myPluginsActionId2Abbreviations.get(key)) || abbrs != null && abbrs.equals(pluginAbbrs) || abbrs == null) continue;
            if (abbreviations == null) {
                abbreviations = new Element("abbreviations");
                actions.addContent(abbreviations);
            }
            Element action2 = new Element("action");
            action2.setAttribute("id", key);
            abbreviations.addContent(action2);
            for (String abbr : abbrs) {
                Element abbreviation = new Element("abbreviation");
                abbreviation.setAttribute("name", abbr);
                action2.addContent(abbreviation);
            }
        }
        return actions;
    }

    @Override
    public void loadState(@NotNull Element state) {
        List<Element> abbreviations;
        if (state == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(0);
        }
        if ((abbreviations = state.getChildren("abbreviations")).size() == 1) {
            List<Element> actions = abbreviations.get(0).getChildren("action");
            for (Element action2 : actions) {
                String actionId = action2.getAttributeValue("id");
                Set values2 = this.myActionId2Abbreviations.computeIfAbsent(actionId, k -> new LinkedHashSet(1));
                for (Element abbr : action2.getChildren("abbreviation")) {
                    String abbrValue = abbr.getAttributeValue("name");
                    if (abbrValue == null) continue;
                    values2.add(abbrValue);
                    this.myAbbreviation2ActionId.computeIfAbsent(abbrValue, k -> new ArrayList()).add(actionId);
                }
            }
        }
    }

    @Override
    @NotNull
    public Set<String> getAbbreviations() {
        Set<String> set = this.myActionId2Abbreviations.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (set == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getAbbreviations(@NotNull String actionId) {
        Set<String> abbreviations;
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(2);
        }
        if ((abbreviations = this.myActionId2Abbreviations.get(actionId)) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                AbbreviationManagerImpl.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<String> set = Collections.unmodifiableSet(abbreviations);
        if (set == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @NotNull
    public List<String> findActions(@NotNull String abbreviation) {
        List<String> actions;
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(5);
        }
        List<Object> list2 = (actions = this.myAbbreviation2ActionId.get(abbreviation)) == null ? Collections.emptyList() : Collections.unmodifiableList(actions);
        if (list2 == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private static void register(@NotNull String abbreviation, @NotNull String actionId, @NotNull Map<String, Set<String>> storage) {
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(7);
        }
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(8);
        }
        if (storage == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(9);
        }
        storage.computeIfAbsent(actionId, k -> new LinkedHashSet(1)).add(abbreviation);
    }

    public void register(@NotNull String abbreviation, @NotNull String actionId, boolean fromPluginXml) {
        List ids;
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(10);
        }
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(11);
        }
        if (fromPluginXml && this.myActionId2Abbreviations.containsKey(actionId)) {
            AbbreviationManagerImpl.register(abbreviation, actionId, this.myPluginsActionId2Abbreviations);
            return;
        }
        AbbreviationManagerImpl.register(abbreviation, actionId, this.myActionId2Abbreviations);
        if (fromPluginXml) {
            AbbreviationManagerImpl.register(abbreviation, actionId, this.myPluginsActionId2Abbreviations);
        }
        if (!(ids = this.myAbbreviation2ActionId.computeIfAbsent(abbreviation, k -> new ArrayList(0))).contains(actionId)) {
            ids.add(actionId);
        }
    }

    @Override
    public void register(@NotNull String abbreviation, @NotNull String actionId) {
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(12);
        }
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(13);
        }
        this.register(abbreviation, actionId, false);
    }

    @Override
    public void remove(@NotNull String abbreviation, @NotNull String actionId) {
        Set<String> abbreviations;
        List<String> actions;
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(14);
        }
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(15);
        }
        if ((actions = this.myAbbreviation2ActionId.get(abbreviation)) != null) {
            actions.remove(actionId);
        }
        if ((abbreviations = this.myActionId2Abbreviations.get(actionId)) != null) {
            abbreviations.remove(abbreviation);
        } else {
            Set<String> abbrs = this.myActionId2Abbreviations.get(actionId);
            if (abbrs != null) {
                LinkedHashSet<String> customValues = new LinkedHashSet<String>(abbrs);
                customValues.remove(abbreviation);
                this.myActionId2Abbreviations.put(actionId, customValues);
            }
        }
    }

    @Override
    public void removeAllAbbreviations(@NotNull String actionId) {
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(16);
        }
        Set<String> abbreviations = this.getAbbreviations(actionId);
        for (String abbreviation : abbreviations) {
            this.myAbbreviation2ActionId.get(abbreviation).remove(actionId);
        }
        this.myActionId2Abbreviations.remove(actionId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/AbbreviationManagerImpl";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abbreviation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/AbbreviationManagerImpl";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbbreviations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAbbreviations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findActions";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeAllAbbreviations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

