/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.AbstractBundle;
import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.idea.IdeaLogger;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupStub;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.OverridingAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PreloadableAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionPopupMenuListener;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.AbbreviationManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ButtonToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ChameleonAction;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ProxyShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionManagerImpl
extends ActionManagerEx
implements Disposable {
    private static final ExtensionPointName<ActionConfigurationCustomizer> EP = new ExtensionPointName("com.intellij.actionConfigurationCustomizer");
    private static final String ACTION_ELEMENT_NAME = "action";
    private static final String GROUP_ELEMENT_NAME = "group";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String ID_ATTR_NAME = "id";
    private static final String INTERNAL_ATTR_NAME = "internal";
    private static final String ICON_ATTR_NAME = "icon";
    private static final String ADD_TO_GROUP_ELEMENT_NAME = "add-to-group";
    private static final String SHORTCUT_ELEMENT_NAME = "keyboard-shortcut";
    private static final String MOUSE_SHORTCUT_ELEMENT_NAME = "mouse-shortcut";
    private static final String DESCRIPTION = "description";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String POPUP_ATTR_NAME = "popup";
    private static final String COMPACT_ATTR_NAME = "compact";
    private static final String SEPARATOR_ELEMENT_NAME = "separator";
    private static final String REFERENCE_ELEMENT_NAME = "reference";
    private static final String ABBREVIATION_ELEMENT_NAME = "abbreviation";
    private static final String GROUPID_ATTR_NAME = "group-id";
    private static final String ANCHOR_ELEMENT_NAME = "anchor";
    private static final String FIRST = "first";
    private static final String LAST = "last";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String SECONDARY = "secondary";
    private static final String RELATIVE_TO_ACTION_ATTR_NAME = "relative-to-action";
    private static final String FIRST_KEYSTROKE_ATTR_NAME = "first-keystroke";
    private static final String SECOND_KEYSTROKE_ATTR_NAME = "second-keystroke";
    private static final String REMOVE_SHORTCUT_ATTR_NAME = "remove";
    private static final String REPLACE_SHORTCUT_ATTR_NAME = "replace-all";
    private static final String KEYMAP_ATTR_NAME = "keymap";
    private static final String KEYSTROKE_ATTR_NAME = "keystroke";
    private static final String REF_ATTR_NAME = "ref";
    private static final String VALUE_ATTR_NAME = "value";
    private static final String ACTIONS_BUNDLE = "messages.ActionsBundle";
    private static final String USE_SHORTCUT_OF_ATTR_NAME = "use-shortcut-of";
    private static final String OVERRIDES_ATTR_NAME = "overrides";
    private static final String KEEP_CONTENT_ATTR_NAME = "keep-content";
    private static final String PROJECT_TYPE = "project-type";
    private static final String UNREGISTER_ELEMENT_NAME = "unregister";
    private static final String OVERRIDE_TEXT_ELEMENT_NAME = "override-text";
    private static final String PLACE_ATTR_NAME = "place";
    private static final String USE_TEXT_OF_PLACE_ATTR_NAME = "use-text-of-place";
    private static final String RESOURCE_BUNDLE_ATTR_NAME = "resource-bundle";
    private static final Logger LOG = Logger.getInstance(ActionManagerImpl.class);
    private static final int DEACTIVATED_TIMER_DELAY = 5000;
    private static final int TIMER_DELAY = 500;
    private static final int UPDATE_DELAY_AFTER_TYPING = 500;
    private final Object myLock = new Object();
    private final Map<String, AnAction> myId2Action = new THashMap<String, AnAction>();
    private final MultiMap<PluginId, String> myPlugin2Id = new MultiMap();
    private final TObjectIntHashMap<String> myId2Index = new TObjectIntHashMap();
    private final Map<Object, String> myAction2Id = new THashMap<Object, String>();
    private final MultiMap<String, String> myId2GroupId = new MultiMap();
    private final List<String> myNotRegisteredInternalActionIds = new ArrayList<String>();
    private final List<AnActionListener> myActionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<ActionPopupMenuListener> myActionPopupMenuListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Object> myPopups = new ArrayList<Object>();
    private MyTimer myTimer;
    private int myRegisteredActionsCount;
    private String myLastPreformedActionId;
    private String myPrevPerformedActionId;
    private long myLastTimeEditorWasTypedIn;
    private boolean myTransparentOnlyUpdate;
    private final Map<OverridingAction, AnAction> myBaseActions = new HashMap<OverridingAction, AnAction>();
    private int myAnonymousGroupIdCounter;
    private boolean myPreloadComplete;

    ActionManagerImpl() {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode()) {
            LoadingState.COMPONENTS_LOADED.checkOccurred();
            if (!app.isHeadlessEnvironment()) {
                LOG.assertTrue(!app.isDispatchThread());
            }
        }
        for (IdeaPluginDescriptorImpl plugin : PluginManagerCore.getLoadedPlugins(null)) {
            this.registerPluginActions(plugin, plugin.getActionDescriptionElements(), true);
        }
        EP.forEachExtensionSafe(customizer -> customizer.customize(this));
    }

    @NotNull
    private static AnActionListener publisher() {
        AnActionListener anActionListener = ApplicationManager.getApplication().getMessageBus().syncPublisher(AnActionListener.TOPIC);
        if (anActionListener == null) {
            ActionManagerImpl.$$$reportNull$$$0(0);
        }
        return anActionListener;
    }

    @Nullable
    static AnAction convertStub(@NotNull ActionStub stub) {
        AnAction anAction;
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(1);
        }
        if ((anAction = ActionManagerImpl.instantiate(stub.getClassName(), stub.getPlugin(), AnAction.class)) == null) {
            return null;
        }
        stub.initAction(anAction);
        ActionManagerImpl.updateIconFromStub(stub, anAction);
        return anAction;
    }

    @Nullable
    private static <T> T instantiate(@NotNull String stubClassName, @NotNull IdeaPluginDescriptor pluginDescriptor, Class<T> expectedClass) {
        Object obj;
        if (stubClassName == null) {
            ActionManagerImpl.$$$reportNull$$$0(2);
        }
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(3);
        }
        try {
            obj = expectedClass == ActionGroup.class ? ApplicationManager.getApplication().instantiateExtensionWithPicoContainerOnlyIfNeeded(stubClassName, pluginDescriptor) : ReflectionUtil.newInstance(Class.forName(stubClassName, true, pluginDescriptor.getPluginClassLoader()), false);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (PluginException e) {
            LOG.error(e);
            return null;
        }
        catch (Throwable e) {
            LOG.error(new PluginException(e, pluginDescriptor.getPluginId()));
            return null;
        }
        if (!expectedClass.isInstance(obj)) {
            LOG.error(new PluginException("class with name '" + stubClassName + "' must be an instance of '" + expectedClass.getName() + "'; got " + obj, pluginDescriptor.getPluginId()));
            return null;
        }
        return obj;
    }

    private static void updateIconFromStub(@NotNull ActionStubBase stub, AnAction anAction) {
        String iconPath;
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(4);
        }
        if ((iconPath = stub.getIconPath()) == null) {
            return;
        }
        ActionManagerImpl.setIconFromClass(anAction.getClass(), stub.getPlugin(), iconPath, anAction.getTemplatePresentation());
    }

    @Nullable
    static ActionGroup convertGroupStub(@NotNull ActionGroupStub stub, @NotNull ActionManager actionManager) {
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(5);
        }
        if (actionManager == null) {
            ActionManagerImpl.$$$reportNull$$$0(6);
        }
        IdeaPluginDescriptor plugin = stub.getPlugin();
        ActionGroup group = ActionManagerImpl.instantiate(stub.getActionClass(), plugin, ActionGroup.class);
        if (group == null) {
            return null;
        }
        stub.initGroup(group, actionManager);
        ActionManagerImpl.updateIconFromStub(stub, group);
        return group;
    }

    private static void processAbbreviationNode(@NotNull Element e, @NotNull String id2) {
        String abbr;
        if (e == null) {
            ActionManagerImpl.$$$reportNull$$$0(7);
        }
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(8);
        }
        if (!StringUtil.isEmpty(abbr = e.getAttributeValue(VALUE_ATTR_NAME))) {
            AbbreviationManagerImpl abbreviationManager = (AbbreviationManagerImpl)AbbreviationManager.getInstance();
            abbreviationManager.register(abbr, id2, true);
        }
    }

    @Nullable
    private static ResourceBundle getActionsResourceBundle(@NotNull IdeaPluginDescriptor plugin, @Nullable String bundleName) {
        if (plugin == null) {
            ActionManagerImpl.$$$reportNull$$$0(9);
        }
        String resBundleName = bundleName != null ? bundleName : (plugin.getPluginId() != PluginManagerCore.CORE_ID ? plugin.getResourceBundleBaseName() : ACTIONS_BUNDLE);
        return resBundleName == null ? null : DynamicBundle.INSTANCE.getResourceBundle(resBundleName, plugin.getPluginClassLoader());
    }

    private static boolean isSecondary(Element element2) {
        return "true".equalsIgnoreCase(element2.getAttributeValue(SECONDARY));
    }

    private static void setIcon(@Nullable String iconPath, @NotNull String className, @NotNull PluginDescriptor pluginDescriptor, @NotNull Presentation presentation) {
        if (className == null) {
            ActionManagerImpl.$$$reportNull$$$0(10);
        }
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(11);
        }
        if (presentation == null) {
            ActionManagerImpl.$$$reportNull$$$0(12);
        }
        if (iconPath == null) {
            return;
        }
        try {
            Class<?> actionClass = Class.forName(className, true, pluginDescriptor.getPluginClassLoader());
            ActionManagerImpl.setIconFromClass(actionClass, pluginDescriptor, iconPath, presentation);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOG.error(e);
            ActionManagerImpl.reportActionError(pluginDescriptor.getPluginId(), "class with name \"" + className + "\" not found");
        }
    }

    private static void setIconFromClass(final @NotNull Class<?> actionClass, final @NotNull PluginDescriptor pluginDescriptor, final @NotNull String iconPath, @NotNull Presentation presentation) {
        if (actionClass == null) {
            ActionManagerImpl.$$$reportNull$$$0(13);
        }
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(14);
        }
        if (iconPath == null) {
            ActionManagerImpl.$$$reportNull$$$0(15);
        }
        if (presentation == null) {
            ActionManagerImpl.$$$reportNull$$$0(16);
        }
        presentation.setIcon(new IconLoader.LazyIcon(){

            @Override
            @NotNull
            protected Icon compute() {
                Icon icon2 = IconLoader.findIcon(iconPath, actionClass, true, false);
                if (icon2 == null) {
                    icon2 = IconLoader.findIcon(iconPath, pluginDescriptor.getPluginClassLoader());
                }
                if (icon2 == null) {
                    ActionManagerImpl.reportActionError(pluginDescriptor.getPluginId(), "Icon cannot be found in '" + iconPath + "', action '" + actionClass + "'");
                    Icon icon3 = AllIcons.Nodes.Unknown;
                    if (icon3 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon3;
                }
                Icon icon4 = icon2;
                if (icon4 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return icon4;
            }

            public String toString() {
                return "LazyIcon@ActionManagerImpl (path: " + iconPath + ", action class: " + actionClass + ")";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl$1", "compute"));
            }
        });
    }

    private static String computeDescription(ResourceBundle bundle, String id2, String elementType, String descriptionValue) {
        if (bundle != null) {
            String key = elementType + "." + id2 + ".description";
            return AbstractBundle.messageOrDefault(bundle, key, StringUtil.notNullize(descriptionValue), new Object[0]);
        }
        return descriptionValue;
    }

    private static String computeActionText(ResourceBundle bundle, String id2, String elementType, String textValue) {
        return AbstractBundle.messageOrDefault(bundle, elementType + "." + id2 + "." + TEXT_ATTR_NAME, StringUtil.notNullize(textValue), new Object[0]);
    }

    private static boolean checkRelativeToAction(String relativeToActionId, @NotNull Anchor anchor2, @NotNull String actionName, @Nullable PluginId pluginId) {
        if (anchor2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(17);
        }
        if (actionName == null) {
            ActionManagerImpl.$$$reportNull$$$0(18);
        }
        if ((Anchor.BEFORE == anchor2 || Anchor.AFTER == anchor2) && relativeToActionId == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": \"relative-to-action\" cannot be null if anchor is \"after\" or \"before\"");
            return false;
        }
        return true;
    }

    @Nullable
    private static Anchor parseAnchor(String anchorStr, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (anchorStr == null) {
            return Anchor.LAST;
        }
        if (FIRST.equalsIgnoreCase(anchorStr)) {
            return Anchor.FIRST;
        }
        if (LAST.equalsIgnoreCase(anchorStr)) {
            return Anchor.LAST;
        }
        if (BEFORE.equalsIgnoreCase(anchorStr)) {
            return Anchor.BEFORE;
        }
        if (AFTER.equalsIgnoreCase(anchorStr)) {
            return Anchor.AFTER;
        }
        ActionManagerImpl.reportActionError(pluginId, actionName + ": anchor should be one of the following constants: \"first\", \"last\", \"before\" or \"after\"");
        return null;
    }

    private static void processMouseShortcutNode(Element element2, String actionId, PluginId pluginId, @NotNull KeymapManager keymapManager2) {
        MouseShortcut shortcut;
        String keystrokeString;
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(19);
        }
        if ((keystrokeString = element2.getAttributeValue(KEYSTROKE_ATTR_NAME)) == null || keystrokeString.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        try {
            shortcut = KeymapUtil.parseMouseShortcut(keystrokeString);
        }
        catch (Exception ex) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element2.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap2 = keymapManager2.getKeymap(keymapName);
        if (keymap2 == null) {
            ActionManagerImpl.reportKeymapNotFoundWarning(pluginId, keymapName);
            return;
        }
        ActionManagerImpl.processRemoveAndReplace(element2, actionId, keymap2, shortcut);
    }

    private void assertActionIsGroupOrStub(AnAction action2) {
        if (this.myPreloadComplete) {
            return;
        }
        if (!(action2 instanceof ActionGroup || action2 instanceof ActionStub || action2 instanceof ChameleonAction)) {
            LOG.error("Action : " + action2 + "; class: " + action2.getClass());
        }
    }

    private static void reportActionError(@Nullable PluginId pluginId, @NotNull String message) {
        if (message == null) {
            ActionManagerImpl.$$$reportNull$$$0(20);
        }
        ActionManagerImpl.reportActionError(pluginId, message, null);
    }

    private static void reportActionError(@Nullable PluginId pluginId, @NotNull String message, @Nullable Throwable cause) {
        if (message == null) {
            ActionManagerImpl.$$$reportNull$$$0(21);
        }
        if (pluginId != null) {
            LOG.error(new PluginException(message, cause, pluginId));
        } else if (cause != null) {
            LOG.error(message, cause);
        } else {
            LOG.error(message);
        }
    }

    private static void reportKeymapNotFoundWarning(@Nullable PluginId pluginId, @NotNull String keymapName) {
        if (keymapName == null) {
            ActionManagerImpl.$$$reportNull$$$0(22);
        }
        if (DefaultKeymap.isBundledKeymapHidden(keymapName)) {
            return;
        }
        String message = "keymap \"" + keymapName + "\" not found";
        LOG.warn(pluginId == null ? message : new PluginException(message, null, pluginId).getMessage());
    }

    private static String getPluginInfo(@Nullable PluginId id2) {
        IdeaPluginDescriptor plugin;
        if (id2 != null && (plugin = PluginManagerCore.getPlugin(id2)) != null) {
            String name = plugin.getName();
            if (name == null) {
                name = id2.getIdString();
            }
            return " Plugin: " + name;
        }
        return "";
    }

    @NotNull
    private static DataContext getContextBy(Component contextComponent) {
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext = contextComponent != null ? dataManager.getDataContext(contextComponent) : dataManager.getDataContext();
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(23);
        }
        return dataContext;
    }

    @Override
    public void dispose() {
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
        }
    }

    @Override
    public void addTimerListener(int delay, @NotNull TimerListener listener2) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(24);
        }
        this._addTimerListener(listener2, false);
    }

    @Override
    public void removeTimerListener(@NotNull TimerListener listener2) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(25);
        }
        this._removeTimerListener(listener2, false);
    }

    @Override
    public void addTransparentTimerListener(int delay, @NotNull TimerListener listener2) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(26);
        }
        this._addTimerListener(listener2, true);
    }

    @Override
    public void removeTransparentTimerListener(@NotNull TimerListener listener2) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(27);
        }
        this._removeTimerListener(listener2, true);
    }

    private void _addTimerListener(TimerListener listener2, boolean transparent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.myTimer == null) {
            this.myTimer = new MyTimer();
            this.myTimer.start();
        }
        this.myTimer.addTimerListener(listener2, transparent);
    }

    private void _removeTimerListener(TimerListener listener2, boolean transparent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (LOG.assertTrue(this.myTimer != null)) {
            this.myTimer.removeTimerListener(listener2, transparent);
        }
    }

    @NotNull
    public ActionPopupMenu createActionPopupMenu(@NotNull String place, @NotNull ActionGroup group, @Nullable PresentationFactory presentationFactory) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(28);
        }
        if (group == null) {
            ActionManagerImpl.$$$reportNull$$$0(29);
        }
        return new ActionPopupMenuImpl(place, group, this, presentationFactory);
    }

    @Override
    @NotNull
    public ActionPopupMenu createActionPopupMenu(@NotNull String place, @NotNull ActionGroup group) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(30);
        }
        if (group == null) {
            ActionManagerImpl.$$$reportNull$$$0(31);
        }
        return new ActionPopupMenuImpl(place, group, this, null);
    }

    @Override
    @NotNull
    public ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group, boolean horizontal) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(32);
        }
        if (group == null) {
            ActionManagerImpl.$$$reportNull$$$0(33);
        }
        ActionToolbar actionToolbar = this.createActionToolbar(place, group, horizontal, false);
        if (actionToolbar == null) {
            ActionManagerImpl.$$$reportNull$$$0(34);
        }
        return actionToolbar;
    }

    @Override
    @NotNull
    public ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group, boolean horizontal, boolean decorateButtons) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(35);
        }
        if (group == null) {
            ActionManagerImpl.$$$reportNull$$$0(36);
        }
        return new ActionToolbarImpl(place, group, horizontal, decorateButtons);
    }

    public void registerPluginActions(@NotNull IdeaPluginDescriptorImpl plugin, @Nullable List<Element> actionDescriptionElements, boolean initialStartup) {
        if (plugin == null) {
            ActionManagerImpl.$$$reportNull$$$0(37);
        }
        if (actionDescriptionElements == null) {
            return;
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        for (Element e : actionDescriptionElements) {
            Element parent = e.getParentElement();
            String bundleName = parent == null ? null : parent.getAttributeValue(RESOURCE_BUNDLE_ATTR_NAME);
            this.processActionsChildElement(e, plugin, ActionManagerImpl.getActionsResourceBundle(plugin, bundleName), initialStartup);
        }
        StartUpMeasurer.addPluginCost(plugin.getPluginId().getIdString(), "Actions", StartUpMeasurer.getCurrentTime() - startTime);
    }

    @Override
    @Nullable
    public AnAction getAction(@NotNull String id2) {
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(38);
        }
        return this.getActionImpl(id2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AnAction getActionImpl(@NotNull String id2, boolean canReturnStub) {
        AnAction converted;
        AnAction action2;
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(39);
        }
        Object object = this.myLock;
        synchronized (object) {
            action2 = this.myId2Action.get(id2);
            if (canReturnStub || !(action2 instanceof ActionStubBase)) {
                return action2;
            }
        }
        AnAction anAction = converted = action2 instanceof ActionStub ? ActionManagerImpl.convertStub((ActionStub)action2) : ActionManagerImpl.convertGroupStub((ActionGroupStub)action2, this);
        if (converted == null) {
            this.unregisterAction(id2);
            return null;
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            action2 = this.myId2Action.get(id2);
            if (action2 instanceof ActionStubBase) {
                action2 = this.replaceStub((ActionStubBase)((Object)action2), converted);
            }
            return action2;
        }
    }

    @NotNull
    private AnAction replaceStub(@NotNull ActionStubBase stub, AnAction anAction) {
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(40);
        }
        LOG.assertTrue(this.myAction2Id.containsKey(stub));
        this.myAction2Id.remove(stub);
        LOG.assertTrue(this.myId2Action.containsKey(stub.getId()));
        AnAction action2 = this.myId2Action.remove(stub.getId());
        LOG.assertTrue(action2 != null);
        LOG.assertTrue(action2.equals(stub));
        this.myAction2Id.put(anAction, stub.getId());
        AnAction anAction2 = this.addToMap(stub.getId(), anAction, stub.getPlugin().getPluginId(), stub instanceof ActionStub ? ((ActionStub)stub).getProjectType() : null);
        if (anAction2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(41);
        }
        return anAction2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getId(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(42);
        }
        if (action2 instanceof ActionStubBase) {
            return ((ActionStubBase)((Object)action2)).getId();
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myAction2Id.get(action2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public String @NotNull [] getActionIds(@NotNull String idPrefix) {
        if (idPrefix == null) {
            ActionManagerImpl.$$$reportNull$$$0(43);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        ArrayList<String> idList = new ArrayList<String>();
        Iterator<String> iterator2 = this.myId2Action.keySet().iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                String[] stringArray = ArrayUtilRt.toStringArray(idList);
                // MONITOREXIT : object
                if (stringArray != null) return stringArray;
                ActionManagerImpl.$$$reportNull$$$0(44);
                return stringArray;
            }
            String id2 = iterator2.next();
            if (!id2.startsWith(idPrefix)) continue;
            idList.add(id2);
        }
    }

    @Override
    public boolean isGroup(@NotNull String actionId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(45);
        }
        return this.getActionImpl(actionId, true) instanceof ActionGroup;
    }

    @Override
    @NotNull
    public JComponent createButtonToolbar(@NotNull String actionPlace, @NotNull ActionGroup messageActionGroup) {
        if (actionPlace == null) {
            ActionManagerImpl.$$$reportNull$$$0(46);
        }
        if (messageActionGroup == null) {
            ActionManagerImpl.$$$reportNull$$$0(47);
        }
        return new ButtonToolbarImpl(actionPlace, messageActionGroup);
    }

    @Override
    public AnAction getActionOrStub(@NotNull String id2) {
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(48);
        }
        return this.getActionImpl(id2, true);
    }

    @Nullable
    private AnAction processActionElement(@NotNull Element element2, @NotNull IdeaPluginDescriptorImpl plugin, @Nullable ResourceBundle bundle) {
        String className;
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(49);
        }
        if (plugin == null) {
            ActionManagerImpl.$$$reportNull$$$0(50);
        }
        if ((className = element2.getAttributeValue(CLASS_ATTR_NAME)) == null || className.isEmpty()) {
            ActionManagerImpl.reportActionError(plugin.getPluginId(), "action element should have specified \"class\" attribute");
            return null;
        }
        String id2 = ActionManagerImpl.obtainActionId(element2, className);
        if (Boolean.parseBoolean(element2.getAttributeValue(INTERNAL_ATTR_NAME)) && !ApplicationManager.getApplication().isInternal()) {
            this.myNotRegisteredInternalActionIds.add(id2);
            return null;
        }
        String iconPath = element2.getAttributeValue(ICON_ATTR_NAME);
        String projectType = element2.getAttributeValue(PROJECT_TYPE);
        String textValue = element2.getAttributeValue(TEXT_ATTR_NAME);
        String descriptionValue = element2.getAttributeValue(DESCRIPTION);
        ActionStub stub = new ActionStub(className, id2, plugin, iconPath, projectType, () -> {
            String text2 = ActionManagerImpl.computeActionText(bundle, id2, ACTION_ELEMENT_NAME, textValue);
            if (text2 == null) {
                ActionManagerImpl.reportActionError(plugin.getPluginId(), "'text' attribute is mandatory (action ID=" + id2 + ";" + " plugin path: " + plugin.getPath() + ")");
            }
            Presentation presentation = new Presentation();
            presentation.setText(text2);
            presentation.setDescription(ActionManagerImpl.computeDescription(bundle, id2, ACTION_ELEMENT_NAME, descriptionValue));
            return presentation;
        });
        KeymapManagerEx keymapManager2 = KeymapManagerEx.getInstanceEx();
        for (Element e : element2.getChildren()) {
            if (ADD_TO_GROUP_ELEMENT_NAME.equals(e.getName())) {
                this.processAddToGroupNode(stub, e, plugin.getPluginId(), ActionManagerImpl.isSecondary(e));
                continue;
            }
            if (SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processKeyboardShortcutNode(e, id2, plugin.getPluginId(), keymapManager2);
                continue;
            }
            if (MOUSE_SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processMouseShortcutNode(e, id2, plugin.getPluginId(), keymapManager2);
                continue;
            }
            if (ABBREVIATION_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processAbbreviationNode(e, id2);
                continue;
            }
            if (OVERRIDE_TEXT_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processOverrideTextNode(stub, e, plugin.getPluginId(), bundle);
                continue;
            }
            ActionManagerImpl.reportActionError(plugin.getPluginId(), "unexpected name of element \"" + e.getName() + "\"");
            return null;
        }
        String shortcutOfActionId = element2.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME);
        if (shortcutOfActionId != null) {
            keymapManager2.bindShortcuts(shortcutOfActionId, id2);
        }
        this.registerOrReplaceActionInner(element2, id2, stub, plugin);
        return stub;
    }

    private static String obtainActionId(Element element2, String className) {
        String id2 = element2.getAttributeValue(ID_ATTR_NAME);
        return StringUtil.isEmpty(id2) ? StringUtil.getShortName(className) : id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOrReplaceActionInner(@NotNull Element element2, @NotNull String id2, @NotNull AnAction action2, @NotNull IdeaPluginDescriptor plugin) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(51);
        }
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(52);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(53);
        }
        if (plugin == null) {
            ActionManagerImpl.$$$reportNull$$$0(54);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (Boolean.parseBoolean(element2.getAttributeValue(OVERRIDES_ATTR_NAME))) {
                if (this.getActionOrStub(id2) == null) {
                    LOG.error(element2.getName() + " '" + id2 + "' doesn't override anything");
                    return;
                }
                AnAction prev = this.replaceAction(id2, action2, plugin.getPluginId());
                if (action2 instanceof DefaultActionGroup && prev instanceof DefaultActionGroup && Boolean.parseBoolean(element2.getAttributeValue(KEEP_CONTENT_ATTR_NAME))) {
                    ((DefaultActionGroup)action2).copyFromGroup((DefaultActionGroup)prev);
                }
            } else {
                this.registerAction(id2, action2, plugin.getPluginId(), element2.getAttributeValue(PROJECT_TYPE));
            }
            ActionsCollectorImpl.onActionLoadedFromXml(action2, id2, plugin);
        }
    }

    private AnAction processGroupElement(@NotNull Element element2, @NotNull IdeaPluginDescriptorImpl plugin, @Nullable ResourceBundle bundle) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(55);
        }
        if (plugin == null) {
            ActionManagerImpl.$$$reportNull$$$0(56);
        }
        if (!GROUP_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(plugin.getPluginId(), "unexpected name of element \"" + element2.getName() + "\"");
            return null;
        }
        String className = element2.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null) {
            className = "true".equals(element2.getAttributeValue(COMPACT_ATTR_NAME)) ? DefaultCompactActionGroup.class.getName() : DefaultActionGroup.class.getName();
        }
        try {
            String description;
            ActionGroup group;
            String id2 = element2.getAttributeValue(ID_ATTR_NAME);
            if (id2 != null && id2.isEmpty()) {
                ActionManagerImpl.reportActionError(plugin.getPluginId(), "ID of the group cannot be an empty string");
                return null;
            }
            boolean customClass = false;
            if (DefaultActionGroup.class.getName().equals(className)) {
                group = new DefaultActionGroup();
            } else if (DefaultCompactActionGroup.class.getName().equals(className)) {
                group = new DefaultCompactActionGroup();
            } else if (id2 == null) {
                Class<?> aClass = Class.forName(className, true, plugin.getPluginClassLoader());
                Object obj = new CachingConstructorInjectionComponentAdapter(className, aClass).getComponentInstance(ApplicationManager.getApplication().getPicoContainer());
                if (!(obj instanceof ActionGroup)) {
                    ActionManagerImpl.reportActionError(plugin.getPluginId(), "class with name \"" + className + "\" should be instance of " + ActionGroup.class.getName());
                    return null;
                }
                if (element2.getChildren().size() != element2.getChildren(ADD_TO_GROUP_ELEMENT_NAME).size() && !(obj instanceof DefaultActionGroup)) {
                    ActionManagerImpl.reportActionError(plugin.getPluginId(), "class with name \"" + className + "\" should be instance of " + DefaultActionGroup.class.getName() + " because there are children specified");
                    return null;
                }
                customClass = true;
                group = (ActionGroup)obj;
            } else {
                group = new ActionGroupStub(id2, className, plugin);
                customClass = true;
            }
            if (Boolean.parseBoolean(element2.getAttributeValue(INTERNAL_ATTR_NAME)) && !ApplicationManager.getApplication().isInternal()) {
                this.myNotRegisteredInternalActionIds.add(id2);
                return null;
            }
            if (id2 == null) {
                id2 = "<anonymous-group-" + this.myAnonymousGroupIdCounter++ + ">";
            }
            this.registerOrReplaceActionInner(element2, id2, group, plugin);
            Presentation presentation = group.getTemplatePresentation();
            String text2 = ActionManagerImpl.computeActionText(bundle, id2, GROUP_ELEMENT_NAME, element2.getAttributeValue(TEXT_ATTR_NAME));
            if (!StringUtil.isEmpty(text2) || presentation.getText() == null) {
                presentation.setText(text2);
            }
            if (!StringUtil.isEmpty(description = ActionManagerImpl.computeDescription(bundle, id2, GROUP_ELEMENT_NAME, element2.getAttributeValue(DESCRIPTION))) || presentation.getDescription() == null) {
                presentation.setDescription(description);
            }
            String iconPath = element2.getAttributeValue(ICON_ATTR_NAME);
            if (group instanceof ActionGroupStub) {
                ((ActionGroupStub)group).setIconPath(iconPath);
            } else {
                ActionManagerImpl.setIcon(iconPath, className, plugin, presentation);
            }
            String popup2 = element2.getAttributeValue(POPUP_ATTR_NAME);
            if (popup2 != null) {
                group.setPopup(Boolean.parseBoolean(popup2));
                if (group instanceof ActionGroupStub) {
                    ((ActionGroupStub)group).setPopupDefinedInXml(true);
                }
            }
            String shortcutOfActionId = element2.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME);
            if (customClass && shortcutOfActionId != null) {
                KeymapManagerEx.getInstanceEx().bindShortcuts(shortcutOfActionId, id2);
            }
            for (Element child2 : element2.getChildren()) {
                AnAction action2;
                String name = child2.getName();
                if (ACTION_ELEMENT_NAME.equals(name)) {
                    action2 = this.processActionElement(child2, plugin, bundle);
                    if (action2 == null) continue;
                    this.assertActionIsGroupOrStub(action2);
                    this.addToGroupInner(group, action2, Constraints.LAST, ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                if (SEPARATOR_ELEMENT_NAME.equals(name)) {
                    this.processSeparatorNode((DefaultActionGroup)group, child2, plugin.getPluginId());
                    continue;
                }
                if (GROUP_ELEMENT_NAME.equals(name)) {
                    action2 = this.processGroupElement(child2, plugin, bundle);
                    if (action2 == null) continue;
                    this.addToGroupInner(group, action2, Constraints.LAST, false);
                    continue;
                }
                if (ADD_TO_GROUP_ELEMENT_NAME.equals(name)) {
                    this.processAddToGroupNode(group, child2, plugin.getPluginId(), ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                if (REFERENCE_ELEMENT_NAME.equals(name)) {
                    action2 = this.processReferenceElement(child2, plugin.getPluginId());
                    if (action2 == null) continue;
                    this.assertActionIsGroupOrStub(action2);
                    this.addToGroupInner(group, action2, Constraints.LAST, ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                ActionManagerImpl.reportActionError(plugin.getPluginId(), "unexpected name of element \"" + name + "\n");
                return null;
            }
            return group;
        }
        catch (Exception e) {
            String message = "cannot create class \"" + className + "\"";
            ActionManagerImpl.reportActionError(plugin.getPluginId(), message, e);
            return null;
        }
    }

    private void processReferenceNode(Element element2, PluginId pluginId, boolean initialStartup) {
        AnAction action2 = this.processReferenceElement(element2, pluginId);
        if (action2 == null) {
            return;
        }
        if (initialStartup) {
            this.assertActionIsGroupOrStub(action2);
        }
        for (Element child2 : element2.getChildren()) {
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child2.getName())) continue;
            this.processAddToGroupNode(action2, child2, pluginId, ActionManagerImpl.isSecondary(child2));
        }
    }

    private void processAddToGroupNode(AnAction action2, Element element2, PluginId pluginId, boolean secondary) {
        if (!(action2 instanceof Separator)) {
            this.assertActionIsGroupOrStub(action2);
        }
        String name = action2 instanceof ActionStub ? ((ActionStub)action2).getClassName() : action2.getClass().getName();
        String id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : this.myAction2Id.get(action2);
        String actionName = name + " (" + id2 + ")";
        if (!ADD_TO_GROUP_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"");
            return;
        }
        DefaultActionGroup parentGroup = this.getParentGroup(element2.getAttributeValue(GROUPID_ATTR_NAME), actionName, pluginId);
        if (parentGroup == null) {
            return;
        }
        Anchor anchor2 = ActionManagerImpl.parseAnchor(element2.getAttributeValue(ANCHOR_ELEMENT_NAME), actionName, pluginId);
        if (anchor2 == null) {
            return;
        }
        String relativeToActionId = element2.getAttributeValue(RELATIVE_TO_ACTION_ATTR_NAME);
        if (!ActionManagerImpl.checkRelativeToAction(relativeToActionId, anchor2, actionName, pluginId)) {
            return;
        }
        this.addToGroupInner(parentGroup, action2, new Constraints(anchor2, relativeToActionId), secondary);
    }

    private void addToGroupInner(AnAction group, AnAction action2, Constraints constraints, boolean secondary) {
        String actionId = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : this.myAction2Id.get(action2);
        ((DefaultActionGroup)group).addAction(action2, constraints, this).setAsSecondary(secondary);
        this.myId2GroupId.putValue(actionId, this.myAction2Id.get(group));
    }

    @Nullable
    public DefaultActionGroup getParentGroup(String groupId2, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (groupId2 == null || groupId2.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": attribute \"group-id\" should be defined");
            return null;
        }
        AnAction parentGroup = this.getActionImpl(groupId2, true);
        if (parentGroup == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId2 + "\" isn't registered; action will be added to the \"Other\" group");
            parentGroup = this.getActionImpl("OtherMenu", true);
        }
        if (!(parentGroup instanceof DefaultActionGroup)) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId2 + "\" should be instance of " + DefaultActionGroup.class.getName() + " but was " + (parentGroup != null ? parentGroup.getClass() : "[null]"));
            return null;
        }
        return (DefaultActionGroup)parentGroup;
    }

    private static void processOverrideTextNode(ActionStub stub, Element element2, PluginId pluginId, @Nullable ResourceBundle bundle) {
        if (!OVERRIDE_TEXT_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"");
            return;
        }
        String place = element2.getAttributeValue(PLACE_ATTR_NAME);
        if (place == null) {
            ActionManagerImpl.reportActionError(pluginId, stub.getId() + ": override-text specified without place");
            return;
        }
        String useTextOfPlace = element2.getAttributeValue(USE_TEXT_OF_PLACE_ATTR_NAME);
        if (useTextOfPlace != null) {
            stub.copyActionTextOverride(useTextOfPlace, place);
        } else {
            String text2 = element2.getAttributeValue(TEXT_ATTR_NAME, "");
            if (text2.isEmpty() && bundle != null) {
                String key = "action." + stub.getId() + "." + place + ".text";
                text2 = BundleBase.message(bundle, key, new Object[0]);
            }
            stub.addActionTextOverride(place, text2);
        }
    }

    private void processSeparatorNode(@Nullable DefaultActionGroup parentGroup, Element element2, PluginId pluginId) {
        Separator separator;
        if (!SEPARATOR_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"");
            return;
        }
        String text2 = element2.getAttributeValue(TEXT_ATTR_NAME);
        Separator separator2 = separator = text2 != null ? new Separator(text2) : Separator.getInstance();
        if (parentGroup != null) {
            parentGroup.add((AnAction)separator, this);
        }
        for (Element child2 : element2.getChildren()) {
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child2.getName())) continue;
            this.processAddToGroupNode(separator, child2, pluginId, ActionManagerImpl.isSecondary(child2));
        }
    }

    private void processUnregisterNode(Element element2, PluginId pluginId) {
        String id2 = element2.getAttributeValue(ID_ATTR_NAME);
        if (id2 == null) {
            ActionManagerImpl.reportActionError(pluginId, "'id' attribute is required for 'unregister' elements");
            return;
        }
        AnAction action2 = this.getAction(id2);
        if (action2 == null) {
            ActionManagerImpl.reportActionError(pluginId, "Trying to unregister non-existing action " + id2);
            return;
        }
        AbbreviationManager.getInstance().removeAllAbbreviations(id2);
        this.unregisterAction(id2);
    }

    private static void processKeyboardShortcutNode(Element element2, String actionId, PluginId pluginId, @NotNull KeymapManagerEx keymapManager2) {
        String firstStrokeString;
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(57);
        }
        if ((firstStrokeString = element2.getAttributeValue(FIRST_KEYSTROKE_ATTR_NAME)) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        KeyStroke firstKeyStroke = ActionManagerImpl.getKeyStroke(firstStrokeString);
        if (firstKeyStroke == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        KeyStroke secondKeyStroke = null;
        String secondStrokeString = element2.getAttributeValue(SECOND_KEYSTROKE_ATTR_NAME);
        if (secondStrokeString != null && (secondKeyStroke = ActionManagerImpl.getKeyStroke(secondStrokeString)) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"second-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element2.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap2 = keymapManager2.getKeymap(keymapName);
        if (keymap2 == null) {
            ActionManagerImpl.reportKeymapNotFoundWarning(pluginId, keymapName);
            return;
        }
        KeyboardShortcut shortcut = new KeyboardShortcut(firstKeyStroke, secondKeyStroke);
        ActionManagerImpl.processRemoveAndReplace(element2, actionId, keymap2, shortcut);
    }

    private static void processRemoveAndReplace(@NotNull Element element2, String actionId, @NotNull Keymap keymap2, @NotNull Shortcut shortcut) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(58);
        }
        if (keymap2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(59);
        }
        if (shortcut == null) {
            ActionManagerImpl.$$$reportNull$$$0(60);
        }
        boolean remove2 = Boolean.parseBoolean(element2.getAttributeValue(REMOVE_SHORTCUT_ATTR_NAME));
        boolean replace = Boolean.parseBoolean(element2.getAttributeValue(REPLACE_SHORTCUT_ATTR_NAME));
        if (remove2) {
            keymap2.removeShortcut(actionId, shortcut);
        }
        if (replace) {
            keymap2.removeAllActionShortcuts(actionId);
        }
        if (!remove2) {
            keymap2.addShortcut(actionId, shortcut);
        }
    }

    @Nullable
    private AnAction processReferenceElement(Element element2, PluginId pluginId) {
        if (!REFERENCE_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"");
            return null;
        }
        String ref = ActionManagerImpl.getReferenceActionId(element2);
        if (ref == null || ref.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "ID of reference element should be defined");
            return null;
        }
        AnAction action2 = this.getActionImpl(ref, true);
        if (action2 == null) {
            if (!this.myNotRegisteredInternalActionIds.contains(ref)) {
                ActionManagerImpl.reportActionError(pluginId, "action specified by reference isn't registered (ID=" + ref + ")");
            }
            return null;
        }
        return action2;
    }

    private static String getReferenceActionId(@NotNull Element element2) {
        String ref;
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(61);
        }
        if ((ref = element2.getAttributeValue(REF_ATTR_NAME)) == null) {
            ref = element2.getAttributeValue(ID_ATTR_NAME);
        }
        return ref;
    }

    private void processActionsChildElement(@NotNull Element child2, @NotNull IdeaPluginDescriptorImpl plugin, @Nullable ResourceBundle bundle, boolean initialStartup) {
        String name;
        if (child2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(62);
        }
        if (plugin == null) {
            ActionManagerImpl.$$$reportNull$$$0(63);
        }
        if (ACTION_ELEMENT_NAME.equals(name = child2.getName())) {
            AnAction action2 = this.processActionElement(child2, plugin, bundle);
            if (action2 != null) {
                this.assertActionIsGroupOrStub(action2);
            }
        } else if (GROUP_ELEMENT_NAME.equals(name)) {
            this.processGroupElement(child2, plugin, bundle);
        } else if (SEPARATOR_ELEMENT_NAME.equals(name)) {
            this.processSeparatorNode(null, child2, plugin.getPluginId());
        } else if (REFERENCE_ELEMENT_NAME.equals(name)) {
            this.processReferenceNode(child2, plugin.getPluginId(), initialStartup);
        } else if (UNREGISTER_ELEMENT_NAME.equals(name)) {
            this.processUnregisterNode(child2, plugin.getPluginId());
        } else {
            ActionManagerImpl.reportActionError(plugin.getPluginId(), "unexpected name of element \"" + name + "\n");
        }
    }

    public boolean canUnloadActions(IdeaPluginDescriptor pluginDescriptor) {
        List<Element> elements2 = pluginDescriptor.getActionDescriptionElements();
        if (elements2 == null) {
            return true;
        }
        for (Element element2 : elements2) {
            if (element2.getName().equals(ACTION_ELEMENT_NAME) || element2.getName().equals(GROUP_ELEMENT_NAME) && ActionManagerImpl.canUnloadGroup(element2) || element2.getName().equals(REFERENCE_ELEMENT_NAME)) continue;
            LOG.info("Plugin " + pluginDescriptor.getPluginId() + " is not unload-safe because of action element " + element2.getName());
            return false;
        }
        return true;
    }

    private static boolean canUnloadGroup(@NotNull Element element2) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(64);
        }
        if (element2.getAttributeValue(ID_ATTR_NAME) == null) {
            return false;
        }
        for (Element child2 : element2.getChildren()) {
            if (!child2.getName().equals(GROUP_ELEMENT_NAME) || ActionManagerImpl.canUnloadGroup(child2)) continue;
            return false;
        }
        return true;
    }

    public void unloadActions(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        List<Element> elements2;
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(65);
        }
        if ((elements2 = pluginDescriptor.getActionDescriptionElements()) == null) {
            return;
        }
        for (Element element2 : ContainerUtil.reverse(elements2)) {
            switch (element2.getName()) {
                case "action": {
                    this.unloadActionElement(element2);
                    break;
                }
                case "group": {
                    this.unloadGroupElement(element2);
                    break;
                }
                case "reference": {
                    PluginId pluginId = pluginDescriptor.getPluginId();
                    AnAction action2 = this.processReferenceElement(element2, pluginId);
                    if (action2 == null) {
                        return;
                    }
                    String actionId = ActionManagerImpl.getReferenceActionId(element2);
                    for (Element child2 : element2.getChildren(ADD_TO_GROUP_ELEMENT_NAME)) {
                        String groupId2 = child2.getAttributeValue(GROUPID_ATTR_NAME);
                        DefaultActionGroup parentGroup = this.getParentGroup(groupId2, actionId, pluginId);
                        if (parentGroup == null) {
                            return;
                        }
                        parentGroup.remove(action2);
                        this.myId2GroupId.remove(actionId, groupId2);
                    }
                    break;
                }
            }
        }
    }

    private void unloadGroupElement(Element element2) {
        String id2 = element2.getAttributeValue(ID_ATTR_NAME);
        if (id2 == null) {
            throw new IllegalStateException("Cannot unload groups with no ID");
        }
        for (Element groupChild : element2.getChildren()) {
            if (groupChild.getName().equals(ACTION_ELEMENT_NAME)) {
                this.unloadActionElement(groupChild);
                continue;
            }
            if (!groupChild.getName().equals(GROUP_ELEMENT_NAME)) continue;
            this.unloadGroupElement(groupChild);
        }
        this.unregisterAction(id2);
    }

    private void unloadActionElement(@NotNull Element element2) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(66);
        }
        String className = element2.getAttributeValue(CLASS_ATTR_NAME);
        String id2 = ActionManagerImpl.obtainActionId(element2, className);
        this.unregisterAction(id2);
    }

    @Override
    public void registerAction(@NotNull String actionId, @NotNull AnAction action2, @Nullable PluginId pluginId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(67);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(68);
        }
        this.registerAction(actionId, action2, pluginId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAction(@NotNull String actionId, @NotNull AnAction action2, @Nullable PluginId pluginId, @Nullable String projectType) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(69);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(70);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.addToMap(actionId, action2, pluginId, projectType) == null) {
                return;
            }
            if (this.myAction2Id.containsKey(action2)) {
                ActionManagerImpl.reportActionError(pluginId, "action was already registered for another ID. ID is " + this.myAction2Id.get(action2) + ActionManagerImpl.getPluginInfo(pluginId));
                return;
            }
            this.myId2Index.put(actionId, this.myRegisteredActionsCount++);
            this.myAction2Id.put(action2, actionId);
            if (pluginId != null && !(action2 instanceof ActionGroup)) {
                this.myPlugin2Id.putValue(pluginId, actionId);
            }
            action2.registerCustomShortcutSet(new ProxyShortcutSet(actionId), null);
            ActionManagerImpl.notifyCustomActionsSchema(actionId);
        }
    }

    private static void notifyCustomActionsSchema(@NotNull String registeredID) {
        CustomActionsSchema schema;
        if (registeredID == null) {
            ActionManagerImpl.$$$reportNull$$$0(71);
        }
        if ((schema = ServiceManager.getServiceIfCreated(CustomActionsSchema.class)) == null) {
            return;
        }
        for (ActionUrl url : schema.getActions()) {
            if (!registeredID.equals(url.getComponent())) continue;
            schema.incrementModificationStamp();
            break;
        }
    }

    private AnAction addToMap(String actionId, AnAction action2, PluginId pluginId, String projectType) {
        if (projectType != null || this.myId2Action.containsKey(actionId)) {
            return this.registerChameleon(actionId, action2, pluginId, projectType);
        }
        this.myId2Action.put(actionId, action2);
        return action2;
    }

    private AnAction registerChameleon(String actionId, AnAction action2, PluginId pluginId, String projectType) {
        ChameleonAction chameleonAction;
        ProjectType type = projectType == null ? null : new ProjectType(projectType);
        AnAction o = this.myId2Action.get(actionId);
        if (o == null) {
            ChameleonAction chameleonAction2 = new ChameleonAction(action2, type);
            this.myId2Action.put(actionId, chameleonAction2);
            return chameleonAction2;
        }
        if (o instanceof ChameleonAction) {
            chameleonAction = (ChameleonAction)o;
        } else {
            chameleonAction = new ChameleonAction(o, type);
            this.myId2Action.put(actionId, chameleonAction);
        }
        AnAction old = chameleonAction.addAction(action2, type);
        if (old != null) {
            ActionManagerImpl.reportActionError(pluginId, "action with the ID \"" + actionId + "\" was already registered. Action being registered is " + action2 + "; Registered action is " + this.myId2Action.get(actionId) + ActionManagerImpl.getPluginInfo(pluginId));
            return null;
        }
        return chameleonAction;
    }

    @Override
    public void registerAction(@NotNull String actionId, @NotNull AnAction action2) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(72);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(73);
        }
        this.registerAction(actionId, action2, null);
    }

    @Override
    public void unregisterAction(@NotNull String actionId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(74);
        }
        this.unregisterAction(actionId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAction(@NotNull String actionId, boolean removeFromGroups) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(75);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myId2Action.containsKey(actionId)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("action with ID " + actionId + " wasn't registered");
                }
                return;
            }
            AnAction actionToRemove = this.myId2Action.remove(actionId);
            this.myAction2Id.remove(actionToRemove);
            this.myId2Index.remove(actionId);
            for (Map.Entry<PluginId, Collection<String>> entry : this.myPlugin2Id.entrySet()) {
                Collection<String> pluginActions = entry.getValue();
                pluginActions.remove(actionId);
            }
            if (removeFromGroups) {
                CustomActionsSchema customActionSchema = ApplicationManager.getApplication().getServiceIfCreated(CustomActionsSchema.class);
                for (String groupId2 : this.myId2GroupId.get(actionId)) {
                    if (customActionSchema != null) {
                        customActionSchema.invalidateCustomizedActionGroup(groupId2);
                    }
                    DefaultActionGroup group = Objects.requireNonNull((DefaultActionGroup)this.getActionOrStub(groupId2));
                    group.remove(actionToRemove, actionId);
                    if (group instanceof ActionGroupStub) continue;
                    for (String parentOfGroup : this.myId2GroupId.get(groupId2)) {
                        DefaultActionGroup parentOfGroupAction = Objects.requireNonNull((DefaultActionGroup)this.getActionOrStub(parentOfGroup));
                        for (AnAction stub : parentOfGroupAction.getChildActionsOrStubs()) {
                            if (!(stub instanceof ActionGroupStub) || ((ActionGroupStub)stub).getId() != groupId2) continue;
                            ((ActionGroupStub)stub).remove(actionToRemove, actionId);
                        }
                    }
                }
            }
            if (actionToRemove instanceof ActionGroup) {
                for (Map.Entry<Object, Collection<String>> entry : this.myId2GroupId.entrySet()) {
                    entry.getValue().remove(actionId);
                }
            }
        }
    }

    @Override
    @NotNull
    public Comparator<String> getRegistrationOrderComparator() {
        Comparator<String> comparator2 = Comparator.comparingInt(this.myId2Index::get);
        if (comparator2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(76);
        }
        return comparator2;
    }

    @Override
    public String @NotNull [] getPluginActions(@NotNull PluginId pluginName) {
        if (pluginName == null) {
            ActionManagerImpl.$$$reportNull$$$0(77);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(this.myPlugin2Id.get(pluginName));
        if (stringArray == null) {
            ActionManagerImpl.$$$reportNull$$$0(78);
        }
        return stringArray;
    }

    public void addActionPopup(@NotNull Object menu) {
        if (menu == null) {
            ActionManagerImpl.$$$reportNull$$$0(79);
        }
        this.myPopups.add(menu);
        if (menu instanceof ActionPopupMenu) {
            for (ActionPopupMenuListener listener2 : this.myActionPopupMenuListeners) {
                listener2.actionPopupMenuCreated((ActionPopupMenu)menu);
            }
        }
    }

    void removeActionPopup(@NotNull Object menu) {
        boolean removed;
        if (menu == null) {
            ActionManagerImpl.$$$reportNull$$$0(80);
        }
        if ((removed = this.myPopups.remove(menu)) && menu instanceof ActionPopupMenu) {
            for (ActionPopupMenuListener listener2 : this.myActionPopupMenuListeners) {
                listener2.actionPopupMenuReleased((ActionPopupMenu)menu);
            }
        }
    }

    @Override
    public void queueActionPerformedEvent(@NotNull AnAction action2, @NotNull DataContext context, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(81);
        }
        if (context == null) {
            ActionManagerImpl.$$$reportNull$$$0(82);
        }
        if (event == null) {
            ActionManagerImpl.$$$reportNull$$$0(83);
        }
        if (this.myPopups.isEmpty()) {
            this.fireAfterActionPerformed(action2, context, event);
        }
    }

    public boolean isToolWindowContextMenuVisible() {
        for (Object popup2 : this.myPopups) {
            if (!(popup2 instanceof ActionPopupMenuImpl) || !((ActionPopupMenuImpl)popup2).isToolWindowContextMenu()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActionPopupStackEmpty() {
        return this.myPopups.isEmpty();
    }

    @Override
    public boolean isTransparentOnlyActionsUpdateNow() {
        return this.myTransparentOnlyUpdate;
    }

    @Override
    public void addActionPopupMenuListener(@NotNull ActionPopupMenuListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(84);
        }
        if (parentDisposable == null) {
            ActionManagerImpl.$$$reportNull$$$0(85);
        }
        this.myActionPopupMenuListeners.add(listener2);
        Disposer.register(parentDisposable, () -> this.myActionPopupMenuListeners.remove(listener2));
    }

    @Override
    public void replaceAction(@NotNull String actionId, @NotNull AnAction newAction) {
        Class<?> callerClass;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(86);
        }
        if (newAction == null) {
            ActionManagerImpl.$$$reportNull$$$0(87);
        }
        PluginId pluginId = (callerClass = ReflectionUtil.getGrandCallerClass()) != null ? PluginManagerCore.getPluginByClassName(callerClass.getName()) : null;
        this.replaceAction(actionId, newAction, pluginId);
    }

    private AnAction replaceAction(@NotNull String actionId, @NotNull AnAction newAction, @Nullable PluginId pluginId) {
        AnAction oldAction;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(88);
        }
        if (newAction == null) {
            ActionManagerImpl.$$$reportNull$$$0(89);
        }
        AnAction anAction = oldAction = newAction instanceof OverridingAction ? this.getAction(actionId) : this.getActionOrStub(actionId);
        if (oldAction != null) {
            boolean isGroup;
            if (newAction instanceof OverridingAction) {
                this.myBaseActions.put((OverridingAction)((Object)newAction), oldAction);
            }
            if ((isGroup = oldAction instanceof ActionGroup) != newAction instanceof ActionGroup) {
                throw new IllegalStateException("cannot replace a group with an action and vice versa: " + actionId);
            }
            for (String groupId2 : this.myId2GroupId.get(actionId)) {
                DefaultActionGroup group = (DefaultActionGroup)this.getActionOrStub(groupId2);
                if (group == null) {
                    throw new IllegalStateException("Trying to replace action which has been added to a non-existing group " + groupId2);
                }
                group.replaceAction(oldAction, newAction);
            }
            this.unregisterAction(actionId, false);
        }
        this.registerAction(actionId, newAction, pluginId);
        return oldAction;
    }

    public AnAction getBaseAction(OverridingAction overridingAction) {
        return this.myBaseActions.get(overridingAction);
    }

    @Override
    public void addAnActionListener(AnActionListener listener2) {
        this.myActionListeners.add(listener2);
    }

    @Override
    public void removeAnActionListener(AnActionListener listener2) {
        this.myActionListeners.remove(listener2);
    }

    @Override
    public void fireBeforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(90);
        }
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(91);
        }
        if (event == null) {
            ActionManagerImpl.$$$reportNull$$$0(92);
        }
        this.myPrevPerformedActionId = this.myLastPreformedActionId;
        this.myLastPreformedActionId = this.getId(action2);
        if (this.myLastPreformedActionId == null && action2 instanceof ActionIdProvider) {
            this.myLastPreformedActionId = ((ActionIdProvider)((Object)action2)).getId();
        }
        IdeaLogger.ourLastActionId = this.myLastPreformedActionId;
        PsiFile file2 = CommonDataKeys.PSI_FILE.getData(dataContext);
        Language language2 = file2 != null ? file2.getLanguage() : null;
        ActionsCollectorImpl.recordActionInvoked(CommonDataKeys.PROJECT.getData(dataContext), action2, event, featureUsageData -> {
            if (language2 != null) {
                featureUsageData.addCurrentFile(language2);
            }
            if (action2 instanceof FusAwareAction) {
                ((FusAwareAction)((Object)action2)).addAdditionalUsageData(event, (FeatureUsageData)featureUsageData);
            }
        });
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeActionPerformed(action2, dataContext, event);
        }
        ActionManagerImpl.publisher().beforeActionPerformed(action2, dataContext, event);
    }

    @Override
    public void fireAfterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(93);
        }
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(94);
        }
        if (event == null) {
            ActionManagerImpl.$$$reportNull$$$0(95);
        }
        this.myPrevPerformedActionId = this.myLastPreformedActionId;
        IdeaLogger.ourLastActionId = this.myLastPreformedActionId = this.getId(action2);
        for (AnActionListener listener2 : this.myActionListeners) {
            try {
                listener2.afterActionPerformed(action2, dataContext, event);
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
        ActionManagerImpl.publisher().afterActionPerformed(action2, dataContext, event);
    }

    @Override
    public KeyboardShortcut getKeyboardShortcut(@NotNull String actionId) {
        Shortcut[] shortcuts;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(96);
        }
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        ShortcutSet shortcutSet = action2.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyboardShortcut kb;
            if (!(shortcut instanceof KeyboardShortcut) || (kb = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            return (KeyboardShortcut)shortcut;
        }
        return null;
    }

    @Override
    public void fireBeforeEditorTyping(char c, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(97);
        }
        this.myLastTimeEditorWasTypedIn = System.currentTimeMillis();
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeEditorTyping(c, dataContext);
        }
        ActionManagerImpl.publisher().beforeEditorTyping(c, dataContext);
    }

    @Override
    public String getLastPreformedActionId() {
        return this.myLastPreformedActionId;
    }

    @Override
    public String getPrevPreformedActionId() {
        return this.myPrevPerformedActionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<String> getActionIds() {
        Object object = this.myLock;
        // MONITORENTER : object
        HashSet<String> hashSet = new HashSet<String>(this.myId2Action.keySet());
        // MONITOREXIT : object
        if (hashSet != null) return hashSet;
        ActionManagerImpl.$$$reportNull$$$0(98);
        return hashSet;
    }

    public void preloadActions(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ActionManagerImpl.$$$reportNull$$$0(99);
        }
        Application application = ApplicationManager.getApplication();
        for (String id2 : this.getActionIds()) {
            indicator.checkCanceled();
            if (application.isDisposed()) {
                return;
            }
            AnAction action2 = this.getAction(id2);
            if (!(action2 instanceof PreloadableAction)) continue;
            ((PreloadableAction)((Object)action2)).preload();
        }
        this.myPreloadComplete = true;
    }

    @Override
    @NotNull
    public ActionCallback tryToExecute(@NotNull AnAction action2, @NotNull InputEvent inputEvent, @Nullable Component contextComponent, @Nullable String place, boolean now) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(100);
        }
        if (inputEvent == null) {
            ActionManagerImpl.$$$reportNull$$$0(101);
        }
        assert (ApplicationManager.getApplication().isDispatchThread());
        ActionCallback result2 = new ActionCallback();
        Runnable doRunnable = () -> this.tryToExecuteNow(action2, inputEvent, contextComponent, place, result2);
        if (now) {
            doRunnable.run();
        } else {
            SwingUtilities.invokeLater(doRunnable);
        }
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            ActionManagerImpl.$$$reportNull$$$0(102);
        }
        return actionCallback;
    }

    private void tryToExecuteNow(@NotNull AnAction action2, @NotNull InputEvent inputEvent, @Nullable Component contextComponent, String place, ActionCallback result2) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(103);
        }
        if (inputEvent == null) {
            ActionManagerImpl.$$$reportNull$$$0(104);
        }
        Presentation presentation = action2.getTemplatePresentation().clone();
        IdeFocusManager.findInstanceByContext(ActionManagerImpl.getContextBy(contextComponent)).doWhenFocusSettlesDown(() -> ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> {
            DataContext context = ActionManagerImpl.getContextBy(contextComponent);
            AnActionEvent event = new AnActionEvent(inputEvent, context, place != null ? place : "unknown", presentation, this, inputEvent.getModifiersEx());
            ActionUtil.performDumbAwareUpdate(LaterInvocator.isInModalContext(), action2, event, false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            ActionUtil.lastUpdateAndCheckDumb(action2, event, false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            Component component2 = PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
            if (component2 != null && !component2.isShowing() && !"TouchBarGeneral".equals(place)) {
                result2.setRejected();
                return;
            }
            this.fireBeforeActionPerformed(action2, context, event);
            UIUtil.addAwtListener(event1 -> {
                if (!(event1.getID() != 200 && event1.getID() != 205 || result2.isProcessed())) {
                    WindowEvent we = (WindowEvent)event1;
                    IdeFocusManager.findInstanceByComponent(we.getWindow()).doWhenFocusSettlesDown(result2.createSetDoneRunnable(), ModalityState.defaultModalityState());
                }
            }, 64L, result2);
            ActionUtil.performActionDumbAware(action2, event);
            result2.setDone();
            this.queueActionPerformedEvent(action2, context, event);
        }), ModalityState.defaultModalityState());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubClassName";
                break;
            }
            case 3: 
            case 11: 
            case 14: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: 
            case 38: 
            case 39: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = ID_ATTR_NAME;
                break;
            }
            case 9: 
            case 37: 
            case 50: 
            case 54: 
            case 56: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = ANCHOR_ELEMENT_NAME;
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 19: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapManager";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapName";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = PLACE_ATTR_NAME;
                break;
            }
            case 29: 
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = GROUP_ELEMENT_NAME;
                break;
            }
            case 42: 
            case 53: 
            case 68: 
            case 70: 
            case 73: 
            case 81: 
            case 90: 
            case 93: 
            case 100: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = ACTION_ELEMENT_NAME;
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idPrefix";
                break;
            }
            case 45: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 75: 
            case 86: 
            case 88: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionPlace";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageActionGroup";
                break;
            }
            case 49: 
            case 51: 
            case 55: 
            case 58: 
            case 61: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEYMAP_ATTR_NAME;
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registeredID";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginName";
                break;
            }
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "menu";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 83: 
            case 92: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 87: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAction";
                break;
            }
            case 91: 
            case 94: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 101: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "publisher";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextBy";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceStub";
                break;
            }
            case 44: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIds";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrationOrderComparator";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginActions";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToExecute";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateIconFromStub";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertGroupStub";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processAbbreviationNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getActionsResourceBundle";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setIcon";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setIconFromClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkRelativeToAction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processMouseShortcutNode";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reportActionError";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reportKeymapNotFoundWarning";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addTimerListener";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeTimerListener";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addTransparentTimerListener";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeTransparentTimerListener";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopupMenu";
                break;
            }
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "registerPluginActions";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getActionImpl";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "replaceStub";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getActionIds";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isGroup";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createButtonToolbar";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getActionOrStub";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processActionElement";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "registerOrReplaceActionInner";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "processGroupElement";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processKeyboardShortcutNode";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processRemoveAndReplace";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceActionId";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "processActionsChildElement";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "canUnloadGroup";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "unloadActions";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "unloadActionElement";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "notifyCustomActionsSchema";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAction";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getPluginActions";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addActionPopup";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "removeActionPopup";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "queueActionPerformedEvent";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "addActionPopupMenuListener";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "replaceAction";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeActionPerformed";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterActionPerformed";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getKeyboardShortcut";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeEditorTyping";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "preloadActions";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "tryToExecute";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "tryToExecuteNow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTimer
    extends Timer
    implements ActionListener {
        private final List<TimerListener> myTimerListeners;
        private final List<TimerListener> myTransparentTimerListeners;
        private int myLastTimePerformed;

        private MyTimer() {
            super(500, null);
            this.myTimerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.myTransparentTimerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.addActionListener(this);
            this.setRepeats(true);
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            connection.subscribe(ApplicationActivationListener.TOPIC, new ApplicationActivationListener(){

                @Override
                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyTimer.this.setDelay(500);
                    MyTimer.this.restart();
                }

                @Override
                public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    MyTimer.this.setDelay(5000);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "ideFrame";
                    objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl$MyTimer$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applicationActivated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applicationDeactivated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public String toString() {
            return "Action manager timer";
        }

        void addTimerListener(@NotNull TimerListener listener2, boolean transparent) {
            if (listener2 == null) {
                MyTimer.$$$reportNull$$$0(0);
            }
            (transparent ? this.myTransparentTimerListeners : this.myTimerListeners).add(listener2);
        }

        void removeTimerListener(@NotNull TimerListener listener2, boolean transparent) {
            if (listener2 == null) {
                MyTimer.$$$reportNull$$$0(1);
            }
            (transparent ? this.myTransparentTimerListeners : this.myTimerListeners).remove(listener2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (ActionManagerImpl.this.myLastTimeEditorWasTypedIn + 500L > System.currentTimeMillis()) {
                return;
            }
            int lastEventCount = this.myLastTimePerformed;
            this.myLastTimePerformed = ActivityTracker.getInstance().getCount();
            if (this.myLastTimePerformed == lastEventCount && !Registry.is("actionSystem.always.update.toolbar.actions")) {
                return;
            }
            boolean transparentOnly = this.myLastTimePerformed == lastEventCount;
            try {
                ActionManagerImpl.this.myTransparentOnlyUpdate = transparentOnly;
                HashSet notified = new HashSet();
                this.notifyListeners(this.myTransparentTimerListeners, notified);
                if (transparentOnly) {
                    return;
                }
                this.notifyListeners(this.myTimerListeners, notified);
            }
            finally {
                ActionManagerImpl.this.myTransparentOnlyUpdate = false;
            }
        }

        private void notifyListeners(List<? extends TimerListener> timerListeners, Set<? super TimerListener> notified) {
            for (TimerListener timerListener : timerListeners) {
                if (!notified.add(timerListener)) continue;
                this.runListenerAction(timerListener);
            }
        }

        private void runListenerAction(@NotNull TimerListener listener2) {
            ModalityState modalityState;
            if (listener2 == null) {
                MyTimer.$$$reportNull$$$0(2);
            }
            if ((modalityState = listener2.getModalityState()) == null) {
                return;
            }
            LOG.debug("notify ", listener2);
            if (!ModalityState.current().dominates(modalityState)) {
                try {
                    listener2.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "listener";
            objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl$MyTimer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addTimerListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeTimerListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runListenerAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

