/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.actionSystem.BackgroundableDataProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionUpdateEdtExecutor;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class AsyncDataContext
extends DataManagerImpl.MyDataContext {
    private static final Logger LOG = Logger.getInstance(AsyncDataContext.class);
    private final List<WeakReference<Component>> myHierarchy;
    private final Map<Component, DataProvider> myProviders = ConcurrentFactoryMap.create(key -> ActionUpdateEdtExecutor.computeOnEdt(() -> {
        DataProvider provider = DataManagerImpl.getDataProviderEx(key);
        if (provider == null) {
            return null;
        }
        if (provider instanceof BackgroundableDataProvider) {
            return ((BackgroundableDataProvider)provider).createBackgroundDataProvider();
        }
        return dataKey -> {
            boolean bg = !ApplicationManager.getApplication().isDispatchThread();
            return ActionUpdateEdtExecutor.computeOnEdt(() -> {
                long start2 = System.currentTimeMillis();
                try {
                    Object object = provider.getData(dataKey);
                    return object;
                }
                finally {
                    long elapsed = System.currentTimeMillis() - start2;
                    if (elapsed > 100L && bg) {
                        LOG.warn("Slow data provider " + provider + " took " + elapsed + "ms on " + dataKey + ". Consider speeding it up and/or implementing BackgroundableDataProvider.");
                    }
                }
            });
        };
    }), ContainerUtil::createConcurrentWeakKeySoftValueMap);

    AsyncDataContext(DataContext syncContext) {
        super(syncContext.getData(PlatformDataKeys.CONTEXT_COMPONENT));
        ApplicationManager.getApplication().assertIsDispatchThread();
        Component component2 = this.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        List<Component> hierarchy = JBIterable.generate(component2, Component::getParent).toList();
        for (Component each : hierarchy) {
            this.myProviders.get(each);
        }
        this.myHierarchy = ContainerUtil.map(hierarchy, WeakReference::new);
    }

    @Override
    protected Object calcData(@NotNull String dataId, Component focused) {
        if (dataId == null) {
            AsyncDataContext.$$$reportNull$$$0(0);
        }
        try (AccessToken ignored = ProhibitAWTEvents.start("getData");){
            for (WeakReference<Component> reference2 : this.myHierarchy) {
                DataProvider dataProvider;
                Component component2 = SoftReference.dereference(reference2);
                if (component2 == null || (dataProvider = this.myProviders.get(component2)) == null) continue;
                Object data2 = ((DataManagerImpl)DataManager.getInstance()).getDataFromProvider(dataProvider, dataId, null);
                if (data2 == null) continue;
                Object object = data2;
                return object;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/actionSystem/impl/AsyncDataContext", "calcData"));
    }
}

