/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.WeakTimerListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class ToolbarUpdater
implements Activatable {
    private final JComponent myComponent;
    private final KeymapManagerListener myKeymapManagerListener;
    private final TimerListener myTimerListener;
    private final WeakTimerListener myWeakTimerListener;
    private boolean myListenersArmed;

    public ToolbarUpdater(@NotNull JComponent component2) {
        if (component2 == null) {
            ToolbarUpdater.$$$reportNull$$$0(0);
        }
        this.myKeymapManagerListener = new MyKeymapManagerListener();
        this.myTimerListener = new MyTimerListener();
        this.myComponent = component2;
        this.myWeakTimerListener = new WeakTimerListener(this.myTimerListener);
        new UiNotifyConnector(component2, this);
    }

    @Override
    public void showNotify() {
        if (this.myListenersArmed) {
            return;
        }
        this.myListenersArmed = true;
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        actionManager.addTimerListener(500, this.myWeakTimerListener);
        actionManager.addTransparentTimerListener(500, this.myWeakTimerListener);
        KeymapManagerEx.getInstanceEx().addWeakListener(this.myKeymapManagerListener);
        this.updateActionTooltips();
    }

    @Override
    public void hideNotify() {
        if (!this.myListenersArmed) {
            return;
        }
        this.myListenersArmed = false;
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        actionManager.removeTimerListener(this.myWeakTimerListener);
        actionManager.removeTransparentTimerListener(this.myWeakTimerListener);
        KeymapManagerEx.getInstanceEx().removeWeakListener(this.myKeymapManagerListener);
    }

    public void updateActions(boolean now, boolean forced) {
        this.updateActions(now, false, forced);
    }

    private void updateActions(boolean now, boolean transparentOnly, boolean forced) {
        MyUpdateRunnable updateRunnable = new MyUpdateRunnable(this, transparentOnly, forced);
        Application app = ApplicationManager.getApplication();
        if (now || app.isUnitTestMode() && app.isDispatchThread()) {
            updateRunnable.run();
        } else if (!app.isHeadlessEnvironment()) {
            IdeFocusManager focusManager = IdeFocusManager.getInstance(null);
            if (app.isDispatchThread() && this.myComponent.isShowing()) {
                focusManager.doWhenFocusSettlesDown(updateRunnable);
            } else {
                UiNotifyConnector.doWhenFirstShown(this.myComponent, () -> focusManager.doWhenFocusSettlesDown(updateRunnable));
            }
        }
    }

    protected abstract void updateActionsImpl(boolean var1, boolean var2);

    protected void updateActionTooltips() {
        for (ActionButton actionButton : UIUtil.uiTraverser(this.myComponent).preOrderDfsTraversal().filter(ActionButton.class)) {
            actionButton.updateToolTipText();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/actionSystem/impl/ToolbarUpdater", "<init>"));
    }

    private static final class MyUpdateRunnable
    implements Runnable {
        private final boolean myTransparentOnly;
        private final boolean myForced;
        @NotNull
        private final WeakReference<ToolbarUpdater> myUpdaterRef;
        private final int myHash;

        MyUpdateRunnable(@NotNull ToolbarUpdater updater2, boolean transparentOnly, boolean forced) {
            if (updater2 == null) {
                MyUpdateRunnable.$$$reportNull$$$0(0);
            }
            this.myTransparentOnly = transparentOnly;
            this.myForced = forced;
            this.myHash = updater2.hashCode();
            this.myUpdaterRef = new WeakReference<ToolbarUpdater>(updater2);
        }

        @Override
        public void run() {
            ToolbarUpdater updater2 = (ToolbarUpdater)this.myUpdaterRef.get();
            if (updater2 == null || !updater2.myComponent.isVisible() && !ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            updater2.updateActionsImpl(this.myTransparentOnly, this.myForced);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyUpdateRunnable)) {
                return false;
            }
            MyUpdateRunnable that = (MyUpdateRunnable)obj;
            if (this.myHash != that.myHash) {
                return false;
            }
            ToolbarUpdater updater1 = (ToolbarUpdater)this.myUpdaterRef.get();
            ToolbarUpdater updater2 = (ToolbarUpdater)that.myUpdaterRef.get();
            return Comparing.equal(updater1, updater2);
        }

        public int hashCode() {
            return this.myHash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/openapi/actionSystem/impl/ToolbarUpdater$MyUpdateRunnable", "<init>"));
        }
    }

    private final class MyTimerListener
    implements TimerListener {
        private MyTimerListener() {
        }

        @Override
        public ModalityState getModalityState() {
            return ModalityState.stateForComponent(ToolbarUpdater.this.myComponent);
        }

        @Override
        public void run() {
            if (!ToolbarUpdater.this.myComponent.isShowing()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
            if (selectedPath.length > 0) {
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window instanceof Dialog && ((Dialog)window).isModal() && !SwingUtilities.isDescendingFrom(ToolbarUpdater.this.myComponent, window)) {
                return;
            }
            ToolbarUpdater.this.updateActions(false, ActionManagerEx.getInstanceEx().isTransparentOnlyActionsUpdateNow(), false);
        }
    }

    private final class MyKeymapManagerListener
    implements KeymapManagerListener {
        private MyKeymapManagerListener() {
        }

        @Override
        public void activeKeymapChanged(Keymap keymap2) {
            ToolbarUpdater.this.updateActionTooltips();
        }
    }
}

